/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.awt.SwConstrainedArea;
import com.openinventor.inventor.awt.SwCursor;
import com.openinventor.inventor.awt.SwFlyPreferences;
import com.openinventor.inventor.awt.SwPreferences;
import com.openinventor.inventor.awt.event.SwActiveAreaKeyboard;
import com.openinventor.inventor.awt.event.SwActiveAreaMouse;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.sensors.SoFieldSensor;
import com.openinventor.util.Scene;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

@Deprecated
public class SwFlyArea
extends SwConstrainedArea {
    protected static String[] mouseHelp = new String[]{"HELP_MOUSE_FLY_SPEED_UP", "HELP_MOUSE_FLY_SPEED_DOWN", "HELP_MOUSE_FLY_STOP", "HELP_MOUSE_FLY_MENU"};
    private static final short CROSS = 12;
    private static final float MIN_SPEED = 0.02f;
    private static final float MAX_INC = 1.5f;
    private static final float TURN_SPEED = 2.5132742f;
    private static final float WHEEL_DOLLY_FACTOR = 0.5f;
    private Scene.ViewingModes mode;
    private SbRotation camStartOrientation;
    protected SoFieldSensor animationSensor;
    private long prevAnimTime;
    private float speed;
    private float maxSpeed;
    private float maxStraightSpeed;
    private float speedLimit;
    private float speedLimitFactor;

    public SwFlyArea(int n) {
        super(n);
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwFlyArea.SwFlyArea");
        }
        this.addMouseDevice(new SwFlyAreaMouse());
        this.addKeyboardDevice(new SwFlyAreaKeyboard());
        this.mode = Scene.ViewingModes.STILL_MODE;
        this.speedLimitFactor = 0.5f;
        this.camStartOrientation = new SbRotation();
        this.animationSensor = new SoFieldSensor();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.animationSensor.setTask(new AnimationSensorTask());
        if (this.mode == Scene.ViewingModes.FLY_MODE) {
            this.animationSensor.attach(areaRealTime);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.animationSensor.detach();
    }

    @Override
    public SwPreferences getPreferencesPanel() {
        if (this.preferences == null) {
            this.preferences = new SwFlyPreferences(this);
        }
        return this.preferences;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void setViewing(boolean bl, AWTEvent aWTEvent) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwFlyArea.setViewing");
        }
        if (bl == this.viewingFlag) {
            return;
        }
        super.setViewing(bl, aWTEvent);
        this.updateCursor();
        if (this.mode != Scene.ViewingModes.STILL_MODE) {
            this.setMode(Scene.ViewingModes.STILL_MODE, aWTEvent);
        } else {
            this.scheduleRedraw();
        }
    }

    @Override
    public void updateCursor() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->ExaminerArea.updateCursor");
        }
        if (!this.isViewing()) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            switch (this.mode) {
                case STILL_MODE: 
                case FLY_MODE: 
                case TILT_MODE: {
                    this.setCursor(SwCursor.getPredefinedCursor(100));
                    break;
                }
                case SEEK_MODE: {
                    this.setCursor(SwCursor.getPredefinedCursor(105));
                    break;
                }
                case SET_UP_MODE: {
                    this.setCursor(SwCursor.getPredefinedCursor(106));
                }
            }
        }
    }

    @Override
    public void setCamera(SoCamera soCamera) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwExaminerArea.setCamera camera = " + this.camera);
        }
        if (this.camera == soCamera) {
            return;
        }
        super.setCamera(soCamera);
        if (this.camera != null && this.camera instanceof SoOrthographicCamera) {
            this.toggleCameraClass();
        }
    }

    @Override
    public void setCameraClass(Class clazz) {
    }

    @Override
    public void resetToHomePosition() {
        super.resetToHomePosition();
        this.setMode(Scene.ViewingModes.STILL_MODE, null);
    }

    @Override
    public void setSeekMode(boolean bl) {
        super.setSeekMode(bl);
        this.setMode(this.isSeekMode() ? Scene.ViewingModes.SEEK_MODE : (this.isViewing() ? Scene.ViewingModes.STILL_MODE : Scene.ViewingModes.PICK_MODE), null);
    }

    @Override
    protected void actualRedraw() {
        super.actualRedraw();
        if (this.isViewing() && this.camera != null) {
            this.setFeedbackOrthoProjection(this.getSize());
            this.drawAreaFeedback();
            this.restoreGLStateAfterFeedback();
        }
    }

    @Override
    protected void drawAreaFeedback() {
        super.drawAreaFeedback();
        if (this.mode == Scene.ViewingModes.TILT_MODE) {
            this.drawCrossFeedback(this.startPos, (short)12, 1, true);
        }
    }

    @Override
    public Scene.ViewingModes getMode() {
        return this.mode;
    }

    @Override
    public void setMode(Scene.ViewingModes viewingModes, AWTEvent aWTEvent) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwFlyArea.setMode (" + viewingModes + ")");
        }
        if (this.mode == viewingModes) {
            return;
        }
        boolean bl = true;
        Scene.ViewingModes viewingModes2 = this.mode;
        this.mode = viewingModes;
        this.updateCursor();
        switch (viewingModes2) {
            case FLY_MODE: {
                this.animationSensor.detach();
                this.animationSensor.unschedule();
                this.interactiveCountDec();
            }
        }
        switch (viewingModes) {
            case FLY_MODE: {
                this.animationSensor.attach(areaRealTime);
                this.animationSensor.schedule();
                this.prevAnimTime = System.currentTimeMillis();
                this.interactiveCountInc();
                this.maxStraightSpeed = 0.0f;
                this.maxSpeed = 0.0f;
                this.setSpeed(this.maxSpeed);
                this.speedLimit = this.sceneSize * this.speedLimitFactor;
                bl = false;
                break;
            }
            case TILT_MODE: {
                this.startPos.setValue(this.locator);
                this.camStartOrientation.setValue(this.camera.orientation.getValue());
            }
        }
        if (bl) {
            this.scheduleRedraw();
        }
    }

    public void changeMaxStraightSpeed(boolean bl) {
        if (this.maxStraightSpeed == 0.0f) {
            this.maxStraightSpeed = bl ? 0.02f * this.speedLimit : -0.02f * this.speedLimit;
        } else {
            this.maxStraightSpeed = this.maxStraightSpeed > 0.0f && bl || this.maxStraightSpeed < 0.0f && !bl ? (this.maxStraightSpeed *= 1.5f) : (this.maxStraightSpeed /= 1.5f);
            if (this.maxStraightSpeed > this.speedLimit) {
                this.maxStraightSpeed = this.speedLimit;
            } else if (this.maxStraightSpeed < -this.speedLimit) {
                this.maxStraightSpeed = -this.speedLimit;
            }
            float f = 0.02f * this.speedLimit;
            if (this.maxStraightSpeed > -f && this.maxStraightSpeed < f) {
                this.setMode(Scene.ViewingModes.STILL_MODE, null);
                return;
            }
        }
        this.calculateMaxSpeed();
    }

    public void calculateMaxSpeed() {
        float f;
        Dimension dimension = this.getSize();
        float f2 = (float)(2 * (this.locator.getX() - dimension.width / 2)) / (float)dimension.width;
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if ((f = (float)(2 * (this.locator.getY() - dimension.height / 2)) / (float)dimension.height) < 0.0f) {
            f = -f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        float f3 = this.maxSpeed = f2 > f ? (1.0f - f2) * this.maxStraightSpeed : (1.0f - f) * this.maxStraightSpeed;
        if (this.speed > 0.0f && this.speed > this.maxSpeed || this.speed < 0.0f && this.speed < this.maxSpeed) {
            this.setSpeed(this.maxSpeed);
        }
    }

    protected void doCameraAnimation() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwFlyArea.doCameraAnimation");
        }
        if (this.camera == null) {
            return;
        }
        long l = System.currentTimeMillis();
        float f = 0.001f * (float)(l - this.prevAnimTime);
        this.prevAnimTime = l;
        if ((double)f == 0.0) {
            f = 0.013888889f;
        }
        Dimension dimension = this.getSize();
        float f2 = (float)(this.locator.getX() - dimension.width / 2) / (float)dimension.width;
        float f3 = 2.5132742f * (f2 * f2) * f;
        if (f3 != 0.0f) {
            if (f2 < 0.0f) {
                f3 = -f3;
            }
            SbRotation sbRotation = new SbRotation(this.upDirection, -f3);
            SbRotation sbRotation2 = this.camera.orientation.getValue().times(sbRotation);
            this.camera.orientation.setValue(sbRotation2);
        }
        f2 = (float)(this.locator.getY() - dimension.height / 2) / (float)dimension.height;
        f3 = 2.5132742f * (f2 * f2) * f;
        if (f2 < 0.0f) {
            f3 = -f3;
        }
        if (f3 != 0.0f) {
            this.tiltCamera(f3);
        }
        this.dollyCamera(this.speed * f);
        if (this.speed > 0.0f && this.speed < this.maxSpeed || this.speed < 0.0f && this.speed > this.maxSpeed) {
            this.setSpeed(this.speed * (float)Math.pow(3.0, f));
            if (this.speed > 0.0f && this.speed > this.maxSpeed || this.speed < 0.0f && this.speed < this.maxSpeed) {
                this.setSpeed(this.maxSpeed);
            }
        }
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float f) {
        this.speed = f;
    }

    public float getSpeedLimit() {
        return this.speedLimit;
    }

    public void setSpeedLimit(float f) {
        this.speedLimit = f;
    }

    public float getSpeedLimitFactor() {
        return this.speedLimitFactor;
    }

    public void setSpeedLimitFactor(float f) {
        this.speedLimitFactor = f;
    }

    public float getMaxStraightSpeed() {
        return this.maxStraightSpeed;
    }

    public void setMaxStraightSpeed(float f) {
        this.maxStraightSpeed = f;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float f) {
        this.maxSpeed = f;
    }

    public SoFieldSensor getAnimationSensor() {
        return this.animationSensor;
    }

    public void setPrevAnimTime(SbTime sbTime) {
        double d = sbTime.getDoubleValue() * 1000.0;
        this.prevAnimTime = (long)d;
    }

    public SbRotation getCamStartOrientation() {
        return this.camStartOrientation;
    }

    @Override
    public String[] getMouseResourcesName() {
        return mouseHelp;
    }

    class SwFlyAreaKeyboard
    extends SwActiveAreaKeyboard {
        SwFlyAreaKeyboard() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            super.keyPressed(keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
            SoKeyboardEvent.Keys keys = SoKeyboardEvent.getKeySym(keyEvent.getKeyCode());
            int n = keyEvent.getModifiers();
            Dimension dimension = SwFlyArea.this.getSize();
            switch (keys) {
                case U: {
                    if (SwFlyArea.this.isSeekMode()) {
                        SwFlyArea.this.setSeekMode(false);
                    }
                    SwFlyArea.this.setMode(SwFlyArea.this.mode == Scene.ViewingModes.SET_UP_MODE ? Scene.ViewingModes.STILL_MODE : Scene.ViewingModes.SET_UP_MODE, keyEvent);
                    break;
                }
                case LEFT_CONTROL: 
                case RIGHT_CONTROL: {
                    if (SwFlyArea.this.mode != Scene.ViewingModes.STILL_MODE && SwFlyArea.this.mode != Scene.ViewingModes.FLY_MODE) break;
                    SwFlyArea.this.interactiveCountInc();
                    SwFlyArea.this.setMode(Scene.ViewingModes.TILT_MODE, keyEvent);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            super.keyReleased(keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
            SoKeyboardEvent.Keys keys = SoKeyboardEvent.getKeySym(keyEvent.getKeyCode());
            int n = keyEvent.getModifiers();
            switch (keys) {
                case LEFT_CONTROL: 
                case RIGHT_CONTROL: {
                    if (SwFlyArea.this.mode != Scene.ViewingModes.TILT_MODE) break;
                    SwFlyArea.this.setMode(Scene.ViewingModes.STILL_MODE, keyEvent);
                    SwFlyArea.this.interactiveCountDec();
                }
            }
        }
    }

    class SwFlyAreaMouse
    extends SwActiveAreaMouse {
        SwFlyAreaMouse() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl;
            if (!SwFlyArea.this.isViewing()) {
                return;
            }
            int n = mouseEvent.getButton();
            boolean bl2 = bl = n == 1;
            if (!bl && n != 2) {
                return;
            }
            int n2 = mouseEvent.getModifiersEx();
            boolean bl3 = (n2 & 0x400) != 0 && (n2 & 0x800) != 0;
            Dimension dimension = SwFlyArea.this.getSize();
            SwFlyArea.this.setLocator(mouseEvent.getX(), dimension.height - mouseEvent.getY());
            switch (SwFlyArea.this.mode) {
                case STILL_MODE: {
                    if (bl3) break;
                    SwFlyArea.this.setMode(Scene.ViewingModes.FLY_MODE, mouseEvent);
                    SwFlyArea.this.changeMaxStraightSpeed(bl);
                    SwFlyArea.this.setSpeed(SwFlyArea.this.maxSpeed);
                    break;
                }
                case FLY_MODE: {
                    if (bl3) {
                        SwFlyArea.this.setMode(Scene.ViewingModes.STILL_MODE, mouseEvent);
                        break;
                    }
                    SwFlyArea.this.changeMaxStraightSpeed(bl);
                    break;
                }
                case SEEK_MODE: {
                    if (!bl) break;
                    SwFlyArea.this.seekToPoint(SwFlyArea.this.locator);
                    break;
                }
                case SET_UP_MODE: {
                    if (!bl) break;
                    SwFlyArea.this.findUpDirection(SwFlyArea.this.locator);
                    SwFlyArea.this.setMode(Scene.ViewingModes.STILL_MODE, mouseEvent);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.mouseDragged(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Dimension dimension = SwFlyArea.this.getSize();
            SwFlyArea.this.setLocator(mouseEvent.getX(), dimension.height - mouseEvent.getY());
            switch (SwFlyArea.this.mode) {
                case FLY_MODE: {
                    SwFlyArea.this.calculateMaxSpeed();
                    break;
                }
                case TILT_MODE: {
                    float f;
                    SwFlyArea.this.camera.orientation.setValue(SwFlyArea.this.camStartOrientation);
                    if (SwFlyArea.this.locator.getX() != SwFlyArea.this.startPos.getX()) {
                        f = (float)(SwFlyArea.this.startPos.getX() - SwFlyArea.this.locator.getX()) / (float)dimension.width;
                        SbRotation sbRotation = new SbRotation(SwFlyArea.this.upDirection, (float)((double)(f * 2.0f) * Math.PI));
                        SbRotation sbRotation2 = SwFlyArea.this.camera.orientation.getValue().times(sbRotation);
                        SwFlyArea.this.camera.orientation.setValue(sbRotation2);
                    }
                    if (SwFlyArea.this.locator.getY() == SwFlyArea.this.startPos.getY()) break;
                    f = (float)(SwFlyArea.this.locator.getY() - SwFlyArea.this.startPos.getY()) / (float)dimension.height;
                    SwFlyArea.this.tiltCamera((float)((double)(f * 2.0f) * Math.PI));
                }
            }
        }
    }

    class AnimationSensorTask
    implements Runnable {
        AnimationSensorTask() {
        }

        @Override
        public void run() {
            SwFlyArea.this.doCameraAnimation();
        }
    }
}

