/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.awt.CheckboxMenuGroup;
import com.openinventor.awt.GroupedCheckboxMenuItem;
import com.openinventor.awt.event.SliderAdapter;
import com.openinventor.awt.event.SliderEvent;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.awt.SwColorEditor;
import com.openinventor.inventor.awt.SwColorSlider;
import com.openinventor.inventor.awt.SwMaterialList;
import com.openinventor.inventor.awt.SwPanel;
import com.openinventor.inventor.awt.SwRenderArea;
import com.openinventor.inventor.awt.SwResources;
import com.openinventor.inventor.fields.SoMFColor;
import com.openinventor.inventor.fields.SoSFColor;
import com.openinventor.inventor.misc.SoCallbackList;
import com.openinventor.inventor.misc.callbacks.SoCallbackListCB;
import com.openinventor.inventor.nodes.SoBaseColor;
import com.openinventor.inventor.nodes.SoComplexity;
import com.openinventor.inventor.nodes.SoCoordinate3;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoMaterialBinding;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoQuadMesh;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.sensors.SoNodeSensor;
import com.openinventor.inventor.vrmlnodes.SoVRMLMaterial;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;

@Deprecated
public class SwMaterialEditor
extends Frame {
    public static final int CONTINUOUS = 0;
    public static final int AFTER_ACCEPT = 1;
    private static final int SCENE_RIGHT_POSITION = 36;
    private static final int OFFSET = 5;
    private static final int SLIDER_SPACE = 50;
    static final int k_MATERIAL_LIST = 0;
    static final int k_CONTINUOUS = 1;
    static final int k_AFTER_ACCEPT = 2;
    static final int k_EDIT_COPY = 3;
    static final int k_EDIT_PASTE = 4;
    static final int k_EDIT_HELP = 5;
    static final int k_EDIT_CLOSE = 6;
    static final int k_MENU_NUM = 7;
    static final int k_AMBIENT_ID = 0;
    static final int k_DIFFUSE_ID = 1;
    static final int k_SPECULAR_ID = 2;
    static final int k_EMISSIVE_ID = 3;
    static final int k_SHININESS_ID = 4;
    static final int k_TRANSPARENCY_ID = 5;
    static final long k_none = 0L;
    static final long k_ambient = 1L;
    static final long k_diffuse = 2L;
    static final long k_specular = 4L;
    static final long k_emissive = 8L;
    static final long k_shininess = 16L;
    static final long k_transparency = 32L;
    private static final String fileSep = System.getProperty("file.separator");
    static final String mtlDir = fileSep + "usr" + fileSep + "share" + fileSep + "data" + fileSep + "materials";
    private static final float[][] tileColors = new float[][]{{0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.3f, 0.3f}};
    private static final float[][] tileCoords = new float[][]{{-3.0f, 3.0f, 0.0f}, {0.0f, 3.0f, 0.0f}, {3.0f, 3.0f, 0.0f}, {-3.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {3.0f, 0.0f, 0.0f}, {-3.0f, -3.0f, 0.0f}, {0.0f, -3.0f, 0.0f}, {3.0f, -3.0f, 0.0f}};
    private SoNode material;
    private SoMaterial imat;
    private SoVRMLMaterial vmat;
    private boolean isVRMLMaterial;
    private int index;
    private SoNodeSensor sensor;
    private SoCallbackList callbackList;
    private Button acceptButton;
    private Checkbox[] diamondButtons;
    private Checkbox[] radioButtons;
    private int updateFreq;
    private SwColorEditor colorEditor;
    private SwColorSlider[] sliders;
    private boolean[] changedIt;
    private SwMaterialList materialList;
    private boolean ignoreCallback;
    private boolean openMaterialList;
    private SwRenderArea renderArea;
    private SoMaterial localMaterial;
    private SoDirectionalLight light0;
    private SoDirectionalLight light1;
    private SoBaseColor tileColor;
    private SoSeparator root;
    private long activeColor;
    private SwResources resources;
    private Locale defaultLocale = SwPanel.defaultLocale;
    private MenuBar menubar;
    private Menu menuEdit;
    private MenuItem menuMatList;
    private MenuItem menuCopy;
    private MenuItem menuPaste;
    private MenuItem menuHelp;
    private MenuItem menuClose;
    private GroupedCheckboxMenuItem menuCheckCont;
    private GroupedCheckboxMenuItem menuCheckMan;
    private CheckboxMenuGroup groupEdit;
    private Label sliderTitle;
    private Label labelAmb;
    private Label labelDiff;
    private Label labelSpec;
    private Label labelEmis;
    private Label labelShininess;
    private Label labelTransp;

    public SwMaterialEditor() {
        super(SwPanel.resources.getString("ME_TITLE"));
        this.resources = (SwResources)ResourceBundle.getBundle("com.openinventor.inventor.awt.SwResources", this.defaultLocale);
        this.addComponentListener(new ListenVisibility());
        this.activeColor = 0L;
        this.ignoreCallback = false;
        this.callbackList = new SoCallbackList();
        this.updateFreq = 0;
        this.sliders = new SwColorSlider[6];
        this.changedIt = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            this.changedIt[i] = false;
        }
        this.isVRMLMaterial = false;
        this.localMaterial = new SoMaterial();
        this.light0 = new SoDirectionalLight();
        this.light1 = new SoDirectionalLight();
        this.tileColor = new SoBaseColor();
        this.root = new SoSeparator();
        SoOrthographicCamera soOrthographicCamera = new SoOrthographicCamera();
        SoComplexity soComplexity = new SoComplexity();
        SoSphere soSphere = new SoSphere();
        SoCoordinate3 soCoordinate3 = new SoCoordinate3();
        SoQuadMesh soQuadMesh = new SoQuadMesh();
        SoMaterialBinding soMaterialBinding = new SoMaterialBinding();
        SoLightModel soLightModel = new SoLightModel();
        SoLightModel soLightModel2 = new SoLightModel();
        this.root.addChild(soOrthographicCamera);
        this.root.addChild(soLightModel);
        this.root.addChild(this.tileColor);
        this.root.addChild(soMaterialBinding);
        this.root.addChild(soCoordinate3);
        this.root.addChild(soQuadMesh);
        this.root.addChild(soLightModel2);
        this.root.addChild(this.light0);
        this.root.addChild(this.light1);
        this.root.addChild(this.localMaterial);
        this.root.addChild(soComplexity);
        this.root.addChild(soSphere);
        soOrthographicCamera.position.setValue(0.0f, 0.0f, 2.0f);
        soOrthographicCamera.nearDistance.setValue(1.0f);
        soOrthographicCamera.farDistance.setValue(3.0f);
        soOrthographicCamera.height.setValue(2.0f);
        soComplexity.value.setValue(0.8f);
        soSphere.radius.setValue(0.85f);
        this.tileColor.rgb.setValues(0, tileColors);
        soMaterialBinding.value.setValue(SoMaterialBinding.Bindings.PER_FACE);
        soCoordinate3.point.setValues(0, tileCoords);
        soQuadMesh.verticesPerColumn.setValue(3);
        soQuadMesh.verticesPerRow.setValue(3);
        soLightModel.model.setValue(SoLightModel.Models.BASE_COLOR);
        soLightModel2.model.setValue(SoLightModel.Models.PHONG);
        this.light0.direction.setValue(0.556f, -0.623f, -0.551f);
        this.light1.direction.setValue(-0.556f, -0.623f, -0.551f);
        this.sensor = new SoNodeSensor(new SensorTask());
        this.buildGUI();
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SwMaterialEditor.this.setVisible(false);
            }
        };
        this.addWindowListener(windowAdapter);
    }

    protected void finalize() throws Throwable {
        if (this.isAttached()) {
            this.detach();
        }
        super.finalize();
    }

    public void setResources(Locale locale) {
        if (locale != null) {
            this.resources = (SwResources)ResourceBundle.getBundle("com.openinventor.inventor.awt.SwResources", locale);
            this.defaultLocale = locale;
        }
        if (this.materialList != null) {
            this.materialList.setResources(locale);
        }
        if (this.colorEditor != null) {
            this.colorEditor.setResources(locale);
            switch ((int)this.activeColor) {
                case 0: {
                    break;
                }
                case 1: {
                    this.colorEditor.setTitle(this.resources.getString("M_AMBIENT_TITLE"));
                    break;
                }
                case 2: {
                    this.colorEditor.setTitle(this.resources.getString("M_DIFFUSE_TITLE"));
                    break;
                }
                case 4: {
                    this.colorEditor.setTitle(this.resources.getString("M_SPECULAR_TITLE"));
                    break;
                }
                case 8: {
                    this.colorEditor.setTitle(this.resources.getString("M_EMISSIVE_TITLE"));
                    break;
                }
                default: {
                    StringBuffer stringBuffer = new StringBuffer(512);
                    stringBuffer.append(this.resources.getString("M_MATERIAL"));
                    if ((this.activeColor & 1L) != 0L) {
                        stringBuffer.append(this.resources.getString("M_AMB"));
                    }
                    if ((this.activeColor & 2L) != 0L) {
                        stringBuffer.append(this.resources.getString("M_DIFF"));
                    }
                    if ((this.activeColor & 4L) != 0L) {
                        stringBuffer.append(this.resources.getString("M_SPEC"));
                    }
                    if ((this.activeColor & 8L) != 0L) {
                        stringBuffer.append(this.resources.getString("M_EMIS"));
                    }
                    stringBuffer.append(' ');
                    stringBuffer.append(this.resources.getString("M_COLOR"));
                    this.colorEditor.setTitle(stringBuffer.toString());
                }
            }
        }
        this.setTitle(this.resources.getString("ME_TITLE"));
        this.menuEdit.setLabel(this.resources.getString("ME_MENU_EDIT"));
        this.menuMatList.setLabel(this.resources.getString("ME_EDIT_MATLIST"));
        this.menuCopy.setLabel(this.resources.getString("ME_EDIT_COPY"));
        this.menuPaste.setLabel(this.resources.getString("ME_EDIT_PASTE"));
        this.menuHelp.setLabel(this.resources.getString("ME_EDIT_HELP"));
        this.menuClose.setLabel(this.resources.getString("ME_EDIT_CLOSE"));
        this.menuCheckCont.setLabel(this.resources.getString("ME_EDIT_CONTINUOUS"));
        this.menuCheckMan.setLabel(this.resources.getString("ME_EDIT_MANUAL"));
        this.sliderTitle.setText(this.resources.getString("ME_EDIT_COLOR"));
        this.labelAmb.setText(this.resources.getString("M_AMBIENT_TITLE"));
        this.labelDiff.setText(this.resources.getString("M_DIFFUSE_TITLE"));
        this.labelSpec.setText(this.resources.getString("M_SPECULAR_TITLE"));
        this.labelEmis.setText(this.resources.getString("M_EMISSIVE_TITLE"));
        this.labelShininess.setText(this.resources.getString("M_SHININESS_TITLE"));
        this.labelTransp.setText(this.resources.getString("M_TRANSP_TITLE"));
        this.acceptButton.setLabel(this.resources.getString("ME_BUTTON_ACCEPT"));
    }

    public void attach(SoMaterial soMaterial) {
        this.attach(soMaterial, 0);
    }

    public void attach(SoMaterial soMaterial, int n) {
        if (this.isAttached()) {
            this.detach();
        }
        if (soMaterial != null && n >= 0) {
            this.material = soMaterial;
            this.index = n;
            this.imat = soMaterial;
            this.vmat = null;
            this.isVRMLMaterial = false;
            for (int i = 0; i < 6; ++i) {
                this.changedIt[i] = false;
            }
            if (this.isVisible()) {
                this.activate();
            }
        }
    }

    public void attach(SoVRMLMaterial soVRMLMaterial) {
        if (this.isAttached()) {
            this.detach();
        }
        if (soVRMLMaterial != null) {
            this.material = soVRMLMaterial;
            this.index = 0;
            this.imat = null;
            this.vmat = soVRMLMaterial;
            this.isVRMLMaterial = true;
            this.diamondButtons[0].setState(false);
            this.radioButtons[0].setState(false);
            for (int i = 0; i < 6; ++i) {
                this.changedIt[i] = false;
            }
            if (this.isVisible()) {
                this.activate();
            }
        }
    }

    public void detach() {
        if (!this.isAttached()) {
            return;
        }
        this.deactivate();
        this.material = null;
        this.imat = null;
        this.vmat = null;
    }

    public boolean isAttached() {
        return this.material != null;
    }

    public void addMaterialChangedCallback(SoCallbackListCB soCallbackListCB, Object object) {
        this.callbackList.addCallback(soCallbackListCB, object);
    }

    public void removeMaterialChangedCallback(SoCallbackListCB soCallbackListCB, Object object) {
        this.callbackList.removeCallback(soCallbackListCB, object);
    }

    public void setUpdateFrequency(int n) {
        if (this.updateFreq == n) {
            return;
        }
        this.updateFreq = n;
        if (this.acceptButton != null) {
            if (this.updateFreq == 0) {
                this.acceptButton.setVisible(false);
            } else {
                this.acceptButton.setVisible(true);
            }
        }
        if (this.material != null && this.updateFreq == 0) {
            this.copyMaterial(this.material, this.index, this.localMaterial, 0);
            this.undoIgnoresIfChanged();
        }
    }

    public int getUpdateFrequency() {
        return this.updateFreq;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.colorEditor != null && this.activeColor != 0L) {
            this.colorEditor.setVisible(bl);
        }
        if (this.materialList != null) {
            this.materialList.setVisible(bl);
        }
    }

    public void setMaterial(SoMaterial soMaterial) {
        this.copyMaterial(this.localMaterial, 0, soMaterial, 0);
        this.updateLocalComponents();
        for (int i = 0; i < 6; ++i) {
            this.changedIt[i] = true;
        }
        if (this.material != null && this.updateFreq == 0) {
            this.sensor.detach();
            this.copyMaterial(this.material, this.index, soMaterial, 0);
            this.undoIgnoresIfChanged();
            this.sensor.attach(this.material);
        }
        if (this.updateFreq == 0) {
            this.callbackList.invokeCallbacks(this.localMaterial);
        }
    }

    public void setMaterial(SoVRMLMaterial soVRMLMaterial) {
        this.copyMaterial(this.localMaterial, 0, soVRMLMaterial, 0);
        this.updateLocalComponents();
        for (int i = 0; i < 6; ++i) {
            this.changedIt[i] = true;
        }
        if (this.material != null && this.updateFreq == 0) {
            this.sensor.detach();
            this.copyMaterial(this.material, this.index, soVRMLMaterial, 0);
            this.undoIgnoresIfChanged();
            this.sensor.attach(this.material);
        }
        if (this.updateFreq == 0) {
            this.callbackList.invokeCallbacks(this.localMaterial);
        }
    }

    public SoMaterial getMaterial() {
        return this.localMaterial;
    }

    public boolean isAttachedVRML() {
        return this.isVRMLMaterial;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(420, 260);
    }

    private MenuBar buildMenu() {
        this.menubar = new MenuBar();
        this.menuEdit = new Menu(this.resources.getString("ME_MENU_EDIT"));
        this.menubar.add(this.menuEdit);
        this.menuEdit.addActionListener(new MenuDisplay());
        this.menuMatList = new MenuItem(this.resources.getString("ME_EDIT_MATLIST"));
        this.groupEdit = new CheckboxMenuGroup();
        this.menuCheckCont = new GroupedCheckboxMenuItem(this.resources.getString("ME_EDIT_CONTINUOUS"), this.groupEdit);
        this.menuCheckMan = new GroupedCheckboxMenuItem(this.resources.getString("ME_EDIT_MANUAL"), this.groupEdit);
        this.menuCopy = new MenuItem(this.resources.getString("ME_EDIT_COPY"));
        this.menuPaste = new MenuItem(this.resources.getString("ME_EDIT_PASTE"));
        this.menuHelp = new MenuItem(this.resources.getString("ME_EDIT_HELP"));
        this.menuClose = new MenuItem(this.resources.getString("ME_EDIT_CLOSE"));
        this.menuEdit.add(this.menuMatList);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuCheckCont);
        this.menuEdit.add(this.menuCheckMan);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuCopy);
        this.menuEdit.add(this.menuPaste);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuHelp);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.menuClose);
        this.menuMatList.addActionListener(new MenuPick(0));
        this.menuCheckCont.addItemListener(new MenuPick(1));
        this.menuCheckMan.addItemListener(new MenuPick(2));
        this.menuCopy.addActionListener(new MenuPick(3));
        this.menuPaste.addActionListener(new MenuPick(4));
        this.menuHelp.addActionListener(new MenuPick(5));
        this.menuClose.addActionListener(new MenuPick(6));
        return this.menubar;
    }

    private GridBagConstraints constraints(int n, int n2, int n3, int n4, float f, float f2, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = f;
        gridBagConstraints.weighty = f2;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.ipadx = n7;
        gridBagConstraints.ipady = n8;
        gridBagConstraints.insets = new Insets(n9, n10, n11, n12);
        return gridBagConstraints;
    }

    private void buildSliders(GridBagLayout gridBagLayout) {
        int n;
        Label[] labelArray = new Label[6];
        for (n = 0; n < 6; ++n) {
            this.sliders[n] = new SwColorSlider(6, 0);
            this.changedIt[n] = false;
        }
        SbColor sbColor = new SbColor(1.0f, 1.0f, 1.0f);
        this.ignoreCallback = true;
        this.sliders[4].setBaseColor(sbColor.getValue());
        this.sliders[5].setBaseColor(sbColor.getValue());
        this.ignoreCallback = false;
        this.sliders[0].addSliderListener(new AmbientSlider());
        this.sliders[1].addSliderListener(new DiffuseSlider());
        this.sliders[2].addSliderListener(new SpecularSlider());
        this.sliders[3].addSliderListener(new EmissiveSlider());
        this.sliders[4].addSliderListener(new ShininessSlider());
        this.sliders[5].addSliderListener(new TransparencySlider());
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.diamondButtons = new Checkbox[4];
        this.radioButtons = new Checkbox[4];
        for (n = 0; n < 4; ++n) {
            this.diamondButtons[n] = new Checkbox(null, checkboxGroup, false);
            this.diamondButtons[n].addItemListener(new DiamondButtonPick(n));
            this.radioButtons[n] = new Checkbox(null, false);
            this.radioButtons[n].addItemListener(new RadioButtonPick(n));
        }
        this.labelAmb = new Label(this.resources.getString("M_AMBIENT_TITLE"), 2);
        this.labelDiff = new Label(this.resources.getString("M_DIFFUSE_TITLE"), 2);
        this.labelSpec = new Label(this.resources.getString("M_SPECULAR_TITLE"), 2);
        this.labelEmis = new Label(this.resources.getString("M_EMISSIVE_TITLE"), 2);
        this.labelShininess = new Label(this.resources.getString("M_SHININESS_TITLE"), 2);
        this.labelTransp = new Label(this.resources.getString("M_TRANSP_TITLE"), 2);
        labelArray[0] = this.labelAmb;
        labelArray[1] = this.labelDiff;
        labelArray[2] = this.labelSpec;
        labelArray[3] = this.labelEmis;
        labelArray[4] = this.labelShininess;
        labelArray[5] = this.labelTransp;
        GridBagConstraints gridBagConstraints = this.constraints(1, 0, 1, 1, 0.0f, 0.0f, 13, 0, 0, 0, 0, 0, 0, 1);
        for (int i = 0; i < 6; ++i) {
            gridBagConstraints.gridy = i + 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            if (i < 4) {
                gridBagConstraints.gridx = 1;
                gridBagLayout.setConstraints(this.diamondButtons[i], gridBagConstraints);
                this.add(this.diamondButtons[i]);
                gridBagConstraints.gridx = 2;
                gridBagLayout.setConstraints(this.radioButtons[i], gridBagConstraints);
                this.add(this.radioButtons[i]);
                gridBagConstraints.gridx = 3;
                gridBagLayout.setConstraints(labelArray[i], gridBagConstraints);
                this.add(labelArray[i]);
            } else {
                gridBagConstraints.gridx = 1;
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridwidth = 3;
                gridBagLayout.setConstraints(labelArray[i], gridBagConstraints);
                this.add(labelArray[i]);
            }
            gridBagConstraints.gridx = 4;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(this.sliders[i], gridBagConstraints);
            this.add(this.sliders[i]);
        }
    }

    private void buildControls(GridBagLayout gridBagLayout) {
        this.sliderTitle = new Label(this.resources.getString("ME_EDIT_COLOR"), 0);
        this.buildSliders(gridBagLayout);
        gridBagLayout.setConstraints(this.sliderTitle, this.constraints(1, 0, 4, 1, 1.0f, 0.0f, 18, 0, 0, 0, 2, 2, 2, 2));
        this.add(this.sliderTitle);
    }

    private void buildGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        MenuBar menuBar = this.buildMenu();
        this.renderArea = new SwRenderArea();
        this.renderArea.setSceneGraph(this.root);
        this.renderArea.setTransparencyType(SoGLRenderAction.TransparencyTypes.BLEND);
        this.renderArea.setClearBeforeRender(false);
        this.buildControls(gridBagLayout);
        this.acceptButton = new Button(this.resources.getString("ME_BUTTON_ACCEPT"));
        this.acceptButton.addActionListener(new AcceptButton());
        this.setMenuBar(menuBar);
        gridBagLayout.setConstraints(this.renderArea, this.constraints(0, 0, 1, 7, 1.0f, 1.0f, 18, 1, 0, 0, 2, 2, 2, 2));
        this.add(this.renderArea);
        gridBagLayout.setConstraints(this.acceptButton, this.constraints(0, 7, 1, 1, 1.0f, 1.0f, 10, 0, 0, 0, 2, 2, 2, 2));
        this.add(this.acceptButton);
        if (this.updateFreq == 1) {
            this.acceptButton.setVisible(false);
        }
        this.updateLocalComponents();
        this.pack();
    }

    private void updateLocalComponents() {
        if (this.isVRMLMaterial) {
            float[] fArray = this.localMaterial.ambientColor.getValueAt(0).getValue();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            SbColor sbColor = new SbColor(this.localMaterial.diffuseColor.getValueAt(0).getValue());
            fArray = sbColor.getValue();
            float f4 = fArray[0];
            float f5 = fArray[1];
            float f6 = fArray[2];
            float f7 = 0.0f;
            if (f > 0.0f && f4 > 0.0f) {
                f7 = f / f4;
            } else if (f2 > 0.0f && f5 > 0.0f) {
                f7 = f2 / f5;
            } else if (f3 > 0.0f && f6 > 0.0f) {
                f7 = f3 / f6;
            }
            this.ignoreCallback = true;
            this.sliders[0].setBaseColor(sbColor.getValue());
            this.sliders[0].setValue(f7);
            this.ignoreCallback = false;
        } else {
            this.updateColorSlider(this.sliders[0], this.localMaterial.ambientColor.getValueAt(0).getValue());
        }
        this.updateColorSlider(this.sliders[1], this.localMaterial.diffuseColor.getValueAt(0).getValue());
        this.updateColorSlider(this.sliders[2], this.localMaterial.specularColor.getValueAt(0).getValue());
        this.updateColorSlider(this.sliders[3], this.localMaterial.emissiveColor.getValueAt(0).getValue());
        this.ignoreCallback = true;
        this.sliders[4].setValue(this.localMaterial.shininess.getValueAt(0));
        this.sliders[5].setValue(this.localMaterial.transparency.getValueAt(0));
        this.ignoreCallback = false;
        this.updateColorEditor();
    }

    private void updateColorEditor() {
        this.updateColorEditor(false);
    }

    private void updateColorEditor(boolean bl) {
        if (this.activeColor == 0L) {
            if (this.colorEditor == null || !this.colorEditor.isVisible()) {
                return;
            }
            this.colorEditor.setVisible(false);
            return;
        }
        if (this.colorEditor == null) {
            this.colorEditor = new SwColorEditor();
            this.colorEditor.setCurrentSliders(0);
            this.colorEditor.setResources(this.defaultLocale);
            this.colorEditor.addColorChangedCallback(new ColorEditorCB(), this);
            this.colorEditor.addWindowListener(new ListenColorEditorVisibility());
        }
        this.colorEditor.setVisible(true);
        this.ignoreCallback = true;
        switch ((int)this.activeColor) {
            case 0: {
                break;
            }
            case 1: {
                this.colorEditor.setColor(new SbColor(this.sliders[0].getBaseColor()));
                if (!bl) break;
                this.colorEditor.setTitle(this.resources.getString("M_AMBIENT_TITLE"));
                break;
            }
            case 2: {
                this.colorEditor.setColor(new SbColor(this.sliders[1].getBaseColor()));
                if (!bl) break;
                this.colorEditor.setTitle(this.resources.getString("M_DIFFUSE_TITLE"));
                break;
            }
            case 4: {
                this.colorEditor.setColor(new SbColor(this.sliders[2].getBaseColor()));
                if (!bl) break;
                this.colorEditor.setTitle(this.resources.getString("M_SPECULAR_TITLE"));
                break;
            }
            case 8: {
                this.colorEditor.setColor(new SbColor(this.sliders[3].getBaseColor()));
                if (!bl) break;
                this.colorEditor.setTitle(this.resources.getString("M_EMISSIVE_TITLE"));
                break;
            }
            default: {
                if (!bl) break;
                StringBuffer stringBuffer = new StringBuffer(512);
                stringBuffer.append(this.resources.getString("M_MATERIAL"));
                if ((this.activeColor & 1L) != 0L) {
                    stringBuffer.append(this.resources.getString("M_AMB"));
                }
                if ((this.activeColor & 2L) != 0L) {
                    stringBuffer.append(this.resources.getString("M_DIFF"));
                }
                if ((this.activeColor & 4L) != 0L) {
                    stringBuffer.append(this.resources.getString("M_SPEC"));
                }
                if ((this.activeColor & 8L) != 0L) {
                    stringBuffer.append(this.resources.getString("M_EMIS"));
                }
                stringBuffer.append(' ');
                stringBuffer.append(this.resources.getString("M_COLOR"));
                this.colorEditor.setTitle(stringBuffer.toString());
            }
        }
        this.ignoreCallback = false;
    }

    private void updateColorSlider(SwColorSlider swColorSlider, float[] fArray) {
        float f;
        float[] fArray2 = new float[3];
        float f2 = fArray[0] > fArray[1] ? (fArray[0] > fArray[2] ? fArray[0] : fArray[2]) : (f = fArray[1] > fArray[2] ? fArray[1] : fArray[2]);
        if (f == 0.0f) {
            fArray2[2] = 1.0f;
            fArray2[1] = 1.0f;
            fArray2[0] = 1.0f;
        } else {
            float f3 = 1.0f / f;
            fArray2[0] = fArray[0] * f3;
            fArray2[1] = fArray[1] * f3;
            fArray2[2] = fArray[2] * f3;
        }
        this.ignoreCallback = true;
        swColorSlider.setBaseColor(fArray2);
        swColorSlider.setValue(f);
        this.ignoreCallback = false;
    }

    private void updateMaterialColor(SoMFColor soMFColor, SoMFColor soMFColor2, float[] fArray, float f) {
        SbColor sbColor = new SbColor(fArray);
        sbColor.multiply(f);
        if (soMFColor != null && this.updateFreq == 0) {
            this.sensor.detach();
            soMFColor.set1Value(this.index, sbColor);
            if (soMFColor.isIgnored()) {
                soMFColor.setIgnored(false);
            }
            this.sensor.attach(this.material);
        }
        soMFColor2.setValue(sbColor);
        if (this.updateFreq == 0) {
            this.callbackList.invokeCallbacks(this.localMaterial);
        }
    }

    private void updateMaterialColor(SoSFColor soSFColor, SoMFColor soMFColor, float[] fArray, float f) {
        SbColor sbColor = new SbColor(fArray);
        sbColor.multiply(f);
        if (soSFColor != null && this.updateFreq == 0) {
            this.sensor.detach();
            soSFColor.setValue(sbColor);
            if (soSFColor.isIgnored()) {
                soSFColor.setIgnored(false);
            }
            this.sensor.attach(this.material);
        }
        soMFColor.setValue(sbColor);
        if (this.updateFreq == 0) {
            this.callbackList.invokeCallbacks(this.localMaterial);
        }
    }

    private void copyMaterial(SoNode soNode, int n, SoNode soNode2, int n2) {
        if (soNode instanceof SoMaterial) {
            if (soNode2 instanceof SoMaterial) {
                SoMaterial soMaterial = (SoMaterial)soNode;
                SoMaterial soMaterial2 = (SoMaterial)soNode2;
                soMaterial.ambientColor.set1Value(n, soMaterial2.ambientColor.getValueAt(n2));
                soMaterial.diffuseColor.set1Value(n, soMaterial2.diffuseColor.getValueAt(n2));
                soMaterial.specularColor.set1Value(n, soMaterial2.specularColor.getValueAt(n2));
                soMaterial.emissiveColor.set1Value(n, soMaterial2.emissiveColor.getValueAt(n2));
                soMaterial.shininess.set1Value(n, soMaterial2.shininess.getValueAt(n2));
                soMaterial.transparency.set1Value(n, soMaterial2.transparency.getValueAt(n2));
            } else {
                SoMaterial soMaterial = (SoMaterial)soNode;
                SoVRMLMaterial soVRMLMaterial = (SoVRMLMaterial)soNode2;
                SbColor sbColor = new SbColor(soVRMLMaterial.diffuseColor.getValue());
                sbColor.multiply(soVRMLMaterial.ambientIntensity.getValue());
                soMaterial.ambientColor.setValue(sbColor);
                soMaterial.diffuseColor.setValue(soVRMLMaterial.diffuseColor.getValue());
                soMaterial.specularColor.setValue(soVRMLMaterial.specularColor.getValue());
                soMaterial.shininess.setValue(soVRMLMaterial.shininess.getValue());
                soMaterial.transparency.setValue(soVRMLMaterial.transparency.getValue());
            }
        } else if (soNode2 instanceof SoMaterial) {
            SoVRMLMaterial soVRMLMaterial = (SoVRMLMaterial)soNode;
            SoMaterial soMaterial = (SoMaterial)soNode2;
            float[] fArray = soMaterial.ambientColor.getValueAt(n2).getValue();
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            fArray = soMaterial.diffuseColor.getValueAt(n2).getValue();
            float f4 = fArray[0];
            float f5 = fArray[1];
            float f6 = fArray[2];
            float f7 = 0.0f;
            if (f > 0.0f && f4 > 0.0f) {
                f7 = f / f4;
            } else if (f2 > 0.0f && f5 > 0.0f) {
                f7 = f2 / f5;
            } else if (f3 > 0.0f && f6 > 0.0f) {
                f7 = f3 / f6;
            }
            soVRMLMaterial.ambientIntensity.setValue(f7);
            soVRMLMaterial.diffuseColor.setValue(soMaterial.diffuseColor.getValueAt(n2));
            soVRMLMaterial.specularColor.setValue(soMaterial.specularColor.getValueAt(n2));
            soVRMLMaterial.emissiveColor.setValue(soMaterial.emissiveColor.getValueAt(n2));
            soVRMLMaterial.shininess.setValue(soMaterial.shininess.getValueAt(n2));
            soVRMLMaterial.transparency.setValue(soMaterial.transparency.getValueAt(n2));
        } else {
            SoVRMLMaterial soVRMLMaterial = (SoVRMLMaterial)soNode;
            SoVRMLMaterial soVRMLMaterial2 = (SoVRMLMaterial)soNode2;
            soVRMLMaterial.ambientIntensity.setValue(soVRMLMaterial2.ambientIntensity.getValue());
            soVRMLMaterial.diffuseColor.setValue(soVRMLMaterial2.diffuseColor.getValue());
            soVRMLMaterial.specularColor.setValue(soVRMLMaterial2.specularColor.getValue());
            soVRMLMaterial.emissiveColor.setValue(soVRMLMaterial2.emissiveColor.getValue());
            soVRMLMaterial.shininess.setValue(soVRMLMaterial2.shininess.getValue());
            soVRMLMaterial.transparency.setValue(soVRMLMaterial2.transparency.getValue());
        }
    }

    private void undoIgnoresIfChanged() {
        if (!this.isVRMLMaterial) {
            SoMaterial soMaterial = (SoMaterial)this.material;
            if (this.changedIt[0]) {
                soMaterial.ambientColor.setIgnored(false);
            }
            if (this.changedIt[1]) {
                soMaterial.diffuseColor.setIgnored(false);
            }
            if (this.changedIt[2]) {
                soMaterial.specularColor.setIgnored(false);
            }
            if (this.changedIt[3]) {
                soMaterial.emissiveColor.setIgnored(false);
            }
            if (this.changedIt[4]) {
                soMaterial.shininess.setIgnored(false);
            }
            if (this.changedIt[5]) {
                soMaterial.transparency.setIgnored(false);
            }
        }
    }

    private void activate() {
        if (this.isAttached() && this.sensor.getAttachedNode() == null) {
            this.copyMaterial(this.localMaterial, 0, this.material, this.index);
            this.updateLocalComponents();
            this.sensor.attach(this.material);
        }
    }

    private void deactivate() {
        this.sensor.detach();
    }

    class AcceptButton
    implements ActionListener {
        AcceptButton() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SwMaterialEditor.this.material != null) {
                SwMaterialEditor.this.sensor.detach();
                SwMaterialEditor.this.copyMaterial(SwMaterialEditor.this.material, SwMaterialEditor.this.index, SwMaterialEditor.this.localMaterial, 0);
                SwMaterialEditor.this.undoIgnoresIfChanged();
                SwMaterialEditor.this.sensor.attach(SwMaterialEditor.this.material);
            }
            SwMaterialEditor.this.callbackList.invokeCallbacks(SwMaterialEditor.this.localMaterial);
        }
    }

    class DiamondButtonPick
    implements ItemListener {
        int id;

        public DiamondButtonPick(int n) {
            this.id = n;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (SwMaterialEditor.this.diamondButtons[this.id].getState()) {
                SwMaterialEditor.this.radioButtons[this.id].setState(true);
                for (int i = 0; i < 4; ++i) {
                    SwMaterialEditor.this.radioButtons[i].setState(false);
                }
                switch (this.id) {
                    case 0: {
                        SwMaterialEditor.this.activeColor = 1L;
                        break;
                    }
                    case 1: {
                        SwMaterialEditor.this.activeColor = 2L;
                        break;
                    }
                    case 2: {
                        SwMaterialEditor.this.activeColor = 4L;
                        break;
                    }
                    case 3: {
                        SwMaterialEditor.this.activeColor = 8L;
                    }
                }
            } else {
                SwMaterialEditor.this.radioButtons[this.id].setState(false);
                SwMaterialEditor.this.activeColor = 0L;
            }
            SwMaterialEditor.this.updateColorEditor(true);
        }
    }

    class RadioButtonPick
    implements ItemListener {
        int id;

        public RadioButtonPick(int n) {
            this.id = n;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (SwMaterialEditor.this.radioButtons[this.id].getState()) {
                if (SwMaterialEditor.this.activeColor == 0L) {
                    SwMaterialEditor.this.diamondButtons[this.id].setState(true);
                } else {
                    for (int i = 0; i < 4; ++i) {
                        SwMaterialEditor.this.diamondButtons[i].setState(false);
                    }
                }
                switch (this.id) {
                    case 0: {
                        SwMaterialEditor.this.activeColor = SwMaterialEditor.this.activeColor | 1L;
                        break;
                    }
                    case 1: {
                        SwMaterialEditor.this.activeColor = SwMaterialEditor.this.activeColor | 2L;
                        break;
                    }
                    case 2: {
                        SwMaterialEditor.this.activeColor = SwMaterialEditor.this.activeColor | 4L;
                        break;
                    }
                    case 3: {
                        SwMaterialEditor.this.activeColor = SwMaterialEditor.this.activeColor | 8L;
                    }
                }
            } else {
                SwMaterialEditor.this.diamondButtons[this.id].setState(false);
                switch (this.id) {
                    case 0: {
                        SwMaterialEditor.this.activeColor = SwMaterialEditor.this.activeColor & 0xFFFFFFFFFFFFFFFEL;
                        break;
                    }
                    case 1: {
                        SwMaterialEditor.this.activeColor = SwMaterialEditor.this.activeColor & 0xFFFFFFFFFFFFFFFDL;
                        break;
                    }
                    case 2: {
                        SwMaterialEditor.this.activeColor = SwMaterialEditor.this.activeColor & 0xFFFFFFFFFFFFFFFBL;
                        break;
                    }
                    case 3: {
                        SwMaterialEditor.this.activeColor = SwMaterialEditor.this.activeColor & 0xFFFFFFFFFFFFFFF7L;
                    }
                }
                switch ((int)SwMaterialEditor.this.activeColor) {
                    case 1: {
                        SwMaterialEditor.this.diamondButtons[0].setState(true);
                        break;
                    }
                    case 2: {
                        SwMaterialEditor.this.diamondButtons[1].setState(true);
                        break;
                    }
                    case 4: {
                        SwMaterialEditor.this.diamondButtons[2].setState(true);
                        break;
                    }
                    case 8: {
                        SwMaterialEditor.this.diamondButtons[3].setState(true);
                    }
                }
            }
            SwMaterialEditor.this.updateColorEditor(true);
        }
    }

    class MenuPick
    implements ActionListener,
    ItemListener {
        int id;

        public MenuPick(int n) {
            this.id = n;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            switch (this.id) {
                case 1: {
                    SwMaterialEditor.this.setUpdateFrequency(0);
                    break;
                }
                case 2: {
                    SwMaterialEditor.this.setUpdateFrequency(1);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.id) {
                case 0: {
                    if (SwMaterialEditor.this.materialList == null) {
                        String string;
                        try {
                            String string2 = SoPreferences.getValue("OIV_MATERIALS_PATH");
                            if (string2 == null) {
                                string2 = SoPreferences.getValue("OIVJHOME");
                                if (string2 == null) {
                                    string = mtlDir;
                                } else {
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append(string2);
                                    stringBuffer.append(fileSep);
                                    stringBuffer.append("data");
                                    stringBuffer.append(fileSep);
                                    stringBuffer.append("materials");
                                    string = stringBuffer.toString();
                                }
                            } else {
                                string = string2;
                            }
                        }
                        catch (SecurityException securityException) {
                            string = mtlDir;
                        }
                        SwMaterialEditor.this.materialList = new SwMaterialList(string);
                        SwMaterialEditor.this.materialList.addCallback(new MaterialListCB(), this);
                        SwMaterialEditor.this.materialList.addWindowListener(new ListenMaterialListVisibility());
                        SwMaterialEditor.this.materialList.setResources(SwMaterialEditor.this.defaultLocale);
                    }
                    SwMaterialEditor.this.materialList.setVisible(true);
                    SwMaterialEditor.this.openMaterialList = true;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    SwMaterialEditor.this.setVisible(false);
                    break;
                }
            }
        }
    }

    class MenuDisplay
    implements ActionListener {
        MenuDisplay() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = SwMaterialEditor.this.updateFreq == 0;
            SwMaterialEditor.this.menuCheckCont.setState(bl);
            SwMaterialEditor.this.menuCheckMan.setState(bl);
        }
    }

    class ListenVisibility
    extends ComponentAdapter {
        ListenVisibility() {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            SwMaterialEditor.this.activate();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            SwMaterialEditor.this.deactivate();
        }
    }

    class SensorTask
    implements Runnable {
        SensorTask() {
        }

        @Override
        public void run() {
            if (SwMaterialEditor.this.isVisible()) {
                return;
            }
            SwMaterialEditor.this.copyMaterial(SwMaterialEditor.this.localMaterial, 0, SwMaterialEditor.this.material, SwMaterialEditor.this.index);
            SwMaterialEditor.this.updateLocalComponents();
        }
    }

    class ColorEditorCB
    extends SoCallbackListCB {
        ColorEditorCB() {
        }

        @Override
        public void invoke(Object object) {
            boolean bl;
            SbColor sbColor = (SbColor)object;
            SbColor sbColor2 = new SbColor();
            boolean bl2 = bl = SwMaterialEditor.this.material != null && SwMaterialEditor.this.updateFreq == 0;
            if (SwMaterialEditor.this.ignoreCallback) {
                return;
            }
            if (bl) {
                SwMaterialEditor.this.sensor.detach();
            }
            SwMaterialEditor.this.ignoreCallback = true;
            if ((SwMaterialEditor.this.activeColor & 1L) != 0L) {
                SwMaterialEditor.this.sliders[0].setBaseColor(sbColor.getValue());
                sbColor2.setValue(new SbVec3f(sbColor.getValue()));
                sbColor2.multiply(SwMaterialEditor.this.sliders[0].getValue());
                ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.ambientColor.setValue(sbColor2);
                ((SwMaterialEditor)SwMaterialEditor.this).changedIt[0] = true;
                if (bl && SwMaterialEditor.this.isVRMLMaterial) {
                    ((SwMaterialEditor)SwMaterialEditor.this).imat.ambientColor.set1Value(SwMaterialEditor.this.index, sbColor2);
                    if (((SwMaterialEditor)SwMaterialEditor.this).imat.ambientColor.isIgnored()) {
                        ((SwMaterialEditor)SwMaterialEditor.this).imat.ambientColor.setIgnored(false);
                    }
                }
            }
            if ((SwMaterialEditor.this.activeColor & 2L) != 0L) {
                SwMaterialEditor.this.sliders[1].setBaseColor(sbColor.getValue());
                if (SwMaterialEditor.this.isVRMLMaterial) {
                    SwMaterialEditor.this.sliders[0].setBaseColor(sbColor.getValue());
                }
                sbColor2.setValue(new SbVec3f(sbColor.getValue()));
                sbColor2.multiply(SwMaterialEditor.this.sliders[1].getValue());
                ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.diffuseColor.setValue(sbColor2);
                ((SwMaterialEditor)SwMaterialEditor.this).changedIt[1] = true;
                if (bl) {
                    if (SwMaterialEditor.this.isVRMLMaterial) {
                        ((SwMaterialEditor)SwMaterialEditor.this).vmat.diffuseColor.setValue(sbColor2);
                    } else {
                        ((SwMaterialEditor)SwMaterialEditor.this).imat.diffuseColor.set1Value(SwMaterialEditor.this.index, sbColor2);
                        if (((SwMaterialEditor)SwMaterialEditor.this).imat.diffuseColor.isIgnored()) {
                            ((SwMaterialEditor)SwMaterialEditor.this).imat.diffuseColor.setIgnored(false);
                        }
                    }
                }
            }
            if ((SwMaterialEditor.this.activeColor & 4L) != 0L) {
                SwMaterialEditor.this.sliders[2].setBaseColor(sbColor.getValue());
                sbColor2.setValue(new SbVec3f(sbColor.getValue()));
                sbColor2.multiply(SwMaterialEditor.this.sliders[2].getValue());
                ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.specularColor.setValue(sbColor2);
                ((SwMaterialEditor)SwMaterialEditor.this).changedIt[2] = true;
                if (bl) {
                    if (SwMaterialEditor.this.isVRMLMaterial) {
                        ((SwMaterialEditor)SwMaterialEditor.this).vmat.specularColor.setValue(sbColor2);
                    } else {
                        ((SwMaterialEditor)SwMaterialEditor.this).imat.specularColor.set1Value(SwMaterialEditor.this.index, sbColor2);
                        if (((SwMaterialEditor)SwMaterialEditor.this).imat.specularColor.isIgnored()) {
                            ((SwMaterialEditor)SwMaterialEditor.this).imat.specularColor.setIgnored(false);
                        }
                    }
                }
            }
            if ((SwMaterialEditor.this.activeColor & 8L) != 0L) {
                SwMaterialEditor.this.sliders[3].setBaseColor(sbColor.getValue());
                sbColor2.setValue(new SbVec3f(sbColor.getValue()));
                sbColor2.multiply(SwMaterialEditor.this.sliders[3].getValue());
                ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.emissiveColor.setValue(sbColor2);
                ((SwMaterialEditor)SwMaterialEditor.this).changedIt[3] = true;
                if (bl) {
                    if (SwMaterialEditor.this.isVRMLMaterial) {
                        ((SwMaterialEditor)SwMaterialEditor.this).vmat.emissiveColor.setValue(sbColor2);
                    } else {
                        ((SwMaterialEditor)SwMaterialEditor.this).imat.emissiveColor.set1Value(SwMaterialEditor.this.index, sbColor2);
                        if (((SwMaterialEditor)SwMaterialEditor.this).imat.emissiveColor.isIgnored()) {
                            ((SwMaterialEditor)SwMaterialEditor.this).imat.emissiveColor.setIgnored(false);
                        }
                    }
                }
            }
            if (SwMaterialEditor.this.updateFreq == 0) {
                SwMaterialEditor.this.callbackList.invokeCallbacks(SwMaterialEditor.this.localMaterial);
            }
            if (bl) {
                SwMaterialEditor.this.sensor.attach(SwMaterialEditor.this.material);
            }
            SwMaterialEditor.this.ignoreCallback = false;
        }
    }

    class ListenMaterialListVisibility
    extends WindowAdapter {
        ListenMaterialListVisibility() {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            SwMaterialEditor.this.setVisible(false);
            SwMaterialEditor.this.openMaterialList = false;
        }
    }

    class ListenColorEditorVisibility
    extends WindowAdapter {
        ListenColorEditorVisibility() {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            for (int i = 0; i < 4; ++i) {
                SwMaterialEditor.this.diamondButtons[i].setState(false);
                SwMaterialEditor.this.radioButtons[i].setState(false);
            }
            SwMaterialEditor.this.setVisible(false);
            SwMaterialEditor.this.activeColor = 0L;
        }
    }

    class EmissiveSlider
    extends SliderAdapter {
        EmissiveSlider() {
        }

        @Override
        public void adjustmentValueChanged(SliderEvent sliderEvent) {
            float f = sliderEvent.getSliderValue();
            if (SwMaterialEditor.this.ignoreCallback) {
                return;
            }
            if (SwMaterialEditor.this.isVRMLMaterial) {
                SwMaterialEditor.this.updateMaterialColor(SwMaterialEditor.this.material != null ? ((SwMaterialEditor)SwMaterialEditor.this).vmat.emissiveColor : null, ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.emissiveColor, SwMaterialEditor.this.sliders[3].getBaseColor(), f);
            } else {
                SwMaterialEditor.this.updateMaterialColor(SwMaterialEditor.this.material != null ? ((SwMaterialEditor)SwMaterialEditor.this).imat.emissiveColor : null, ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.emissiveColor, SwMaterialEditor.this.sliders[3].getBaseColor(), f);
            }
            ((SwMaterialEditor)SwMaterialEditor.this).changedIt[3] = true;
        }
    }

    class SpecularSlider
    extends SliderAdapter {
        SpecularSlider() {
        }

        @Override
        public void adjustmentValueChanged(SliderEvent sliderEvent) {
            float f = sliderEvent.getSliderValue();
            if (SwMaterialEditor.this.ignoreCallback) {
                return;
            }
            if (SwMaterialEditor.this.isVRMLMaterial) {
                SwMaterialEditor.this.updateMaterialColor(SwMaterialEditor.this.material != null ? ((SwMaterialEditor)SwMaterialEditor.this).vmat.specularColor : null, ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.specularColor, SwMaterialEditor.this.sliders[2].getBaseColor(), f);
            } else {
                SwMaterialEditor.this.updateMaterialColor(SwMaterialEditor.this.material != null ? ((SwMaterialEditor)SwMaterialEditor.this).imat.specularColor : null, ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.specularColor, SwMaterialEditor.this.sliders[2].getBaseColor(), f);
            }
            ((SwMaterialEditor)SwMaterialEditor.this).changedIt[2] = true;
        }
    }

    class DiffuseSlider
    extends SliderAdapter {
        DiffuseSlider() {
        }

        @Override
        public void adjustmentValueChanged(SliderEvent sliderEvent) {
            float f = sliderEvent.getSliderValue();
            if (SwMaterialEditor.this.ignoreCallback) {
                return;
            }
            if (SwMaterialEditor.this.isVRMLMaterial) {
                SwMaterialEditor.this.updateMaterialColor(SwMaterialEditor.this.material != null ? ((SwMaterialEditor)SwMaterialEditor.this).vmat.diffuseColor : null, ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.diffuseColor, SwMaterialEditor.this.sliders[1].getBaseColor(), f);
            } else {
                SwMaterialEditor.this.updateMaterialColor(SwMaterialEditor.this.material != null ? ((SwMaterialEditor)SwMaterialEditor.this).imat.diffuseColor : null, ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.diffuseColor, SwMaterialEditor.this.sliders[1].getBaseColor(), f);
            }
            ((SwMaterialEditor)SwMaterialEditor.this).changedIt[1] = true;
        }
    }

    class AmbientSlider
    extends SliderAdapter {
        AmbientSlider() {
        }

        @Override
        public void adjustmentValueChanged(SliderEvent sliderEvent) {
            float f = sliderEvent.getSliderValue();
            if (SwMaterialEditor.this.ignoreCallback) {
                return;
            }
            if (SwMaterialEditor.this.isVRMLMaterial) {
                if (SwMaterialEditor.this.vmat != null && SwMaterialEditor.this.updateFreq == 0) {
                    SwMaterialEditor.this.sensor.detach();
                    ((SwMaterialEditor)SwMaterialEditor.this).vmat.ambientIntensity.setValue(f);
                    SwMaterialEditor.this.sensor.attach(SwMaterialEditor.this.material);
                }
                SbColor sbColor = new SbColor();
                sbColor.setValue(((SwMaterialEditor)SwMaterialEditor.this).localMaterial.diffuseColor.getValueAt(0));
                sbColor.multiply(f);
                ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.ambientColor.setValue(sbColor);
                if (SwMaterialEditor.this.updateFreq == 0) {
                    SwMaterialEditor.this.callbackList.invokeCallbacks(SwMaterialEditor.this.localMaterial);
                }
            } else {
                SwMaterialEditor.this.updateMaterialColor(SwMaterialEditor.this.imat != null ? ((SwMaterialEditor)SwMaterialEditor.this).imat.ambientColor : null, ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.ambientColor, SwMaterialEditor.this.sliders[0].getBaseColor(), f);
            }
            ((SwMaterialEditor)SwMaterialEditor.this).changedIt[0] = true;
        }
    }

    class TransparencySlider
    extends SliderAdapter {
        TransparencySlider() {
        }

        @Override
        public void adjustmentValueChanged(SliderEvent sliderEvent) {
            float f = sliderEvent.getSliderValue();
            if (SwMaterialEditor.this.ignoreCallback) {
                return;
            }
            if (SwMaterialEditor.this.material != null && SwMaterialEditor.this.updateFreq == 0) {
                SwMaterialEditor.this.sensor.detach();
                if (SwMaterialEditor.this.isVRMLMaterial) {
                    ((SwMaterialEditor)SwMaterialEditor.this).vmat.transparency.setValue(f);
                } else {
                    ((SwMaterialEditor)SwMaterialEditor.this).imat.transparency.set1Value(SwMaterialEditor.this.index, f);
                    if (((SwMaterialEditor)SwMaterialEditor.this).imat.transparency.isIgnored()) {
                        ((SwMaterialEditor)SwMaterialEditor.this).imat.transparency.setIgnored(false);
                    }
                }
                SwMaterialEditor.this.sensor.attach(SwMaterialEditor.this.material);
            }
            ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.transparency.setValue(f);
            ((SwMaterialEditor)SwMaterialEditor.this).changedIt[5] = true;
            if (SwMaterialEditor.this.updateFreq == 0) {
                SwMaterialEditor.this.callbackList.invokeCallbacks(SwMaterialEditor.this.localMaterial);
            }
        }
    }

    class ShininessSlider
    extends SliderAdapter {
        ShininessSlider() {
        }

        @Override
        public void adjustmentValueChanged(SliderEvent sliderEvent) {
            if (SwMaterialEditor.this.ignoreCallback) {
                return;
            }
            float f = sliderEvent.getSliderValue();
            if (SwMaterialEditor.this.material != null && SwMaterialEditor.this.updateFreq == 0) {
                SwMaterialEditor.this.sensor.detach();
                if (SwMaterialEditor.this.isVRMLMaterial) {
                    ((SwMaterialEditor)SwMaterialEditor.this).vmat.shininess.setValue(f);
                } else {
                    ((SwMaterialEditor)SwMaterialEditor.this).imat.shininess.set1Value(SwMaterialEditor.this.index, f);
                    if (((SwMaterialEditor)SwMaterialEditor.this).imat.shininess.isIgnored()) {
                        ((SwMaterialEditor)SwMaterialEditor.this).imat.shininess.setIgnored(false);
                    }
                }
                SwMaterialEditor.this.sensor.attach(SwMaterialEditor.this.material);
            }
            ((SwMaterialEditor)SwMaterialEditor.this).localMaterial.shininess.setValue(f);
            ((SwMaterialEditor)SwMaterialEditor.this).changedIt[4] = true;
            if (SwMaterialEditor.this.updateFreq == 0) {
                SwMaterialEditor.this.callbackList.invokeCallbacks(SwMaterialEditor.this.localMaterial);
            }
        }
    }

    class MaterialListCB
    extends SoCallbackListCB {
        MaterialListCB() {
        }

        @Override
        public void invoke(Object object) {
            SwMaterialEditor.this.setMaterial((SoMaterial)object);
        }
    }
}

