/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.awt.CheckboxMenuGroup;
import com.openinventor.awt.GroupedCheckboxMenuItem;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.actions.SoSearchAction;
import com.openinventor.inventor.awt.SwMaterialEditor;
import com.openinventor.inventor.awt.SwPanel;
import com.openinventor.inventor.awt.SwResources;
import com.openinventor.inventor.misc.SoCallbackList;
import com.openinventor.inventor.misc.callbacks.SoCallbackListCB;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoNode;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

@Deprecated
public class SwMaterialList
extends Frame {
    private String materialDir;
    private SoCallbackList callbackList;
    private Vector menuItems;
    private Vector mtlPalettes;
    private Vector palette;
    private int curPalette;
    private MenuBar menuBar;
    private Menu menuPalette;
    private List paletteList;
    private CheckboxMenuGroup cbmGroupPalette;
    private SwResources resources = (SwResources)ResourceBundle.getBundle("com.openinventor.inventor.awt.SwResources", SwPanel.defaultLocale);
    private static final String fileSep = System.getProperty("file.separator");

    public SwMaterialList() {
        this((String)null);
    }

    public SwMaterialList(String string) {
        super(SwPanel.resources.getString("ML_TITLE"));
        Object object;
        if (string != null) {
            this.materialDir = string;
        } else {
            this.materialDir = SoPreferences.getValue("OIV_MATERIALS_PATH");
            if (this.materialDir == null) {
                object = SoPreferences.getValue("OIVJHOME");
                if (object == null) {
                    this.materialDir = SwMaterialEditor.mtlDir;
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append((String)object);
                    stringBuffer.append(fileSep);
                    stringBuffer.append("data");
                    stringBuffer.append(fileSep);
                    stringBuffer.append("materials");
                    this.materialDir = stringBuffer.toString();
                }
            }
        }
        this.callbackList = new SoCallbackList();
        this.curPalette = -1;
        this.menuItems = new Vector();
        this.mtlPalettes = new Vector();
        this.palette = new Vector();
        this.buildGUI();
        object = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SwMaterialList.this.setVisible(false);
            }
        };
        this.addWindowListener((WindowListener)object);
    }

    public void addCallback(SoCallbackListCB soCallbackListCB, Object object) {
        this.callbackList.addCallback(soCallbackListCB, object);
    }

    public void removeCallback(SoCallbackListCB soCallbackListCB, Object object) {
        this.callbackList.removeCallback(soCallbackListCB, object);
    }

    public void setResources(Locale locale) {
        String string = this.resources.getString("ML_NONE");
        this.resources = locale != null ? (SwResources)ResourceBundle.getBundle("com.openinventor.inventor.awt.SwResources", locale) : (SwResources)ResourceBundle.getBundle("com.openinventor.inventor.awt.SwResources");
        this.setTitle(this.resources.getString("ML_TITLE"));
        this.menuPalette.setLabel(this.resources.getString("ML_MENU_PALETTE"));
        String string2 = this.paletteList.getItem(0);
        if (string2.equals(string)) {
            this.paletteList.replaceItem(this.resources.getString("ML_NONE"), 0);
        }
    }

    private void buildGUI() {
        if (!this.setupPalettes()) {
            return;
        }
        this.menuBar = this.buildMenu();
        if (this.curPalette == -1) {
            return;
        }
        this.setLayout(new BorderLayout());
        this.setMenuBar(this.menuBar);
        String[] stringArray = SwMaterialList.createStringTable(new File(this.materialDir, (String)this.mtlPalettes.elementAt(this.curPalette)));
        this.paletteList = new List(8, false);
        for (int i = 0; i < stringArray.length; ++i) {
            this.paletteList.add(stringArray[i]);
        }
        this.paletteList.addItemListener(new ListPick());
        this.add("Center", this.paletteList);
        this.pack();
    }

    private MenuBar buildMenu() {
        MenuBar menuBar = new MenuBar();
        this.menuPalette = new Menu(this.resources.getString("ML_MENU_PALETTE"));
        this.menuItems.removeAllElements();
        this.cbmGroupPalette = new CheckboxMenuGroup();
        for (int i = 0; i < this.mtlPalettes.size(); ++i) {
            GroupedCheckboxMenuItem groupedCheckboxMenuItem = new GroupedCheckboxMenuItem((String)this.mtlPalettes.elementAt(i), this.cbmGroupPalette);
            groupedCheckboxMenuItem.addItemListener(new MenuPick(i));
            this.menuItems.addElement(groupedCheckboxMenuItem);
            this.menuPalette.add(groupedCheckboxMenuItem);
        }
        if (this.menuItems.size() == 0) {
            this.curPalette = -1;
        }
        menuBar.add(this.menuPalette);
        if (this.curPalette != -1) {
            this.cbmGroupPalette.setSelectedCheckbox((GroupedCheckboxMenuItem)this.menuItems.elementAt(this.curPalette));
        }
        return menuBar;
    }

    private void fillInMaterialList() {
        if (this.curPalette == -1) {
            return;
        }
        String[] stringArray = SwMaterialList.createStringTable(new File(this.materialDir, (String)this.mtlPalettes.elementAt(this.curPalette)));
        this.paletteList.removeAll();
        for (int i = 0; i < stringArray.length; ++i) {
            this.paletteList.add(stringArray[i]);
        }
    }

    private boolean setupPalettes() {
        String string = SoPreferences.getValue("SO_MATERIAL_DIR");
        if (string != null) {
            if (string.equals(this.materialDir) && this.curPalette != -1) {
                return true;
            }
            this.materialDir = string;
        } else if (this.curPalette != -1) {
            return true;
        }
        this.curPalette = 0;
        try {
            File file = new File(this.materialDir);
            String[] stringArray = file.list();
            if (stringArray == null) {
                this.curPalette = -1;
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    File file2 = new File(file.getPath(), stringArray[i]);
                    if (!file2.isDirectory()) continue;
                    this.mtlPalettes.addElement(stringArray[i]);
                }
            }
        }
        catch (SecurityException securityException) {
            this.curPalette = -1;
        }
        return this.curPalette != -1;
    }

    private static boolean isMtlFile(File file) {
        SoNode soNode;
        if (file.isDirectory()) {
            return false;
        }
        String string = file.getPath() + fileSep + file.getName();
        boolean bl = false;
        SoInput soInput = new SoInput();
        if (soInput.openFile(string) && (soNode = SoDB.readNode(soInput)) != null) {
            SoSearchAction soSearchAction = new SoSearchAction();
            soSearchAction.setNodeClass(SoMaterial.class, true);
            soSearchAction.apply(soNode);
            bl = soSearchAction.getPath() != null;
        }
        return bl;
    }

    private static String[] createStringTable(File file) {
        try {
            if (!file.isDirectory()) {
                return null;
            }
            return file.list();
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    class ListPick
    implements ItemListener {
        ListPick() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            SoNode soNode;
            String string = SwMaterialList.this.paletteList.getSelectedItem();
            if (string.equals(SwMaterialList.this.resources.getString("ML_NONE"))) {
                return;
            }
            SoInput soInput = new SoInput();
            String string2 = SwMaterialList.this.materialDir + fileSep + (String)SwMaterialList.this.mtlPalettes.elementAt(SwMaterialList.this.curPalette) + fileSep + string;
            if (soInput.openFile(string2) && (soNode = SoDB.readNode(soInput)) != null) {
                SoSearchAction soSearchAction = new SoSearchAction();
                soSearchAction.setNodeClass(SoMaterial.class, true);
                soSearchAction.apply(soNode);
                SoPath soPath = soSearchAction.getPath();
                if (soPath != null) {
                    SoMaterial soMaterial = (SoMaterial)soPath.getTail();
                    SwMaterialList.this.callbackList.invokeCallbacks(soMaterial);
                }
            }
        }
    }

    class MenuPick
    implements ItemListener {
        int id;

        public MenuPick(int n) {
            this.id = n;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.id != SwMaterialList.this.curPalette) {
                SwMaterialList.this.curPalette = this.id;
                SwMaterialList.this.fillInMaterialList();
            }
            SwMaterialList.this.cbmGroupPalette.setSelectedCheckbox((GroupedCheckboxMenuItem)SwMaterialList.this.menuItems.elementAt(SwMaterialList.this.curPalette));
        }
    }
}

