/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.inventor.SbLine;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbPlane;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewVolume;
import com.openinventor.inventor.awt.SwActiveArea;
import com.openinventor.inventor.awt.SwCursor;
import com.openinventor.inventor.awt.event.SwActiveAreaKeyboard;
import com.openinventor.inventor.awt.event.SwActiveAreaMouse;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.fields.SoSFTime;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import com.openinventor.util.Scene;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

@Deprecated
public class SwPlaneArea
extends SwActiveArea {
    protected static String[] mouseHelp = new String[]{"HELP_MOUSE_PLANE_DOLLY", "HELP_MOUSE_PLANE_PAN", "HELP_MOUSE_PLANE_ROLL", "HELP_MOUSE_PLANE_MENU"};
    float transXspeed;
    float transYspeed;
    private Scene.ViewingModes mode;
    private boolean isButton1Down = false;
    private boolean isButton2Down = false;

    public SwPlaneArea() {
        this(0);
    }

    public SwPlaneArea(int n) {
        super(true, true, n);
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwPlaneArea.SwPlaneArea");
        }
        this.addMouseDevice(new SwPlaneAreaMouse());
        this.addKeyboardDevice(new SwPlaneAreaKeyboard());
        this.mode = this.isViewing() ? Scene.ViewingModes.VIEW_MODE : Scene.ViewingModes.PICK_MODE;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Scene.ViewingModes getMode() {
        return this.mode;
    }

    @Override
    public void setMode(Scene.ViewingModes viewingModes, AWTEvent aWTEvent) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwPlaneArea.setMode");
        }
        if (this.mode == viewingModes) {
            return;
        }
        Dimension dimension = this.getSize();
        boolean bl = false;
        Scene.ViewingModes viewingModes2 = this.mode;
        this.mode = viewingModes;
        this.updateCursor();
        if (viewingModes2 == Scene.ViewingModes.ROLL_MODE_ACTIVE) {
            bl = true;
        }
        switch (viewingModes) {
            case PICK_MODE: {
                if (DEBUG) {
                    System.out.println("PICK MODE");
                }
                if (aWTEvent == null || !(aWTEvent instanceof InputEvent)) break;
                long l = ((InputEvent)aWTEvent).getModifiers();
                if ((l & 0x10L) != 0L && viewingModes2 != Scene.ViewingModes.SEEK_MODE) {
                    this.interactiveCountDec();
                }
                if ((l & 8L) == 0L || viewingModes2 == Scene.ViewingModes.SEEK_MODE) break;
                this.interactiveCountDec();
                break;
            }
            case PAN_MODE_ACTIVE: {
                if (DEBUG) {
                    System.out.println("PAN MODE");
                }
                SbMatrix sbMatrix = new SbMatrix();
                sbMatrix.setRotate(this.camera.orientation.getValue());
                float[] fArray = sbMatrix.getColumn(2);
                SbVec3f sbVec3f = new SbVec3f(-fArray[0], -fArray[1], -fArray[2]);
                SbVec3f sbVec3f2 = sbVec3f.times(this.camera.focalDistance.getValue());
                SbVec3f sbVec3f3 = this.camera.position.getValue().plus(sbVec3f2);
                this.focalPlane.setValue(new SbPlane(sbVec3f, sbVec3f3));
                SbViewVolume sbViewVolume = new SbViewVolume();
                sbViewVolume.setValue(this.camera.getViewVolume((float)dimension.width / (float)dimension.height));
                SbLine sbLine = sbViewVolume.projectPointToLine(new SbVec2f((float)this.locator.getX() / (float)dimension.width, (float)this.locator.getY() / (float)dimension.height));
                this.locator3D = this.focalPlane.intersect(sbLine);
                break;
            }
            case ROLL_MODE_ACTIVE: {
                if (DEBUG) {
                    System.out.println("ROLL MODE");
                }
                bl = true;
                break;
            }
            case DOLLY_MODE_ACTIVE: {
                if (!DEBUG) break;
                System.out.println("DOLLY MODE");
            }
        }
        if (bl) {
            this.scheduleRedraw();
        }
    }

    @Override
    public void updateMode(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent) {
            long l = ((InputEvent)aWTEvent).getModifiers();
            if ((l & 0x10L) != 0L) {
                if (aWTEvent.getID() == 501) {
                    this.isButton1Down = true;
                } else if (aWTEvent.getID() == 502) {
                    this.isButton1Down = false;
                }
            } else if ((l & 8L) != 0L) {
                if (aWTEvent.getID() == 501) {
                    this.isButton2Down = true;
                } else if (aWTEvent.getID() == 502) {
                    this.isButton2Down = false;
                }
            }
        }
        if (this.isButton1Down && this.isButton2Down) {
            this.setMode(Scene.ViewingModes.DOLLY_MODE_ACTIVE, aWTEvent);
        } else if (this.isButton1Down) {
            if (((InputEvent)aWTEvent).isControlDown()) {
                if (((InputEvent)aWTEvent).isShiftDown()) {
                    this.setMode(Scene.ViewingModes.ROLL_MODE_ACTIVE, aWTEvent);
                } else {
                    this.setMode(Scene.ViewingModes.PAN_MODE_ACTIVE, aWTEvent);
                }
            } else if (((InputEvent)aWTEvent).isShiftDown()) {
                this.setMode(Scene.ViewingModes.PAN_MODE_ACTIVE, aWTEvent);
            } else {
                this.setMode(Scene.ViewingModes.DOLLY_MODE_ACTIVE, aWTEvent);
            }
        } else if (this.isButton2Down) {
            this.setMode(Scene.ViewingModes.PAN_MODE_ACTIVE, aWTEvent);
        } else if (((InputEvent)aWTEvent).isControlDown() || ((InputEvent)aWTEvent).isShiftDown()) {
            this.setMode(Scene.ViewingModes.PAN_MODE, aWTEvent);
        } else if (this.isViewing()) {
            this.setMode(Scene.ViewingModes.VIEW_MODE, aWTEvent);
        } else {
            this.setMode(Scene.ViewingModes.PICK_MODE, aWTEvent);
        }
    }

    @Override
    public void setCamera(SoCamera soCamera) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwPlaneArea.setCamera");
        }
        if (this.camera == soCamera) {
            return;
        }
        super.setCamera(soCamera);
        this.notifySceneHandlers();
    }

    @Override
    public void setViewing(boolean bl, AWTEvent aWTEvent) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwPlaneArea.setViewing");
        }
        if (bl == this.viewingFlag) {
            return;
        }
        super.setViewing(bl, aWTEvent);
        this.setMode(this.isViewing() ? Scene.ViewingModes.VIEW_MODE : Scene.ViewingModes.PICK_MODE, aWTEvent);
    }

    @Override
    public void setSeekMode(boolean bl) {
        super.setSeekMode(bl);
        this.setMode(this.isSeekMode() ? Scene.ViewingModes.SEEK_MODE : (this.isViewing() ? Scene.ViewingModes.VIEW_MODE : Scene.ViewingModes.PICK_MODE), null);
    }

    @Override
    public void rollCamera(SbVec2s sbVec2s) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwPlaneArea.rollCamera");
        }
        if (this.camera == null) {
            return;
        }
        SbVec2s sbVec2s2 = new SbVec2s((short)(this.getSize().width / 2), (short)(this.getSize().height / 2));
        SbVec2s sbVec2s3 = new SbVec2s();
        SbVec2s sbVec2s4 = new SbVec2s();
        sbVec2s3 = this.locator.minus(sbVec2s2);
        sbVec2s4 = sbVec2s.minus(sbVec2s2);
        float f = (float)(sbVec2s4.getX() == 0 && sbVec2s4.getY() == 0 ? 0.0 : Math.atan2(sbVec2s4.getY(), sbVec2s4.getX()));
        float f2 = sbVec2s3.getX() == 0 && sbVec2s3.getY() == 0 ? 0.0f : (float)Math.atan2(sbVec2s3.getY(), sbVec2s3.getX());
        SbVec3f sbVec3f = new SbVec3f(0.0f, 0.0f, -1.0f);
        SbRotation sbRotation = new SbRotation(sbVec3f, f -= f2);
        SbRotation sbRotation2 = sbRotation.times(this.camera.orientation.getValue());
        this.camera.orientation.setValue(sbRotation2);
        this.locator.setValue(sbVec2s);
    }

    @Override
    public void xAxisCameraAction(float f) {
        if (this.getCamera() != null) {
            SbMatrix sbMatrix = new SbMatrix();
            sbMatrix.setRotate(this.getCamera().orientation.getValue());
            float[] fArray = sbMatrix.getColumn(1);
            SbVec3f sbVec3f = new SbVec3f(fArray[0], fArray[1], fArray[2]);
            float f2 = this.transYspeed * -f;
            SbVec3f sbVec3f2 = sbVec3f.times(f2);
            sbVec3f2.add(this.getCamera().position.getValue());
            this.getCamera().position.setValue(sbVec3f2);
        }
    }

    @Override
    public void yAxisCameraAction(float f) {
        if (this.getCamera() != null) {
            SbMatrix sbMatrix = new SbMatrix();
            sbMatrix.setRotate(this.getCamera().orientation.getValue());
            float[] fArray = sbMatrix.getColumn(0);
            SbVec3f sbVec3f = new SbVec3f(fArray[0], fArray[1], fArray[2]);
            float f2 = this.transXspeed * f;
            SbVec3f sbVec3f2 = sbVec3f.times(f2);
            sbVec3f2.add(this.getCamera().position.getValue());
            this.getCamera().position.setValue(sbVec3f2);
        }
    }

    @Override
    public void stopAnimating() {
        this.computePanValues();
    }

    protected void computePanValues() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwPlaneArea.computePanValues");
        }
        if (this.camera == null) {
            return;
        }
        float f = 0.0f;
        if (this.camera instanceof SoPerspectiveCamera) {
            float f2 = ((SoPerspectiveCamera)this.camera).heightAngle.getValue();
            f = (float)((double)this.camera.focalDistance.getValue() * Math.tan(f2 / 2.0f));
        } else if (this.camera instanceof SoOrthographicCamera) {
            f = ((SoOrthographicCamera)this.camera).height.getValue() / 2.0f;
        }
        this.transYspeed = f;
        this.transXspeed = this.transYspeed * this.camera.aspectRatio.getValue();
    }

    @Override
    public void setPlane(SbVec3f sbVec3f, SbVec3f sbVec3f2) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwPlaneArea.setPlane");
        }
        if (this.camera == null) {
            return;
        }
        SbRotation sbRotation = this.camera.orientation.getValue();
        float f = this.camera.focalDistance.getValue();
        SbMatrix sbMatrix = new SbMatrix();
        sbMatrix.setRotate(sbRotation);
        float[] fArray = sbMatrix.getColumn(2);
        SbVec3f sbVec3f3 = new SbVec3f(-fArray[0], -fArray[1], -fArray[2]);
        SbVec3f sbVec3f4 = sbVec3f3.times(f);
        SbVec3f sbVec3f5 = this.camera.position.getValue().plus(sbVec3f4);
        sbVec3f4.setValue(sbVec3f3);
        sbVec3f4.negate();
        SbRotation sbRotation2 = new SbRotation(sbVec3f4, sbVec3f);
        sbRotation.multiply(sbRotation2);
        sbMatrix.setRotate(sbRotation);
        fArray = sbMatrix.getColumn(0);
        SbVec3f sbVec3f6 = new SbVec3f(fArray[0], fArray[1], fArray[2]);
        sbRotation2.setValue(sbVec3f6, sbVec3f2);
        sbRotation.multiply(sbRotation2);
        this.camera.orientation.setValue(sbRotation);
        sbMatrix.setRotate(sbRotation);
        fArray = sbMatrix.getColumn(2);
        sbVec3f3.setValue(fArray[0], fArray[1], fArray[2]);
        sbVec3f3.multiply(f);
        sbVec3f3.add(sbVec3f5);
        this.camera.position.setValue(sbVec3f3);
    }

    @Override
    protected void computeSeekFinalOrientation() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwPlaneArea.computeSeekFinalOrientation");
        }
        this.m_seekFinalCameraOrientation.setValue(this.camera.orientation.getValue());
    }

    @Override
    public void updateCursor() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->PlaneArea.updateCursor");
        }
        switch (this.mode) {
            case PICK_MODE: 
            case ROLL_MODE_ACTIVE: {
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case DOLLY_MODE_ACTIVE: 
            case VIEW_MODE: {
                this.setCursor(SwCursor.getPredefinedCursor(103));
                break;
            }
            case PAN_MODE_ACTIVE: 
            case PAN_MODE: {
                this.setCursor(SwCursor.getPredefinedCursor(102));
                break;
            }
            case SEEK_MODE: {
                this.setCursor(SwCursor.getPredefinedCursor(105));
            }
        }
    }

    @Override
    public SoSFTime getRealTime() {
        return areaRealTime;
    }

    @Override
    public void actualRedraw() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->PlaneArea.actualRedraw");
        }
        super.actualRedraw();
        if (this.isViewing() && this.mode == Scene.ViewingModes.ROLL_MODE_ACTIVE) {
            Dimension dimension = this.getSize();
            this.setFeedbackOrthoProjection(dimension);
            SbVec2s sbVec2s = new SbVec2s((short)(dimension.width / 2), (short)(dimension.height / 2));
            this.drawRollFeedback(sbVec2s, this.locator);
            this.restoreGLStateAfterFeedback();
        }
    }

    @Override
    public String[] getMouseResourcesName() {
        return mouseHelp;
    }

    class SwPlaneAreaKeyboard
    extends SwActiveAreaKeyboard {
        boolean pressed = true;

        SwPlaneAreaKeyboard() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            SoKeyboardEvent.Keys keys;
            if (this.pressed) {
                super.keyPressed(keyEvent);
                if (keyEvent.isConsumed()) {
                    return;
                }
            }
            if ((keys = SoKeyboardEvent.getKeySym(keyEvent.getKeyCode())) == SoKeyboardEvent.Keys.LEFT_CONTROL || keys == SoKeyboardEvent.Keys.RIGHT_CONTROL || keys == SoKeyboardEvent.Keys.LEFT_SHIFT || keys == SoKeyboardEvent.Keys.RIGHT_SHIFT) {
                SwPlaneArea.this.updateMode(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            super.keyReleased(keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
            this.pressed = false;
            this.keyPressed(keyEvent);
            this.pressed = true;
        }
    }

    class SwPlaneAreaMouse
    extends SwActiveAreaMouse {
        boolean pressed = true;

        SwPlaneAreaMouse() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (this.pressed) {
                super.mousePressed(mouseEvent);
                if (mouseEvent.isConsumed()) {
                    return;
                }
            }
            if ((n = mouseEvent.getButton()) != 1 && n != 2) {
                return;
            }
            Dimension dimension = SwPlaneArea.this.getSize();
            SwPlaneArea.this.setLocator(mouseEvent.getX(), dimension.height - mouseEvent.getY());
            if (SwPlaneArea.this.mode == Scene.ViewingModes.SEEK_MODE) {
                if (this.pressed) {
                    SwPlaneArea.this.seekToPoint(SwPlaneArea.this.locator);
                }
            } else {
                if (this.pressed) {
                    SwPlaneArea.this.interactiveCountInc();
                } else {
                    SwPlaneArea.this.interactiveCountDec();
                }
                SwPlaneArea.this.updateMode(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.pressed = false;
            this.mousePressed(mouseEvent);
            this.pressed = true;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
            if (mouseEvent.isConsumed()) {
                return;
            }
            Dimension dimension = SwPlaneArea.this.getSize();
            switch (SwPlaneArea.this.mode) {
                case DOLLY_MODE_ACTIVE: {
                    SwPlaneArea.this.dollyCamera(new SbVec2s((short)mouseEvent.getX(), (short)(dimension.height - mouseEvent.getY())));
                    break;
                }
                case PAN_MODE_ACTIVE: {
                    SwPlaneArea.this.panCamera(new SbVec2f((float)mouseEvent.getX() / (float)dimension.width, (float)(dimension.height - mouseEvent.getY()) / (float)dimension.height));
                    break;
                }
                case ROLL_MODE_ACTIVE: {
                    SwPlaneArea.this.rollCamera(new SbVec2s((short)mouseEvent.getX(), (short)(dimension.height - mouseEvent.getY())));
                }
            }
        }
    }
}

