/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.awt.CheckboxMenuGroup;
import com.openinventor.awt.GroupedCheckboxMenuItem;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.awt.SwPanel;
import com.openinventor.inventor.awt.SwPreferences;
import com.openinventor.inventor.awt.SwResources;
import com.openinventor.inventor.awt.SwScene;
import com.openinventor.inventor.awt.SwSceneHandler;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.util.Scene;
import com.openinventor.util.SceneObservable;
import java.awt.AWTEvent;
import java.awt.CheckboxMenuItem;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.Observable;
import java.util.ResourceBundle;

@Deprecated
public class SwPopupMenu
extends PopupMenu
implements SwSceneHandler {
    protected String prefSheetStr;
    protected String popupTitle;
    protected SwScene scene;
    protected SwPanel panel;
    protected static SwResources resources;
    static final boolean DEBUG;
    protected static final int VIEW_ALL = 20;
    protected static final int SET_HOME = 21;
    protected static final int HOME = 22;
    protected static final int HEADLIGHT = 23;
    protected static final int SEEK = 24;
    protected static final int PREF = 25;
    protected static final int VIEWING = 26;
    protected static final int DECORATION = 27;
    protected static final int COPY_VIEW = 28;
    protected static final int PASTE_VIEW = 29;
    protected static final int HELP = 30;
    protected static final int HEADLIGHT_WIDGET = 0;
    protected static final int VIEWING_WIDGET = 1;
    protected static final int DECORATION_WIDGET = 2;
    protected static final int POPUP_TOGGLE_NUM = 3;
    private Menu functionsSubMenu;
    private MenuItem helpMi;
    private MenuItem homeMi;
    private MenuItem setHomeMi;
    private MenuItem viewAllMi;
    private MenuItem seekMi;
    private MenuItem copyMi;
    private MenuItem pasteMi;
    private CheckboxMenuItem viewingCmi;
    private CheckboxMenuItem headlightCmi;
    private CheckboxMenuItem decoCmi;
    private MenuItem prefMi;
    private Menu drawStyleSubMenu;
    private CheckboxMenuGroup drawGroup;
    private GroupedCheckboxMenuItem asisCmi;
    private GroupedCheckboxMenuItem hidlinCmi;
    private GroupedCheckboxMenuItem notextCmi;
    private GroupedCheckboxMenuItem lowresCmi;
    private GroupedCheckboxMenuItem wireCmi;
    private GroupedCheckboxMenuItem pointsCmi;
    private GroupedCheckboxMenuItem nodethCmi;
    private CheckboxMenuGroup drawMoveGroup;
    private GroupedCheckboxMenuItem mvsameasCmi;
    private GroupedCheckboxMenuItem mvnotextCmi;
    private GroupedCheckboxMenuItem mvlowresCmi;
    private GroupedCheckboxMenuItem mvwireCmi;
    private GroupedCheckboxMenuItem mvlowireCmi;
    private GroupedCheckboxMenuItem mvpointCmi;
    private GroupedCheckboxMenuItem mvlopoinCmi;
    private GroupedCheckboxMenuItem mvbboxCmi;
    private CheckboxMenuGroup bufferGroup;
    private GroupedCheckboxMenuItem sbufCmi;
    private GroupedCheckboxMenuItem dbufCmi;
    private GroupedCheckboxMenuItem ibufCmi;
    private Frame preferences;
    SwPreferences preferencesPanel;

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public SwPopupMenu(SwPanel swPanel) {
        this(swPanel, resources.getString("V_POPUP_TITLE"));
    }

    public SwPopupMenu(SwPanel swPanel, String string) {
        super(string);
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwPopupMenu.SwPopupMenu");
        }
        this.panel = swPanel;
        this.buildFunctionsSubMenu();
        this.buildDrawStyleSubMenu();
        this.viewingCmi = new CheckboxMenuItem(resources.getString("VP_VIEWING"), false);
        this.headlightCmi = new CheckboxMenuItem(resources.getString("VP_HEADLIGHT"), false);
        this.add(this.viewingCmi);
        this.add(this.headlightCmi);
        this.viewingCmi.addItemListener(new ListenMainPopup(26, this));
        this.headlightCmi.addItemListener(new ListenMainPopup(23, this));
        this.decoCmi = new CheckboxMenuItem(resources.getString("VP_DECO"), swPanel.isDecoration());
        this.add(this.decoCmi);
        this.decoCmi.addItemListener(new ListenMainPopup(27, this));
        this.prefMi = new MenuItem(resources.getString("VP_PREF"));
        this.prefMi.addActionListener(new ListenMainPopup(25, this));
        this.add(this.prefMi);
        this.setPopupMenuString(resources.getString("V_POPUP_TITLE"));
    }

    public void setResources(Locale locale) {
        resources = locale != null ? (SwResources)ResourceBundle.getBundle("com.openinventor.inventor.awt.SwResources", locale) : (SwResources)ResourceBundle.getBundle("com.openinventor.inventor.awt.SwResources");
        if (this.preferencesPanel != null) {
            this.preferencesPanel.setResources(locale);
            this.preferences.setTitle(resources.getString("PS_TITLE"));
            this.preferences.pack();
        }
        this.setPopupMenuString(resources.getString("V_POPUP_TITLE"));
        this.viewingCmi.setLabel(resources.getString("VP_VIEWING"));
        this.headlightCmi.setLabel(resources.getString("VP_HEADLIGHT"));
        this.decoCmi.setLabel(resources.getString("VP_DECO"));
        this.prefMi.setLabel(resources.getString("VP_PREF"));
        this.functionsSubMenu.setLabel(resources.getString("VP_FUNC1"));
        this.helpMi.setLabel(resources.getString("VP_HELP"));
        this.homeMi.setLabel(resources.getString("VP_HOME"));
        this.setHomeMi.setLabel(resources.getString("VP_SET_HOME"));
        this.viewAllMi.setLabel(resources.getString("VP_VIEW_ALL"));
        this.seekMi.setLabel(resources.getString("VP_SEEK"));
        this.copyMi.setLabel(resources.getString("VP_COPY"));
        this.pasteMi.setLabel(resources.getString("VP_PAST"));
        this.drawStyleSubMenu.setLabel(resources.getString("VP_DRAW_STYLE1"));
        this.asisCmi.setLabel(resources.getString("VP_AS_IS"));
        this.hidlinCmi.setLabel(resources.getString("VP_HIDDEN_LINE"));
        this.notextCmi.setLabel(resources.getString("VP_NO_TEXTURE"));
        this.lowresCmi.setLabel(resources.getString("VP_LOW_RES"));
        this.wireCmi.setLabel(resources.getString("VP_WIRE"));
        this.pointsCmi.setLabel(resources.getString("VP_POINTS"));
        this.nodethCmi.setLabel(resources.getString("VP_BB_NO_DEPTH"));
        this.mvsameasCmi.setLabel(resources.getString("VP_MOVE_SAME_AS"));
        this.mvnotextCmi.setLabel(resources.getString("VP_MOVE_NO_TXT"));
        this.mvlowresCmi.setLabel(resources.getString("VP_MOVE_LOW_RES"));
        this.mvwireCmi.setLabel(resources.getString("VP_MOVE_LINE"));
        this.mvlowireCmi.setLabel(resources.getString("VP_MOVE_LOW_LINE"));
        this.mvpointCmi.setLabel(resources.getString("VP_MOVE_POINT"));
        this.mvlopoinCmi.setLabel(resources.getString("VP_MOVE_LOW_POINT"));
        this.mvbboxCmi.setLabel(resources.getString("VP_MOVE_BBOX"));
        this.sbufCmi.setLabel(resources.getString("VP_SBUFFER"));
        this.dbufCmi.setLabel(resources.getString("VP_DBUFFER"));
        this.ibufCmi.setLabel(resources.getString("VP_IBUFFER"));
    }

    protected void buildFunctionsSubMenu() {
        this.functionsSubMenu = new Menu(resources.getString("VP_FUNC1"));
        this.add(this.functionsSubMenu);
        this.helpMi = new MenuItem(resources.getString("VP_HELP"));
        this.homeMi = new MenuItem(resources.getString("VP_HOME"));
        this.setHomeMi = new MenuItem(resources.getString("VP_SET_HOME"));
        this.viewAllMi = new MenuItem(resources.getString("VP_VIEW_ALL"));
        this.seekMi = new MenuItem(resources.getString("VP_SEEK"));
        this.functionsSubMenu.add(this.helpMi);
        this.functionsSubMenu.add(this.homeMi);
        this.functionsSubMenu.add(this.setHomeMi);
        this.functionsSubMenu.add(this.viewAllMi);
        this.functionsSubMenu.add(this.seekMi);
        this.functionsSubMenu.addSeparator();
        this.copyMi = new MenuItem(resources.getString("VP_COPY"));
        this.pasteMi = new MenuItem(resources.getString("VP_PAST"));
        this.functionsSubMenu.add(this.copyMi);
        this.functionsSubMenu.add(this.pasteMi);
        this.helpMi.addActionListener(new ListenMainPopup(30, this));
        this.homeMi.addActionListener(new ListenMainPopup(22, this));
        this.setHomeMi.addActionListener(new ListenMainPopup(21, this));
        this.viewAllMi.addActionListener(new ListenMainPopup(20, this));
        this.seekMi.addActionListener(new ListenMainPopup(24, this));
        this.copyMi.addActionListener(new ListenMainPopup(28, this));
        this.pasteMi.addActionListener(new ListenMainPopup(29, this));
    }

    protected void buildDrawStyleSubMenu() {
        this.drawStyleSubMenu = new Menu(resources.getString("VP_DRAW_STYLE1"));
        this.add(this.drawStyleSubMenu);
        this.drawGroup = new CheckboxMenuGroup();
        this.asisCmi = new GroupedCheckboxMenuItem(resources.getString("VP_AS_IS"), this.drawGroup);
        this.hidlinCmi = new GroupedCheckboxMenuItem(resources.getString("VP_HIDDEN_LINE"), this.drawGroup);
        this.notextCmi = new GroupedCheckboxMenuItem(resources.getString("VP_NO_TEXTURE"), this.drawGroup);
        this.lowresCmi = new GroupedCheckboxMenuItem(resources.getString("VP_LOW_RES"), this.drawGroup);
        this.wireCmi = new GroupedCheckboxMenuItem(resources.getString("VP_WIRE"), this.drawGroup);
        this.pointsCmi = new GroupedCheckboxMenuItem(resources.getString("VP_POINTS"), this.drawGroup);
        this.nodethCmi = new GroupedCheckboxMenuItem(resources.getString("VP_BB_NO_DEPTH"), this.drawGroup);
        this.asisCmi.setState();
        this.drawStyleSubMenu.add(this.asisCmi);
        this.drawStyleSubMenu.add(this.hidlinCmi);
        this.drawStyleSubMenu.add(this.notextCmi);
        this.drawStyleSubMenu.add(this.lowresCmi);
        this.drawStyleSubMenu.add(this.wireCmi);
        this.drawStyleSubMenu.add(this.pointsCmi);
        this.drawStyleSubMenu.add(this.nodethCmi);
        this.asisCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.AS_IS, this));
        this.hidlinCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.HIDDEN_LINE, this));
        this.notextCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.NO_TXT, this));
        this.lowresCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.LOW_RES, this));
        this.wireCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.LINE, this));
        this.pointsCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.POINT, this));
        this.nodethCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.BBOX, this));
        this.drawStyleSubMenu.addSeparator();
        this.drawMoveGroup = new CheckboxMenuGroup();
        this.mvsameasCmi = new GroupedCheckboxMenuItem(resources.getString("VP_MOVE_SAME_AS"), this.drawMoveGroup);
        this.mvnotextCmi = new GroupedCheckboxMenuItem(resources.getString("VP_MOVE_NO_TXT"), this.drawMoveGroup);
        this.mvlowresCmi = new GroupedCheckboxMenuItem(resources.getString("VP_MOVE_LOW_RES"), this.drawMoveGroup);
        this.mvwireCmi = new GroupedCheckboxMenuItem(resources.getString("VP_MOVE_LINE"), this.drawMoveGroup);
        this.mvlowireCmi = new GroupedCheckboxMenuItem(resources.getString("VP_MOVE_LOW_LINE"), this.drawMoveGroup);
        this.mvpointCmi = new GroupedCheckboxMenuItem(resources.getString("VP_MOVE_POINT"), this.drawMoveGroup);
        this.mvlopoinCmi = new GroupedCheckboxMenuItem(resources.getString("VP_MOVE_LOW_POINT"), this.drawMoveGroup);
        this.mvbboxCmi = new GroupedCheckboxMenuItem(resources.getString("VP_MOVE_BBOX"), this.drawMoveGroup);
        this.mvsameasCmi.setState();
        this.drawStyleSubMenu.add(this.mvsameasCmi);
        this.drawStyleSubMenu.add(this.mvnotextCmi);
        this.drawStyleSubMenu.add(this.mvlowresCmi);
        this.drawStyleSubMenu.add(this.mvwireCmi);
        this.drawStyleSubMenu.add(this.mvlowireCmi);
        this.drawStyleSubMenu.add(this.mvpointCmi);
        this.drawStyleSubMenu.add(this.mvlopoinCmi);
        this.drawStyleSubMenu.add(this.mvbboxCmi);
        this.mvsameasCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.MOVE_SAME_AS, this));
        this.mvnotextCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.MOVE_NO_TXT, this));
        this.mvlowresCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.MOVE_LOW_RES, this));
        this.mvwireCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.MOVE_LINE, this));
        this.mvlowireCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.MOVE_LOW_LINE, this));
        this.mvpointCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.MOVE_POINT, this));
        this.mvlopoinCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.MOVE_LOW_POINT, this));
        this.mvbboxCmi.addItemListener(new ListenDrawStylePopup(DrawChoices.MOVE_BBOX, this));
        this.drawStyleSubMenu.addSeparator();
        this.bufferGroup = new CheckboxMenuGroup();
        this.sbufCmi = new GroupedCheckboxMenuItem(resources.getString("VP_SBUFFER"), this.bufferGroup);
        this.dbufCmi = new GroupedCheckboxMenuItem(resources.getString("VP_DBUFFER"), this.bufferGroup);
        this.ibufCmi = new GroupedCheckboxMenuItem(resources.getString("VP_IBUFFER"), this.bufferGroup);
        this.sbufCmi.setState();
        this.drawStyleSubMenu.add(this.sbufCmi);
        this.drawStyleSubMenu.add(this.dbufCmi);
        this.sbufCmi.addItemListener(new ListenBufferStylePopup(Scene.BufferType.BUFFER_SINGLE, this));
        this.dbufCmi.addItemListener(new ListenBufferStylePopup(Scene.BufferType.BUFFER_DOUBLE, this));
        this.ibufCmi.addItemListener(new ListenBufferStylePopup(Scene.BufferType.BUFFER_INTERACTIVE, this));
    }

    protected void setPopupMenuString(String string) {
        this.popupTitle = new String(string);
    }

    public void openHelpCard(String string) {
        if (this.panel != null) {
            this.panel.openHelpCard(string);
        }
    }

    @Override
    public void update(Observable observable, Object object) throws IllegalArgumentException {
        Enum enum_;
        if (!(observable instanceof SceneObservable) || !(((SceneObservable)observable).getScene() instanceof SwScene)) {
            throw new IllegalArgumentException("Observable arg must be a com.openinventor.util.SceneObservable created by a com.openinventor.inventor.awt.SwScene");
        }
        if (this.scene == null || ((SceneObservable)observable).getScene() != this.scene) {
            throw new IllegalArgumentException("SwScene have not been registered as a scene for this Handler");
        }
        if (this.scene.isViewingUpdated()) {
            this.viewingCmi.setState(this.scene.isViewing());
        }
        if (this.scene.isDrawStyleUpdated()) {
            enum_ = this.scene.getDrawStyle(0);
            GroupedCheckboxMenuItem groupedCheckboxMenuItem = null;
            GroupedCheckboxMenuItem groupedCheckboxMenuItem2 = null;
            Object var6_6 = null;
            switch (2.$SwitchMap$com$openinventor$util$Scene$DrawStyle[enum_.ordinal()]) {
                case 1: {
                    groupedCheckboxMenuItem = this.asisCmi;
                    break;
                }
                case 2: {
                    groupedCheckboxMenuItem = this.hidlinCmi;
                    break;
                }
                case 3: {
                    groupedCheckboxMenuItem = this.notextCmi;
                    groupedCheckboxMenuItem2 = this.mvnotextCmi;
                    break;
                }
                case 4: {
                    groupedCheckboxMenuItem = this.lowresCmi;
                    groupedCheckboxMenuItem2 = this.mvlowresCmi;
                    break;
                }
                case 5: {
                    groupedCheckboxMenuItem = this.wireCmi;
                    groupedCheckboxMenuItem2 = this.mvwireCmi;
                    break;
                }
                case 6: {
                    groupedCheckboxMenuItem = this.pointsCmi;
                    groupedCheckboxMenuItem2 = this.mvpointCmi;
                    break;
                }
                case 7: {
                    groupedCheckboxMenuItem = this.nodethCmi;
                    groupedCheckboxMenuItem2 = this.mvbboxCmi;
                    break;
                }
                case 8: {
                    groupedCheckboxMenuItem2 = this.mvsameasCmi;
                    break;
                }
                case 9: {
                    groupedCheckboxMenuItem2 = this.mvlowireCmi;
                    break;
                }
                case 10: {
                    groupedCheckboxMenuItem2 = this.mvlopoinCmi;
                }
            }
            if (groupedCheckboxMenuItem != null) {
                groupedCheckboxMenuItem.setState();
            }
            if (groupedCheckboxMenuItem2 != null) {
                groupedCheckboxMenuItem2.setState();
            }
        }
        if (this.scene.isBufferingTypeUpdated()) {
            enum_ = this.scene.getBufferingType();
            switch (2.$SwitchMap$com$openinventor$util$Scene$BufferType[enum_.ordinal()]) {
                case 1: {
                    this.sbufCmi.setState();
                    break;
                }
                case 2: {
                    this.dbufCmi.setState();
                    break;
                }
                case 3: {
                    this.ibufCmi.setState();
                }
            }
        }
        if (this.scene.isHeadlightUpdated()) {
            this.headlightCmi.setState(this.scene.isHeadlight());
        }
    }

    @Override
    public void setScene(Scene scene) throws IllegalArgumentException {
        if (!(scene instanceof SwScene)) {
            throw new IllegalArgumentException("Scene argument must be a com.openinventor.inventor.awt.SwScene");
        }
        this.deleteScene();
        this.scene = (SwScene)scene;
        this.scene.addSceneHandler(this);
        if (this.preferences != null) {
            this.preferences.dispose();
        }
        this.preferences = null;
    }

    @Override
    public void deleteScene() {
        if (this.scene != null) {
            this.scene.deleteSceneHandler(this);
        }
        this.scene = null;
    }

    @Override
    public void viewAll() {
        if (this.scene != null) {
            this.scene.viewAll();
        }
    }

    @Override
    public void saveHomePosition() {
        if (this.scene != null) {
            this.scene.saveHomePosition();
        }
    }

    @Override
    public void resetToHomePosition() {
        if (this.scene != null) {
            this.scene.resetToHomePosition();
        }
    }

    @Override
    public void stopAnimating() {
        if (this.scene != null) {
            this.scene.stopAnimating();
        }
    }

    @Override
    public void setSceneSize(Dimension dimension) {
        if (this.scene != null) {
            this.scene.setSize(dimension);
        }
    }

    @Override
    public void copyScene(double d) {
        if (this.scene != null) {
            this.scene.copyView(d);
        }
    }

    @Override
    public void pasteScene(double d) {
        if (this.scene != null) {
            this.scene.pasteView(d);
        }
    }

    @Override
    public void redraw() {
        if (this.scene != null) {
            this.scene.redraw();
        }
    }

    @Override
    public void scheduleRedraw() {
        if (this.scene != null) {
            this.scene.scheduleRedraw();
        }
    }

    @Override
    public boolean seekToPoint(SbVec2s sbVec2s) {
        if (this.scene != null) {
            return this.scene.seekToPoint(sbVec2s);
        }
        return false;
    }

    @Override
    public void updateMode(AWTEvent aWTEvent) {
        if (this.scene != null) {
            this.scene.updateMode(aWTEvent);
        }
    }

    @Override
    public void changeCameraValues(SoCamera soCamera) {
        if (this.scene != null) {
            this.scene.changeCameraValues(soCamera);
        }
    }

    @Override
    public void toggleCameraClass() {
        if (this.scene != null) {
            this.scene.toggleCameraClass();
        }
    }

    @Override
    public void adjustCameraClippingPlanes() {
        if (this.scene != null) {
            this.scene.adjustCameraClippingPlanes();
        }
    }

    @Override
    public void dollyCamera(SbVec2s sbVec2s) {
        if (this.scene != null) {
            this.scene.dollyCamera(sbVec2s);
        }
    }

    @Override
    public void spinCamera(SbVec2f sbVec2f) {
        if (this.scene != null) {
            this.scene.spinCamera(sbVec2f);
        }
    }

    @Override
    public void rollCamera(SbVec2s sbVec2s) {
        if (this.scene != null) {
            this.scene.rollCamera(sbVec2s);
        }
    }

    @Override
    public void rotateCamera(SbRotation sbRotation) {
        if (this.scene != null) {
            this.scene.rotateCamera(sbRotation);
        }
    }

    @Override
    public void panCamera(SbVec2f sbVec2f) {
        if (this.scene != null) {
            this.scene.panCamera(sbVec2f);
        }
    }

    @Override
    public void tiltCamera(float f) {
        if (this.scene != null) {
            this.scene.tiltCamera(f);
        }
    }

    @Override
    public void setPlane(SbVec3f sbVec3f, SbVec3f sbVec3f2) {
        if (this.scene != null) {
            this.scene.setPlane(sbVec3f, sbVec3f2);
        }
    }

    @Override
    public void setSceneGraph(SoNode soNode) {
        if (this.scene != null) {
            this.scene.setSceneGraph(soNode);
        }
    }

    @Override
    public void setBackgroundColor(SbColor sbColor) {
        if (this.scene != null) {
            this.scene.setBackgroundColor(sbColor);
        }
    }

    void showPreferences() {
        if (this.preferences == null) {
            this.preferences = new Frame(resources.getString("PS_TITLE"));
            this.preferencesPanel = this.scene.getPreferencesPanel();
            this.preferences.add(this.preferencesPanel);
            this.preferences.pack();
            WindowAdapter windowAdapter = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    SwPopupMenu.this.preferences.setVisible(false);
                }
            };
            this.preferences.addWindowListener(windowAdapter);
        }
        this.preferences.setVisible(true);
    }

    static {
        DEBUG = Inventor.VERBOSE_LEVEL > 0;
        resources = (SwResources)ResourceBundle.getBundle("com.openinventor.inventor.awt.SwResources", SwPanel.defaultLocale);
    }

    class ListenMainPopup
    extends ListenPopup {
        int type;

        public ListenMainPopup(int n, SwPopupMenu swPopupMenu2) {
            super(swPopupMenu2);
            this.type = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DEBUG) {
                System.out.println("DEBUG: JAVA MTHD->ListenMainPopup.actionPerformed");
            }
            double d = System.currentTimeMillis();
            switch (this.type) {
                case 30: {
                    this.p.panel.openHelpCard("SwViewer.help");
                    break;
                }
                case 20: {
                    this.p.viewAll();
                    break;
                }
                case 21: {
                    this.p.saveHomePosition();
                    break;
                }
                case 22: {
                    this.p.resetToHomePosition();
                    break;
                }
                case 24: {
                    if (this.p.scene == null) break;
                    this.p.scene.setSeekMode(!this.p.scene.isSeekMode());
                    break;
                }
                case 25: {
                    this.p.showPreferences();
                    break;
                }
                case 23: {
                    if (this.p.scene == null) break;
                    this.p.scene.setHeadlight(!this.p.scene.isHeadlight());
                    break;
                }
                case 26: {
                    if (this.p.scene == null) break;
                    this.p.scene.setViewing(!this.p.scene.isViewing(), actionEvent);
                    break;
                }
                case 27: {
                    SwPopupMenu.this.panel.setDecoration(!SwPopupMenu.this.panel.isDecoration());
                    break;
                }
                case 28: {
                    this.p.copyScene(d);
                    break;
                }
                case 29: {
                    this.p.pasteScene(d);
                }
            }
            super.actionPerformed(actionEvent);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (DEBUG) {
                System.out.println("DEBUG: JAVA MTHD->ListenMainPopup.itemStateChanged");
            }
            switch (this.type) {
                case 23: {
                    if (this.p.scene == null) break;
                    this.p.scene.setHeadlight(!this.p.scene.isHeadlight());
                    break;
                }
                case 26: {
                    if (this.p.scene == null) break;
                    this.p.scene.setViewing(!this.p.scene.isViewing(), itemEvent);
                    break;
                }
                case 27: {
                    SwPopupMenu.this.panel.setDecoration(!SwPopupMenu.this.panel.isDecoration());
                }
            }
            super.itemStateChanged(itemEvent);
        }
    }

    class ListenDrawStylePopup
    extends ListenPopup {
        DrawChoices type;

        public ListenDrawStylePopup(DrawChoices drawChoices, SwPopupMenu swPopupMenu2) {
            super(swPopupMenu2);
            this.type = drawChoices;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (DEBUG) {
                System.out.println("DEBUG: JAVA MTHD->ListenDrawStylePopup.itemStateChanged");
            }
            switch (this.type) {
                case AS_IS: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(0, Scene.DrawStyle.VIEW_AS_IS);
                    break;
                }
                case HIDDEN_LINE: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(0, Scene.DrawStyle.VIEW_HIDDEN_LINE);
                    break;
                }
                case NO_TXT: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(0, Scene.DrawStyle.VIEW_NO_TEXTURE);
                    break;
                }
                case LOW_RES: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(0, Scene.DrawStyle.VIEW_LOW_COMPLEXITY);
                    break;
                }
                case LINE: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(0, Scene.DrawStyle.VIEW_LINE);
                    break;
                }
                case POINT: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(0, Scene.DrawStyle.VIEW_POINT);
                    break;
                }
                case BBOX: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(0, Scene.DrawStyle.VIEW_BBOX);
                    break;
                }
                case MOVE_SAME_AS: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(1, Scene.DrawStyle.VIEW_SAME_AS_STILL);
                    break;
                }
                case MOVE_NO_TXT: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(1, Scene.DrawStyle.VIEW_NO_TEXTURE);
                    break;
                }
                case MOVE_LOW_RES: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(1, Scene.DrawStyle.VIEW_LOW_COMPLEXITY);
                    break;
                }
                case MOVE_LINE: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(1, Scene.DrawStyle.VIEW_LINE);
                    break;
                }
                case MOVE_LOW_LINE: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(1, Scene.DrawStyle.VIEW_LOW_RES_LINE);
                    break;
                }
                case MOVE_POINT: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(1, Scene.DrawStyle.VIEW_POINT);
                    break;
                }
                case MOVE_LOW_POINT: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(1, Scene.DrawStyle.VIEW_LOW_RES_POINT);
                    break;
                }
                case MOVE_BBOX: {
                    if (this.p.scene == null) break;
                    this.p.scene.setDrawStyle(1, Scene.DrawStyle.VIEW_BBOX);
                }
            }
            super.itemStateChanged(itemEvent);
        }
    }

    class ListenBufferStylePopup
    extends ListenPopup {
        Scene.BufferType type;

        public ListenBufferStylePopup(Scene.BufferType bufferType, SwPopupMenu swPopupMenu2) {
            super(swPopupMenu2);
            this.type = bufferType;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (DEBUG) {
                System.out.println("DEBUG: JAVA MTHD->ListenBufferStylePopup.itemStateChanged");
            }
            if (this.p.scene != null) {
                this.p.scene.setBufferingType(this.type);
            }
            super.itemStateChanged(itemEvent);
        }
    }

    class ListenPopup
    implements ActionListener,
    ItemListener {
        SwPopupMenu p;

        public ListenPopup(SwPopupMenu swPopupMenu2) {
            this.p = swPopupMenu2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }

    public static enum DrawChoices implements IntegerValuedEnum
    {
        AS_IS(Scene.DrawStyle.VIEW_AS_IS.getValue()),
        HIDDEN_LINE(Scene.DrawStyle.VIEW_HIDDEN_LINE.getValue()),
        NO_TXT(Scene.DrawStyle.VIEW_NO_TEXTURE.getValue()),
        LOW_RES(Scene.DrawStyle.VIEW_LOW_COMPLEXITY.getValue()),
        LINE(Scene.DrawStyle.VIEW_LINE.getValue()),
        POINT(Scene.DrawStyle.VIEW_POINT.getValue()),
        BBOX(Scene.DrawStyle.VIEW_BBOX.getValue()),
        MOVE_SAME_AS(7),
        MOVE_NO_TXT(8),
        MOVE_LOW_RES(9),
        MOVE_LINE(10),
        MOVE_LOW_LINE(11),
        MOVE_POINT(12),
        MOVE_LOW_POINT(13),
        MOVE_BBOX(14),
        DRAW_STYLE_NUM(15);

        private int value;

        private DrawChoices(int n2) {
            this.value = n2;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

