/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.awt.SwPanel;
import com.openinventor.inventor.awt.SwScene;
import com.openinventor.inventor.awt.SwWheel;
import com.openinventor.inventor.awt.event.SwWheelEvent;
import com.openinventor.inventor.awt.event.SwWheelListener;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.JOptionPane;

@Deprecated
public class SwPreferences
extends SwPanel {
    private GridBagLayout layout;
    private CheckboxGroup group1;
    private CheckboxGroup group2;
    Checkbox cbPoint;
    Checkbox cbObject;
    Checkbox cbPercent;
    Checkbox cbAbsolute;
    Checkbox cbClipPlanes;
    Checkbox cbStereoSwitch;
    Choice chStereoMode;
    TextField seekDistText;
    TextField zoomText;
    TextField sliderZoomToText;
    TextField seekAnimText;
    TextField nearText;
    TextField farText;
    TextField stereoText;
    TextField sliderZoomText;
    Label seekAnim;
    Label seconds;
    Label seekTo;
    Label seekDist;
    Label camZoom;
    Label sliderZoom;
    Label sliderZoomTo;
    Label camRot;
    Label nearPlane;
    Label farPlane;
    Label stereoSwitch;
    Panel stereoViewing;
    Panel clipPlane;
    SwWheel seekWheel;
    SwWheel zoomWheel;
    SwWheel nearWheel;
    SwWheel farWheel;
    SwWheel rotWheel;
    SbVec2f zoomSldRange;
    float clipNearWheelVal;
    float clipFarWheelVal;
    float stereoWheelVal;
    static final int MIN = 0;
    static final int MAX = 1;
    static final int NEAR = 0;
    static final int FAR = 1;
    static final int POINT = 0;
    static final int OBJECT = 1;
    static final int PERCENT = 0;
    static final int ABSOLUTE = 1;

    public SwPreferences(SwScene swScene) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwPreferences.SwPreferences");
        }
        this.zoomSldRange = new SbVec2f(1.0f, 140.0f);
        this.buildGUI();
        this.setScene(swScene);
        this.updateLocalComponents();
    }

    private GridBagConstraints constraints(int n, int n2, int n3, int n4, float f, float f2, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = f;
        gridBagConstraints.weighty = f2;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.ipadx = n7;
        gridBagConstraints.ipady = n8;
        gridBagConstraints.insets = new Insets(n9, n10, n11, n12);
        return gridBagConstraints;
    }

    protected void buildGUI() {
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        int[] nArray = new int[]{30, 25, 35, 25, 30, 30, 25, 0, 25, 0};
        int[] nArray2 = new int[]{130, 60, 85, 35, 85};
        this.layout.rowHeights = nArray;
        this.layout.columnWidths = nArray2;
        Font font = new Font("Dialog", 1, 12);
        this.seekDistText = new TextField(8);
        this.zoomText = new TextField(8);
        this.sliderZoomToText = new TextField(8);
        this.sliderZoomText = new TextField(8);
        this.seekAnimText = new TextField(8);
        this.nearText = new TextField(8);
        this.farText = new TextField(8);
        this.stereoText = new TextField(8);
        this.seekAnimText.addActionListener(new SeekPrefSheetField());
        this.seekDistText.addActionListener(new SeekDistField());
        this.zoomText.addActionListener(new ZoomField());
        this.sliderZoomText.addActionListener(new ZoomPrefSheetField(0));
        this.sliderZoomToText.addActionListener(new ZoomPrefSheetField(1));
        this.nearText.addActionListener(new ListenClipField(0));
        this.farText.addActionListener(new ListenClipField(1));
        this.stereoText.addActionListener(new ListenStereoField());
        this.group1 = new CheckboxGroup();
        this.group2 = new CheckboxGroup();
        this.cbPoint = new Checkbox(resources.getString("PS_SEEK_TO_PT"), false, this.group1);
        this.cbObject = new Checkbox(resources.getString("PS_SEEK_TO_OBJ"), true, this.group1);
        this.cbPercent = new Checkbox(resources.getString("PS_SEEK_DIST_PERCENT"), false, this.group2);
        this.cbAbsolute = new Checkbox(resources.getString("PS_SEEK_DIST_ABS"), true, this.group2);
        this.cbClipPlanes = new Checkbox(resources.getString("PS_AUTO_CLIPPING_PLANES"));
        this.cbStereoSwitch = new Checkbox();
        this.chStereoMode = new Choice();
        this.chStereoMode.add(resources.getString("PS_NO_STEREO_VIEWING"));
        this.chStereoMode.add(resources.getString("PS_OGL_STEREO_VIEWING"));
        this.chStereoMode.add(resources.getString("PS_RED_CYAN_STEREO_VIEWING"));
        this.chStereoMode.add(resources.getString("PS_GREEN_MAGENTA_STEREO_VIEWING"));
        this.chStereoMode.add(resources.getString("PS_BLUE_YELLOW_STEREO_VIEWING"));
        this.cbClipPlanes.setFont(font);
        this.chStereoMode.setFont(font);
        this.cbStereoSwitch.setFont(font);
        this.cbPoint.addItemListener(new SeekPrefSheetToggle(0));
        this.cbObject.addItemListener(new SeekPrefSheetToggle(1));
        this.cbPercent.addItemListener(new SeekDistPrefSheetToggle(0));
        this.cbAbsolute.addItemListener(new SeekDistPrefSheetToggle(1));
        this.cbClipPlanes.addItemListener(new ClipPrefSheetToggle());
        this.chStereoMode.addItemListener(new StereoPrefSheetMode());
        this.cbStereoSwitch.addItemListener(new StereoPrefSheetSwitch());
        this.seekAnim = new Label(resources.getString("PS_SEEK_ANIM_TIME"));
        this.seconds = new Label(resources.getString("PS_SEEK_ANIM_TIME_UNIT"));
        this.seekTo = new Label(resources.getString("PS_SEEK_TO"));
        this.seekDist = new Label(resources.getString("PS_SEEK_DISTANCE"));
        this.camZoom = new Label(resources.getString("PS_CAMERA_ZOOM"));
        this.sliderZoom = new Label(resources.getString("PS_ZOOM_FROM"));
        this.sliderZoomTo = new Label(resources.getString("PS_ZOOM_TO"));
        this.camRot = new Label(resources.getString("PS_CAM_ROTATION"));
        this.nearPlane = new Label(resources.getString("PS_NEAR_PLANE"));
        this.farPlane = new Label(resources.getString("PS_FAR_PLANE"));
        this.stereoSwitch = new Label(resources.getString("PS_SWITCH_LR"));
        this.seekAnim.setFont(font);
        this.seconds.setFont(font);
        this.seekTo.setFont(font);
        this.seekDist.setFont(font);
        this.camZoom.setFont(font);
        this.sliderZoom.setFont(font);
        this.sliderZoomTo.setFont(font);
        this.nearPlane.setFont(font);
        this.farPlane.setFont(font);
        this.camRot.setFont(font);
        this.seekWheel = new SwWheel(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 360.0f, true);
        this.zoomWheel = new SwWheel(0.0f, 1000.0f, 360.0f, 0.0f, 0.0f, 1000.0f, true);
        this.farWheel = new SwWheel(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 360.0f, true);
        this.nearWheel = new SwWheel(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 360.0f, true);
        this.rotWheel = new SwWheel(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 360.0f, true);
        this.seekWheel.addWheelListener(new SeekDistWheel());
        this.zoomWheel.addWheelListener(new ZoomWheel());
        this.nearWheel.addWheelListener(new ClipNearWheel());
        this.farWheel.addWheelListener(new ClipFarWheel());
        this.rotWheel.addWheelListener(new StereoWheel());
        this.clipPlane = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.clipPlane.setLayout(gridBagLayout);
        int[] nArray3 = new int[]{30, 30};
        int[] nArray4 = new int[]{170, 130, 75};
        gridBagLayout.rowHeights = nArray3;
        gridBagLayout.columnWidths = nArray4;
        gridBagLayout.setConstraints(this.nearPlane, this.constraints(0, 0, 1, 1, 0.0f, 0.0f, 13, 0, 0, 0, 0, 0, 0, 0));
        this.clipPlane.add(this.nearPlane);
        gridBagLayout.setConstraints(this.farPlane, this.constraints(0, 1, 1, 1, 0.0f, 0.0f, 13, 0, 0, 0, 0, 0, 0, 0));
        this.clipPlane.add(this.farPlane);
        gridBagLayout.setConstraints(this.nearText, this.constraints(2, 0, 1, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.clipPlane.add(this.nearText);
        gridBagLayout.setConstraints(this.farText, this.constraints(2, 1, 1, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.clipPlane.add(this.farText);
        gridBagLayout.setConstraints(this.nearWheel, this.constraints(1, 0, 1, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.clipPlane.add(this.nearWheel);
        gridBagLayout.setConstraints(this.farWheel, this.constraints(1, 1, 1, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.clipPlane.add(this.farWheel);
        this.stereoViewing = new Panel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.stereoViewing.setLayout(gridBagLayout2);
        int[] nArray5 = new int[]{30};
        int[] nArray6 = new int[]{170, 130, 75};
        gridBagLayout2.rowHeights = nArray5;
        gridBagLayout2.columnWidths = nArray6;
        gridBagLayout2.setConstraints(this.camRot, this.constraints(0, 0, 1, 1, 0.0f, 0.0f, 13, 0, 0, 0, 0, 0, 0, 0));
        this.stereoViewing.add(this.camRot);
        gridBagLayout2.setConstraints(this.rotWheel, this.constraints(1, 0, 1, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.stereoViewing.add(this.rotWheel);
        gridBagLayout2.setConstraints(this.stereoText, this.constraints(2, 0, 1, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.stereoViewing.add(this.stereoText);
        gridBagLayout2.setConstraints(this.stereoSwitch, this.constraints(3, 0, 1, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.stereoViewing.add(this.stereoSwitch);
        gridBagLayout2.setConstraints(this.cbStereoSwitch, this.constraints(4, 0, 1, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.stereoViewing.add(this.cbStereoSwitch);
        this.layout.setConstraints(this.zoomText, this.constraints(4, 4, 1, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.zoomText);
        this.layout.setConstraints(this.seekDistText, this.constraints(4, 2, 1, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.seekDistText);
        this.layout.setConstraints(this.seekAnimText, this.constraints(2, 0, 2, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.seekAnimText);
        this.layout.setConstraints(this.sliderZoomText, this.constraints(2, 5, 1, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.sliderZoomText);
        this.layout.setConstraints(this.sliderZoomToText, this.constraints(4, 5, 1, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.sliderZoomToText);
        this.layout.setConstraints(this.cbPercent, this.constraints(0, 3, 2, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.cbPercent);
        this.layout.setConstraints(this.camZoom, this.constraints(0, 4, 1, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.camZoom);
        this.layout.setConstraints(this.seekAnim, this.constraints(0, 0, 2, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.seekAnim);
        this.layout.setConstraints(this.cbClipPlanes, this.constraints(0, 6, 2, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.cbClipPlanes);
        this.layout.setConstraints(this.sliderZoom, this.constraints(0, 5, 2, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.sliderZoom);
        this.layout.setConstraints(this.cbPoint, this.constraints(1, 1, 1, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.cbPoint);
        this.layout.setConstraints(this.seconds, this.constraints(4, 0, 1, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.seconds);
        this.layout.setConstraints(this.chStereoMode, this.constraints(0, 8, 1, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.chStereoMode);
        this.layout.setConstraints(this.sliderZoomTo, this.constraints(3, 5, 1, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.sliderZoomTo);
        this.layout.setConstraints(this.seekTo, this.constraints(0, 1, 1, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.seekTo);
        this.layout.setConstraints(this.seekWheel, this.constraints(1, 2, 3, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.seekWheel);
        this.layout.setConstraints(this.zoomWheel, this.constraints(1, 4, 3, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.zoomWheel);
        this.layout.setConstraints(this.seekDist, this.constraints(0, 2, 1, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.seekDist);
        this.layout.setConstraints(this.clipPlane, this.constraints(0, 7, 5, 1, 0.0f, 0.0f, 17, 2, 0, 0, 0, 0, 0, 0));
        this.add(this.clipPlane);
        this.layout.setConstraints(this.stereoViewing, this.constraints(0, 9, 5, 1, 0.0f, 0.0f, 17, 2, 0, 0, 0, 0, 0, 0));
        this.add(this.stereoViewing);
        this.layout.setConstraints(this.cbObject, this.constraints(2, 1, 2, 1, 0.0f, 0.0f, 10, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.cbObject);
        this.layout.setConstraints(this.cbAbsolute, this.constraints(2, 3, 3, 1, 0.0f, 0.0f, 17, 0, 0, 0, 0, 0, 0, 0));
        this.add(this.cbAbsolute);
    }

    @Override
    public void setResources(Locale locale) {
        super.setResources(locale);
        this.cbPoint.setLabel(resources.getString("PS_SEEK_TO_PT"));
        this.cbObject.setLabel(resources.getString("PS_SEEK_TO_OBJ"));
        this.cbPercent.setLabel(resources.getString("PS_SEEK_DIST_PERCENT"));
        this.cbAbsolute.setLabel(resources.getString("PS_SEEK_DIST_ABS"));
        this.cbClipPlanes.setLabel(resources.getString("PS_AUTO_CLIPPING_PLANES"));
        this.seekAnim.setText(resources.getString("PS_SEEK_ANIM_TIME"));
        this.seconds.setText(resources.getString("PS_SEEK_ANIM_TIME_UNIT"));
        this.seekTo.setText(resources.getString("PS_SEEK_TO"));
        this.seekDist.setText(resources.getString("PS_SEEK_DISTANCE"));
        this.camZoom.setText(resources.getString("PS_CAMERA_ZOOM"));
        this.sliderZoom.setText(resources.getString("PS_ZOOM_FROM"));
        this.sliderZoomTo.setText(resources.getString("PS_ZOOM_TO"));
        this.camRot.setText(resources.getString("PS_CAM_ROTATION"));
        this.nearPlane.setText(resources.getString("PS_NEAR_PLANE"));
        this.farPlane.setText(resources.getString("PS_FAR_PLANE"));
        this.stereoSwitch.setText(resources.getString("PS_SWITCH_LR"));
        this.chStereoMode.removeAll();
        this.chStereoMode.add(resources.getString("PS_NO_STEREO_VIEWING"));
        this.chStereoMode.add(resources.getString("PS_OGL_STEREO_VIEWING"));
        this.chStereoMode.add(resources.getString("PS_RED_CYAN_STEREO_VIEWING"));
        this.chStereoMode.add(resources.getString("PS_GREEN_MAGENTA_STEREO_VIEWING"));
        this.chStereoMode.add(resources.getString("PS_BLUE_YELLOW_STEREO_VIEWING"));
    }

    protected void addPreferences(Panel panel) {
        if (panel == null) {
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.layout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
    }

    void updateLocalComponents() {
        this.cbClipPlanes.setState(this.scene.isAutoClipping());
        this.clipPlane.setEnabled(!this.scene.isAutoClipping());
        this.nearWheel.setEnabled(!this.scene.isAutoClipping());
        this.farWheel.setEnabled(!this.scene.isAutoClipping());
        this.chStereoMode.select(this.scene.getStereoMode());
        this.cbStereoSwitch.setState(this.scene.getStereoSwitch());
        this.stereoViewing.setEnabled(this.scene.getStereoMode() != 0);
        this.group1.setSelectedCheckbox(this.scene.isDetailSeek() ? this.cbPoint : this.cbObject);
        this.zoomText.setText(Float.toString(this.scene.getCameraZoom()));
        float f = this.zoomSldRange.getX();
        float f2 = this.zoomSldRange.getY();
        if (f > f2) {
            f = f2 - f;
            f2 -= f;
            f += f2;
        }
        float f3 = (float)Math.sqrt((this.scene.getCameraZoom() - f) / (f2 - f));
        this.zoomWheel.setValue(f3 * (this.zoomWheel.getUpperBound() - this.zoomWheel.getLowerBound()) + this.zoomWheel.getLowerBound(), false);
        this.nearText.setText(Float.toString(this.scene.getCamera().nearDistance.getValue()));
        this.farText.setText(Float.toString(this.scene.getCamera().farDistance.getValue()));
        this.stereoText.setText(Float.toString(this.scene.getStereoOffset()));
        this.seekAnimText.setText(Float.toString(this.scene.getSeekTime()));
        this.seekDistText.setText(Float.toString(this.scene.getSeekDistance()));
        this.seekWheel.setValue((float)(360.0 * Math.log(this.scene.getSeekDistance()) / Math.log(80.0)), false);
        this.group2.setSelectedCheckbox(this.scene.isSeekDistAsPercentage() ? this.cbPercent : this.cbAbsolute);
        this.sliderZoomText.setText(Float.toString(this.zoomSldRange.getX()));
        this.sliderZoomToText.setText(Float.toString(this.zoomSldRange.getY()));
        this.validate();
    }

    class ListenStereoField
    implements ActionListener {
        ListenStereoField() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            float f;
            float f2 = SwPreferences.this.scene.getStereoOffset();
            try {
                f = Float.valueOf(SwPreferences.this.stereoText.getText()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                f = f2;
            }
            if (f > 0.0f) {
                SwPreferences.this.scene.setStereoOffset(f);
                SwPreferences.this.scene.scheduleRedraw();
            } else {
                f = f2;
            }
            SwPreferences.this.stereoText.setText(Float.toString(SwPreferences.this.scene.getStereoOffset()));
            SwPreferences.this.stereoText.setCaretPosition(0);
        }
    }

    class ListenClipField
    implements ActionListener {
        int type;

        public ListenClipField(int n) {
            this.type = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SoCamera soCamera = SwPreferences.this.scene.getCamera();
            if (soCamera == null) {
                return;
            }
            float f = 0.0f;
            float f2 = 0.0f;
            try {
                switch (this.type) {
                    case 0: {
                        f = soCamera.nearDistance.getValue();
                        f2 = Float.valueOf(SwPreferences.this.nearText.getText()).floatValue();
                        break;
                    }
                    case 1: {
                        f = soCamera.farDistance.getValue();
                        f2 = Float.valueOf(SwPreferences.this.farText.getText()).floatValue();
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                f2 = f;
            }
            if (f2 > 0.0f || soCamera instanceof SoOrthographicCamera) {
                switch (this.type) {
                    case 0: {
                        soCamera.nearDistance.setValue(f2);
                        SwPreferences.this.nearText.setText(Float.toString(soCamera.nearDistance.getValue()));
                        SwPreferences.this.nearText.setCaretPosition(0);
                        break;
                    }
                    case 1: {
                        soCamera.farDistance.setValue(f2);
                        SwPreferences.this.farText.setText(Float.toString(soCamera.farDistance.getValue()));
                        SwPreferences.this.farText.setCaretPosition(0);
                    }
                }
            }
        }
    }

    class ZoomPrefSheetField
    implements ActionListener {
        int type;

        public ZoomPrefSheetField(int n) {
            this.type = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SoCamera soCamera = SwPreferences.this.scene.getCamera();
            float f = 0.0f;
            float f2 = 0.0f;
            try {
                if (this.type == 0) {
                    f2 = SwPreferences.this.zoomSldRange.getX();
                    f = Float.valueOf(SwPreferences.this.sliderZoomText.getText()).floatValue();
                } else {
                    f2 = SwPreferences.this.zoomSldRange.getY();
                    f = Float.valueOf(SwPreferences.this.sliderZoomToText.getText()).floatValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                f = f2;
            }
            if (soCamera != null && soCamera instanceof SoPerspectiveCamera) {
                if (this.type == 0) {
                    f = f < 0.01f ? 0.01f : (f > 178.99f ? 178.99f : f);
                } else {
                    float f3 = f < 1.01f ? 1.01f : (f = f > 179.99f ? 179.99f : f);
                }
            }
            if (this.type == 0) {
                SwPreferences.this.zoomSldRange.setValue(f, SwPreferences.this.zoomSldRange.getY());
            } else {
                SwPreferences.this.zoomSldRange.setValue(SwPreferences.this.zoomSldRange.getX(), f);
            }
            if (this.type == 0) {
                SwPreferences.this.sliderZoomText.setText(Float.toString(f));
                SwPreferences.this.sliderZoomText.setCaretPosition(0);
            } else {
                SwPreferences.this.sliderZoomToText.setText(Float.toString(f));
                SwPreferences.this.sliderZoomToText.setCaretPosition(0);
            }
            SwPreferences.this.updateLocalComponents();
        }
    }

    class ZoomField
    implements ActionListener {
        ZoomField() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            float f;
            float f2 = SwPreferences.this.scene.getCameraZoom();
            try {
                f = Float.valueOf(SwPreferences.this.zoomText.getText()).floatValue();
                if (f <= 0.0f) {
                    f = f2;
                } else {
                    SoCamera soCamera = SwPreferences.this.scene.getCamera();
                    if (soCamera != null && soCamera instanceof SoPerspectiveCamera) {
                        float f3 = f < 0.01f ? 0.01f : (f = f > 179.99f ? 179.99f : f);
                    }
                    if (f < SwPreferences.this.zoomSldRange.getX()) {
                        SwPreferences.this.zoomSldRange.setValue(f, SwPreferences.this.zoomSldRange.getY());
                    } else if (f > SwPreferences.this.zoomSldRange.getY()) {
                        SwPreferences.this.zoomSldRange.setValue(SwPreferences.this.zoomSldRange.getY(), f);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                f = f2;
            }
            SwPreferences.this.scene.setCameraZoom(f);
            SwPreferences.this.updateLocalComponents();
            SwPreferences.this.zoomText.setCaretPosition(0);
        }
    }

    class SeekDistField
    implements ActionListener {
        SeekDistField() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            float f;
            float f2 = SwPreferences.this.scene.getSeekDistance();
            try {
                f = Float.valueOf(SwPreferences.this.seekDistText.getText()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                f = f2;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            SwPreferences.this.scene.setSeekDistance(f);
            SwPreferences.this.updateLocalComponents();
            SwPreferences.this.seekDistText.setCaretPosition(0);
        }
    }

    class SeekPrefSheetField
    implements ActionListener {
        SeekPrefSheetField() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            float f;
            float f2 = SwPreferences.this.scene.getSeekTime();
            try {
                f = Float.valueOf(SwPreferences.this.seekAnimText.getText()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                f = f2;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            SwPreferences.this.scene.setSeekTime(f);
            SwPreferences.this.seekAnimText.setText(Float.toString(f));
            SwPreferences.this.seekAnimText.setCaretPosition(0);
        }
    }

    class StereoPrefSheetMode
    implements ItemListener {
        StereoPrefSheetMode() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = SwPreferences.this.chStereoMode.getSelectedIndex();
            try {
                SwPreferences.this.scene.setStereoMode(n);
                SwPreferences.this.stereoViewing.setEnabled(n != 0);
                SwPreferences.this.scene.redraw();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                String string = SwPanel.resources.getString("PS_STEREO_NOT_AVAILABLE");
                JOptionPane.showMessageDialog(new Frame(), string, " ", 2);
            }
            SwPreferences.this.updateLocalComponents();
        }
    }

    class StereoPrefSheetSwitch
    implements ItemListener {
        StereoPrefSheetSwitch() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            SwPreferences.this.scene.setStereoSwitch(SwPreferences.this.cbStereoSwitch.getState());
            SwPreferences.this.scene.redraw();
            SwPreferences.this.updateLocalComponents();
        }
    }

    class ClipPrefSheetToggle
    implements ItemListener {
        ClipPrefSheetToggle() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            SwPreferences.this.scene.setAutoClipping(SwPreferences.this.cbClipPlanes.getState());
            SwPreferences.this.clipPlane.setEnabled(!SwPreferences.this.scene.isAutoClipping());
            SwPreferences.this.nearWheel.setEnabled(!SwPreferences.this.scene.isAutoClipping());
            SwPreferences.this.farWheel.setEnabled(!SwPreferences.this.scene.isAutoClipping());
            SwPreferences.this.updateLocalComponents();
        }
    }

    class SeekDistPrefSheetToggle
    implements ItemListener {
        int type;

        public SeekDistPrefSheetToggle(int n) {
            this.type = n;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            switch (this.type) {
                case 0: {
                    SwPreferences.this.scene.setSeekDistAsPercentage(SwPreferences.this.cbPercent.getState());
                    break;
                }
                case 1: {
                    SwPreferences.this.scene.setSeekDistAsPercentage(!SwPreferences.this.cbAbsolute.getState());
                }
            }
        }
    }

    class SeekPrefSheetToggle
    implements ItemListener {
        int type;

        public SeekPrefSheetToggle(int n) {
            this.type = n;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            switch (this.type) {
                case 0: {
                    SwPreferences.this.scene.setDetailSeek(SwPreferences.this.cbPoint.getState());
                    break;
                }
                case 1: {
                    SwPreferences.this.scene.setDetailSeek(!SwPreferences.this.cbObject.getState());
                }
            }
        }
    }

    class StereoWheel
    extends ListenWheel {
        StereoWheel() {
        }

        @Override
        public void wheelDragged(SwWheelEvent swWheelEvent) {
            if (!this.drag) {
                SwPreferences.this.scene.interactiveCountInc();
                this.drag = true;
            }
            SwPreferences.this.scene.setStereoOffset((float)((double)SwPreferences.this.scene.getStereoOffset() * Math.pow(80.0, (double)(SwPreferences.this.rotWheel.getValue() - SwPreferences.this.stereoWheelVal) / 360.0)));
            SwPreferences.this.stereoWheelVal = SwPreferences.this.rotWheel.getValue();
            SwPreferences.this.stereoText.setText(Float.toString(SwPreferences.this.scene.getStereoOffset()));
            SwPreferences.this.stereoText.setCaretPosition(0);
            SwPreferences.this.scene.scheduleRedraw();
        }

        @Override
        public void wheelChanged(SwWheelEvent swWheelEvent) {
            SwPreferences.this.scene.interactiveCountDec();
            this.drag = false;
        }
    }

    class ClipFarWheel
    extends ListenWheel {
        ClipFarWheel() {
        }

        @Override
        public void wheelDragged(SwWheelEvent swWheelEvent) {
            SoCamera soCamera = SwPreferences.this.scene.getCamera();
            if (soCamera == null) {
                return;
            }
            if (!this.drag) {
                SwPreferences.this.scene.interactiveCountInc();
                this.drag = true;
            }
            float f = soCamera.farDistance.getValue();
            f = (float)((double)f * Math.pow(80.0, (double)(SwPreferences.this.farWheel.getValue() - SwPreferences.this.clipFarWheelVal) / 360.0));
            SwPreferences.this.clipFarWheelVal = SwPreferences.this.farWheel.getValue();
            soCamera.farDistance.setValue(f);
            SwPreferences.this.farText.setText(Float.toString(f));
            SwPreferences.this.farText.setCaretPosition(0);
        }

        @Override
        public void wheelChanged(SwWheelEvent swWheelEvent) {
            SwPreferences.this.scene.interactiveCountDec();
            this.drag = false;
        }
    }

    class ClipNearWheel
    extends ListenWheel {
        ClipNearWheel() {
        }

        @Override
        public void wheelDragged(SwWheelEvent swWheelEvent) {
            SoCamera soCamera = SwPreferences.this.scene.getCamera();
            if (soCamera == null) {
                return;
            }
            if (!this.drag) {
                SwPreferences.this.scene.interactiveCountInc();
                this.drag = true;
            }
            float f = soCamera.nearDistance.getValue();
            f = (float)((double)f * Math.pow(80.0, (double)(SwPreferences.this.nearWheel.getValue() - SwPreferences.this.clipNearWheelVal) / 360.0));
            SwPreferences.this.clipNearWheelVal = SwPreferences.this.nearWheel.getValue();
            soCamera.nearDistance.setValue(f);
            SwPreferences.this.nearText.setText(Float.toString(f));
            SwPreferences.this.nearText.setCaretPosition(0);
        }

        @Override
        public void wheelChanged(SwWheelEvent swWheelEvent) {
            SwPreferences.this.scene.interactiveCountDec();
            this.drag = false;
        }
    }

    class ZoomWheel
    extends ListenWheel {
        ZoomWheel() {
        }

        @Override
        public void wheelDragged(SwWheelEvent swWheelEvent) {
            if (!this.drag) {
                SwPreferences.this.scene.interactiveCountInc();
                this.drag = true;
            }
            float f = (SwPreferences.this.zoomWheel.getValue() - SwPreferences.this.zoomWheel.getLowerBound()) / (SwPreferences.this.zoomWheel.getUpperBound() - SwPreferences.this.zoomWheel.getLowerBound());
            f *= f;
            float f2 = SwPreferences.this.zoomSldRange.getX() + f * (SwPreferences.this.zoomSldRange.getY() - SwPreferences.this.zoomSldRange.getX());
            SwPreferences.this.scene.setCameraZoom(f2);
            SwPreferences.this.zoomText.setText(Float.toString(SwPreferences.this.scene.getCameraZoom()));
            SwPreferences.this.zoomText.setCaretPosition(0);
        }

        @Override
        public void wheelChanged(SwWheelEvent swWheelEvent) {
            float f = (SwPreferences.this.zoomWheel.getValue() - SwPreferences.this.zoomWheel.getLowerBound()) / (SwPreferences.this.zoomWheel.getUpperBound() - SwPreferences.this.zoomWheel.getLowerBound());
            f *= f;
            float f2 = SwPreferences.this.zoomSldRange.getX() + f * (SwPreferences.this.zoomSldRange.getY() - SwPreferences.this.zoomSldRange.getX());
            SwPreferences.this.scene.setCameraZoom(f2);
            SwPreferences.this.zoomText.setText(Float.toString(SwPreferences.this.scene.getCameraZoom()));
            SwPreferences.this.zoomText.setCaretPosition(0);
            if (this.drag) {
                SwPreferences.this.scene.interactiveCountDec();
                this.drag = false;
            }
        }
    }

    class SeekDistWheel
    extends ListenWheel {
        SeekDistWheel() {
        }

        @Override
        public void wheelChanged(SwWheelEvent swWheelEvent) {
            SwPreferences.this.scene.setSeekDistance((float)Math.pow(80.0, (double)SwPreferences.this.seekWheel.getValue() / 360.0));
            SwPreferences.this.seekDistText.setText(Float.toString(SwPreferences.this.scene.getSeekDistance()));
            SwPreferences.this.seekDistText.setCaretPosition(0);
        }

        @Override
        public void wheelDragged(SwWheelEvent swWheelEvent) {
            SwPreferences.this.scene.setSeekDistance((float)Math.pow(80.0, (double)SwPreferences.this.seekWheel.getValue() / 360.0));
            SwPreferences.this.seekDistText.setText(Float.toString(SwPreferences.this.scene.getSeekDistance()));
            SwPreferences.this.seekDistText.setCaretPosition(0);
        }
    }

    class ListenWheel
    implements SwWheelListener {
        boolean drag = false;

        ListenWheel() {
        }

        @Override
        public void wheelChanged(SwWheelEvent swWheelEvent) {
        }

        @Override
        public void wheelDragged(SwWheelEvent swWheelEvent) {
        }
    }
}

