/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.SoSceneManager;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.awt.SoGLRenderFromPBuffer;
import com.openinventor.inventor.awt.SwDrawingArea;
import com.openinventor.inventor.awt.event.SwKeyboard;
import com.openinventor.inventor.awt.event.SwMouse;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.misc.callbacks.SoSelectionClassCB;
import com.openinventor.inventor.mpeg.SoMPEGRenderer;
import com.openinventor.inventor.nodes.SoLocateHighlight;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSelection;
import com.openinventor.scaleviz.SoScaleViz;
import com.openinventor.scaleviz.awt.SoComponentBase;
import com.openinventor.scaleviz.awt.SoFrameGrabber;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import sun.awt.EmbeddedFrame;
import sun.awt.SunToolkit;

@Deprecated
public class SwRenderArea
extends SwDrawingArea {
    private static final String helpDialogTitle = "Help Card Error Dialog";
    private static final String helpCardError = "Inventor Help Cards not installed.";
    private static final String helpPrgError = "help viewer not installed.";
    private boolean firstEvent = true;
    boolean autoRedraw = true;
    private boolean clearFirst = true;
    SoSceneManager sceneMgr;
    protected SoComponentBase m_componentBase = null;
    SoSelection selection;
    private SelectionChangeCB selectionChangeCB;
    EventQueue sysQueue;
    Component motherwin;
    SwMouse mouse;
    SwKeyboard keyboard;

    public SwRenderArea() {
        this(true, true);
    }

    public SwRenderArea(boolean bl, boolean bl2) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwRenderArea.<init>");
        }
        this.m_componentBase = new SoComponentBase(this.m_areaPeer);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                SwRenderArea.this.screenLocationChanged();
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = SwRenderArea.this.getSize();
                SwRenderArea.this.m_componentBase.size.setValue(dimension.width, dimension.height);
                SwRenderArea.this.screenLocationChanged();
                if (SwRenderArea.this.m_componentBase.isRemoteClientConnected()) {
                    SwRenderArea.this.sceneMgr.scheduleForcedRedraw();
                }
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                SwRenderArea.this.m_componentBase.visible.setValue(SwRenderArea.this.isShowing());
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
                SwRenderArea.this.screenLocationChanged();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SwRenderArea.this.m_componentBase.focus.setValue(true);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SwRenderArea.this.m_componentBase.focus.setValue(false);
            }
        });
        this.sceneMgr = this.m_componentBase.getSceneManager();
        this.sysQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (bl) {
            this.addMouse(new SwMouse());
        }
        if (bl2) {
            this.addKeyboard(new SwKeyboard());
        }
        this.addComponentListener(new SizeListener());
        this.addHierarchyListener(new VisibilityListener());
        this.addMouseListener(new Mouse());
        this.setSize(400, 400);
    }

    @Override
    public void addNotify() {
        boolean bl = false;
        Applet applet = null;
        this.motherwin = this.getParent();
        if (this.motherwin instanceof Applet) {
            applet = (Applet)this.motherwin;
        }
        if (this.motherwin instanceof EmbeddedFrame) {
            bl = true;
        }
        while (this.motherwin.getParent() != null) {
            this.motherwin = this.motherwin.getParent();
            if (this.motherwin instanceof Applet) {
                applet = (Applet)this.motherwin;
            }
            if (!(this.motherwin instanceof EmbeddedFrame)) continue;
            bl = true;
        }
        if (bl) {
            this.motherwin = null;
        } else {
            applet = null;
        }
        if (this.selection != null) {
            this.redrawOnSelectionChange(this.selection);
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        if (super.isDisplayable()) {
            super.removeNotify();
        }
        this.motherwin = null;
        this.sceneMgr.setRenderTask(null);
        if (this.selection != null) {
            this.selection.removeChangeCallback(this.selectionChangeCB, this);
            this.selectionChangeCB.dispose();
            this.selectionChangeCB = null;
        }
    }

    @Override
    void firstPaint() {
        super.firstPaint();
        if (this.getGLGraphicsConfig() != null) {
            this.getAreaPeer().glBindContext();
            if (this.getGLGraphicsConfig().getDepthBits() > 0) {
                this.getAreaPeer().glEnable(2929);
            }
            this.sceneMgr.reinitialize();
            this.sceneMgr.setRGBMode(!this.getGLGraphicsConfig().getColorIndex());
            SoGLRenderAction soGLRenderAction = this.sceneMgr.getGLRenderAction();
            soGLRenderAction.setCacheContext(this.getAreaPeer().getCacheContextId());
            soGLRenderAction.setRenderingIsRemote(!this.getAreaPeer().glIsDirect());
            this.getAreaPeer().glUnbindContext();
        }
        this.sceneMgr.setRenderTask(new RenderTask());
    }

    protected void glFullSceneAntialiasing() {
        if (this.isFullSceneAntialiasingEnabled()) {
            this.m_areaPeer.glEnable(32925);
        } else {
            this.m_areaPeer.glDisable(32925);
        }
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
        AWTEvent aWTEvent2 = this.sysQueue.peekEvent();
        if (aWTEvent2 != null && aWTEvent2.getID() == aWTEvent.getID() && aWTEvent2.getSource() == this) {
            return;
        }
        if (this.isProcessCommonEvents() || this.isIvTuneLauncher(aWTEvent)) {
            if (aWTEvent instanceof KeyEvent) {
                this.processKeyboard((KeyEvent)aWTEvent);
            } else if (aWTEvent instanceof MouseEvent) {
                this.processMouseFocus((MouseEvent)aWTEvent);
            }
        }
    }

    private boolean isIvTuneLauncher(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof KeyEvent)) {
            return false;
        }
        if (SoPreferences.getBoolean("OIV_NO_IVTUNE", false)) {
            return false;
        }
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        String string = SoPreferences.getValue("OIV_IVTUNE_SHORTCUT", "0xFFC9");
        int n = string.startsWith("0x") ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string);
        int n2 = SoKeyboardEvent.getKeySym(keyEvent.getKeyCode()).getValue();
        return n2 == n && keyEvent.getModifiersEx() == 64;
    }

    @Override
    protected void doPaint() {
        this.redraw();
    }

    protected boolean isProcessCommonEvents() {
        return !this.isViewing();
    }

    boolean isViewing() {
        return false;
    }

    void processKeyboard(KeyEvent keyEvent) {
        if (this.keyboard != null) {
            if (keyEvent.getID() == 401) {
                this.keyboard.keyPressed(keyEvent);
            } else if (keyEvent.getID() == 402) {
                this.keyboard.keyReleased(keyEvent);
            }
        }
    }

    void processMouseFocus(MouseEvent mouseEvent) {
        if (this.mouse != null) {
            if (mouseEvent.getID() == 506) {
                this.mouse.mouseDragged(mouseEvent);
            } else if (mouseEvent.getID() == 503) {
                this.mouse.mouseMoved(mouseEvent);
            } else if (mouseEvent.getID() == 501) {
                this.mouse.mousePressed(mouseEvent);
            } else if (mouseEvent.getID() == 502) {
                this.mouse.mouseReleased(mouseEvent);
            } else if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 2) {
                this.mouse.mouseDoubleClicked(mouseEvent);
            } else if (mouseEvent.getID() == 507) {
                this.mouse.mouseWheelMoved(mouseEvent);
            }
        }
    }

    public void processSoEvent(SoEvent soEvent) {
        boolean bl;
        if (this.haveContext() && !(bl = false)) {
            boolean bl2 = this.sceneMgr.processEvent(soEvent);
            if (DEBUG) {
                System.err.println("DEBUG: JAVA MTHD->SwRenderArea processSoEvent : sceneMgr processEvent : " + bl2);
            }
            if (this.firstEvent) {
                this.getAreaPeer().updateWindowElement(this.sceneMgr.getHandleEventAction(), this.getGLRenderAction());
                this.firstEvent = false;
            }
        }
    }

    void addMouse(SwMouse swMouse) {
        if (swMouse != null) {
            this.enableEvents(16L);
            this.enableEvents(32L);
            this.enableEvents(131072L);
        }
        this.mouse = swMouse;
    }

    void removeMouse() {
        this.mouse = null;
    }

    void addKeyboard(SwKeyboard swKeyboard) {
        if (swKeyboard != null) {
            this.enableEvents(8L);
        }
        this.keyboard = swKeyboard;
    }

    void removeKeyboard() {
        this.keyboard = null;
    }

    public void setSize(SbVec2s sbVec2s) {
        super.setSize(new Dimension(sbVec2s.getX(), sbVec2s.getY()));
    }

    public void setSceneGraph(SoNode soNode) {
        if (DEBUG) {
            System.err.println("DEBUG: JAVA MTHD->SwRenderArea.setSceneGraph");
        }
        this.sceneMgr.deactivate();
        this.sceneMgr.setSceneGraph(soNode);
        if (this.isVisible() && this.autoRedraw) {
            this.sceneMgr.activate();
            this.sceneMgr.scheduleRedraw();
        }
    }

    public SoNode getSceneGraph() {
        return this.sceneMgr.getSceneGraph();
    }

    public void setBackgroundColor(SbColor sbColor) {
        this.sceneMgr.setBackgroundColor(sbColor);
    }

    public SbColor getBackgroundColor() {
        return this.sceneMgr.getBackgroundColor();
    }

    public void setBackgroundIndex(int n) {
        this.sceneMgr.setBackgroundIndex(n);
    }

    public int getBackgroundIndex() {
        return this.sceneMgr.getBackgroundIndex();
    }

    public void setViewportRegion(SbViewportRegion sbViewportRegion) {
        this.sceneMgr.getGLRenderAction().setViewportRegion(sbViewportRegion);
    }

    public SbViewportRegion getViewportRegion() {
        return this.sceneMgr.getGLRenderAction().getViewportRegion();
    }

    public void setTransparencyType(SoGLRenderAction.TransparencyTypes transparencyTypes) {
        this.sceneMgr.getGLRenderAction().setTransparencyType(transparencyTypes);
        this.sceneMgr.scheduleRedraw();
    }

    public int getSortedTrianglesSortFrequency() {
        return this.sceneMgr.getGLRenderAction().getSortedTrianglesSortFrequency();
    }

    public int getSortedTrianglesNumCaches() {
        return this.sceneMgr.getGLRenderAction().getSortedTrianglesNumCaches();
    }

    public SoGLRenderAction.TransparencyTypes getTransparencyType() {
        return this.sceneMgr.getGLRenderAction().getTransparencyType();
    }

    public void setAntialiasing(boolean bl, int n) {
        SoGLRenderAction soGLRenderAction = this.getGLRenderAction();
        if (bl == soGLRenderAction.isSmoothing() && n == soGLRenderAction.getNumPasses()) {
            return;
        }
        boolean bl2 = n > 1 && soGLRenderAction.getNumPasses() == 1 || n == 1 && soGLRenderAction.getNumPasses() > 1;
        this.sceneMgr.scheduleRedraw();
        this.sceneMgr.setAntialiasing(bl, n);
    }

    public void getAntialiasing(boolean[] blArray, int[] nArray) {
        blArray[0] = this.sceneMgr.getGLRenderAction().isSmoothing();
        nArray[0] = this.sceneMgr.getGLRenderAction().getNumPasses();
    }

    public void setClearBeforeRender(boolean bl) {
        this.clearFirst = bl;
    }

    public boolean isClearBeforeRender() {
        return this.clearFirst;
    }

    public void setAutoRedraw(boolean bl) {
        if (bl == this.autoRedraw) {
            return;
        }
        this.autoRedraw = bl;
        if (this.autoRedraw) {
            if (this.isVisible()) {
                this.activate();
            }
        } else {
            this.deactivate();
        }
    }

    public boolean isAutoRedraw() {
        return this.autoRedraw;
    }

    public void setRedrawPriority(long l) {
        this.sceneMgr.setRedrawPriority((int)l);
    }

    public long getRedrawPriority() {
        return this.sceneMgr.getRedrawPriority();
    }

    public static long getDefaultRedrawPriority() {
        return SoSceneManager.getDefaultRedrawPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redraw() {
        boolean bl;
        if (DEBUG) {
            System.err.println("DEBUG: JAVA MTHD->SwRenderArea.redraw");
        }
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException();
        }
        boolean bl2 = bl = !SunToolkit.isAWTLockHeldByCurrentThread();
        assert (!bl);
        if (this.haveContext()) {
            if (!this.isShowing() || !this.isDisplayable()) {
                return;
            }
            if (bl) {
                SunToolkit.awtLock();
            }
            try {
                this.getAreaPeer().glBindContext();
                this.m_componentBase.preRedraw();
                if (this.m_componentBase.isLocalRedraw()) {
                    SoFrameGrabber soFrameGrabber = this.m_componentBase.getFrameGrabber();
                    if (soFrameGrabber != null) {
                        Dimension dimension = this.getSize();
                        SbVec2s sbVec2s = new SbVec2s((short)dimension.getWidth(), (short)dimension.getHeight());
                        soFrameGrabber.setViewport(sbVec2s.array);
                        soFrameGrabber.begin();
                    }
                    this.glFullSceneAntialiasing();
                    this.actualRedraw();
                    if (soFrameGrabber != null) {
                        soFrameGrabber.end();
                    }
                    this.getAreaPeer().glFlush();
                    if (this.isDoubleBuffer() && SoScaleViz.isComposing() == SoScaleViz.CompositingTypes.NONE && this.m_componentBase.isRemoteMustDraw()) {
                        this.getAreaPeer().glSwapBuffers();
                    }
                }
                if (SoScaleViz.isRunningCluster() && this.m_componentBase.getSynchronize()) {
                    if (!SoScaleViz.isLocalRedraw()) {
                        this.actualRedraw();
                    }
                    this.m_componentBase.notifyRedraw();
                }
                this.m_componentBase.postRedraw();
                this.getAreaPeer().glUnbindContext();
            }
            finally {
                if (bl) {
                    SunToolkit.awtUnlock();
                }
            }
        }
    }

    public void redrawOverlay() {
    }

    public void scheduleRedraw() {
        if (DEBUG) {
            System.err.println("DEBUG: JAVA MTHD->SwRenderArea.scheduleRedraw");
        }
        if (this.haveContext()) {
            if (this.isAutoRedraw()) {
                this.sceneMgr.scheduleRedraw();
            } else {
                this.redraw();
            }
        }
    }

    public void redrawOnSelectionChange(SoSelection soSelection) {
        if (this.selection != null && this.selectionChangeCB != null) {
            this.selection.removeChangeCallback(this.selectionChangeCB, this);
            this.selectionChangeCB.dispose();
        }
        this.selection = soSelection;
        if (this.selection != null) {
            this.selectionChangeCB = new SelectionChangeCB();
            this.selection.addChangeCallback(this.selectionChangeCB, this);
        }
    }

    public SoSceneManager getSceneManager() {
        return this.sceneMgr;
    }

    public void setGLRenderAction(SoGLRenderAction soGLRenderAction) {
        this.sceneMgr.setGLRenderAction(soGLRenderAction);
    }

    public SoGLRenderAction getGLRenderAction() {
        return this.sceneMgr.getGLRenderAction();
    }

    public void setInvalidateCacheMode(SoGLRenderAction.InvalidateCacheModes invalidateCacheModes) {
        this.sceneMgr.getGLRenderAction().setInvalidateCacheMode(invalidateCacheModes);
    }

    public SoGLRenderAction.InvalidateCacheModes getInvalidateCacheMode() {
        return this.sceneMgr.getGLRenderAction().getInvalidateCacheMode();
    }

    public void setMPEGRecorder(SoMPEGRenderer soMPEGRenderer) {
        this.m_componentBase.setMPEGRecorder(soMPEGRenderer);
    }

    public SoMPEGRenderer getMPEGRecorder() {
        return this.m_componentBase.getMPEGRecorder();
    }

    protected void actualRedraw() {
        if (this.haveContext()) {
            if (this.m_componentBase.isRemoteClientConnected()) {
                if (this.getGLGraphicsConfig() != null) {
                    this.m_componentBase.applyVncColorMask();
                } else {
                    Graphics graphics = this.getGraphics();
                    if (graphics != null) {
                        graphics.setColor(this.m_componentBase.vncColorMask.getValue().toAWTColor());
                        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                }
            } else if (this.getGLGraphicsConfig() != null) {
                this.sceneMgr.render(this.clearFirst);
            }
        }
    }

    protected void sizeChanged(SbVec2s sbVec2s) {
        if (DEBUG) {
            System.err.println("DEBUG: JAVA MTHD->SwRenderArea.sizeChanged");
        }
        this.sceneMgr.setWindowSize(sbVec2s);
    }

    protected void sizeChanged(Dimension dimension) {
        this.sizeChanged(new SbVec2s((short)dimension.width, (short)dimension.height));
    }

    private void screenLocationChanged() {
        try {
            Point point = this.getLocationOnScreen();
            this.m_componentBase.posChanged(point);
            if (SoScaleViz.isConnected() && SoScaleViz.isUsingVnc()) {
                this.sceneMgr.scheduleRedraw();
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    void windowChanged(long l) {
        if (DEBUG) {
            System.err.println("DEBUG: JAVA MTHD->SwRenderArea.windowChanged");
        }
        if (l != 0L) {
            this.sceneMgr.reinitialize();
        }
    }

    void activate() {
        if (!this.autoRedraw) {
            return;
        }
        this.sceneMgr.activate();
    }

    void deactivate() {
        this.sceneMgr.deactivate();
    }

    void clearWindowElement(SoAction soAction) {
        if (DEBUG) {
            System.err.println("DEBUG: JAVA MTHD->SwRenderArea.clearWindowElement");
        }
        if (this.haveContext()) {
            this.getAreaPeer().clearWindowElement(soAction);
        }
    }

    void updateWindowElement(SoAction soAction, SoGLRenderAction soGLRenderAction) {
        if (DEBUG) {
            System.err.println("DEBUG: JAVA MTHD->SwRenderArea.updateWindowElement");
        }
        if (this.haveContext()) {
            this.getAreaPeer().updateWindowElement(soAction, soGLRenderAction);
        }
    }

    public void setFloatingColorBuffer(boolean bl, FloatColorBufferSize floatColorBufferSize) {
        this.sceneMgr.setFloatingColorBuffer(bl, floatColorBufferSize.ordinal());
    }

    public FloatColorBufferSize getFloatingPointRenderingPrecision() {
        int n = this.sceneMgr.getFloatingPointRenderingPrecision();
        for (FloatColorBufferSize floatColorBufferSize : FloatColorBufferSize.values()) {
            if (floatColorBufferSize.ordinal() != n) continue;
            return floatColorBufferSize;
        }
        return null;
    }

    public static boolean isFloatingColorBufferSupported() {
        return SoGLRenderFromPBuffer.isFloatingColorBufferSupported();
    }

    public boolean isInteractive() {
        return false;
    }

    public void setOverlayColorMap(int n, int n2, SbColor[] sbColorArray) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (DEBUG) {
            System.err.println("DEBUG: JAVA MTHD->SwRenderArea.writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        if (DEBUG) {
            System.err.println("DEBUG: JAVA MTHD->SwRenderArea.readObject");
        }
    }

    class SelectionChangeCB
    extends SoSelectionClassCB {
        SelectionChangeCB() {
        }

        @Override
        public void invoke(SoSelection soSelection) {
            ((SwRenderArea)this.userData).scheduleRedraw();
        }
    }

    class RenderTask
    implements Runnable {
        RenderTask() {
        }

        @Override
        public void run() {
            SwRenderArea.this.redraw();
        }
    }

    class VisibilityListener
    implements HierarchyListener {
        VisibilityListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                if (SwRenderArea.this.isShowing()) {
                    SwRenderArea.this.activate();
                    SwRenderArea.this.repaint(0L);
                } else {
                    SwRenderArea.this.deactivate();
                }
            }
        }
    }

    class SizeListener
    extends ComponentAdapter {
        SizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            SwRenderArea swRenderArea = (SwRenderArea)componentEvent.getSource();
            swRenderArea.sizeChanged(new SbVec2s((short)SwRenderArea.this.getWidth(), (short)SwRenderArea.this.getHeight()));
        }
    }

    class Mouse
    extends MouseAdapter {
        Mouse() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            SwRenderArea swRenderArea = (SwRenderArea)mouseEvent.getSource();
            if (swRenderArea.motherwin != null && ((Window)swRenderArea.motherwin).getFocusOwner() != null) {
                swRenderArea.requestFocus();
            }
            swRenderArea.updateWindowElement(swRenderArea.sceneMgr.getHandleEventAction(), swRenderArea.getGLRenderAction());
            swRenderArea.updateWindowElement(swRenderArea.sceneMgr.getGLRenderAction(), swRenderArea.getGLRenderAction());
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            SwRenderArea swRenderArea = (SwRenderArea)mouseEvent.getSource();
            if (!swRenderArea.hasFocus()) {
                swRenderArea.requestFocus();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            SoGLRenderAction soGLRenderAction;
            SwRenderArea swRenderArea = (SwRenderArea)mouseEvent.getSource();
            if (swRenderArea.hasFocus()) {
                swRenderArea.transferFocus();
            }
            if ((soGLRenderAction = swRenderArea.sceneMgr.getGLRenderAction()) != null) {
                SoLocateHighlight.turnOffCurrentHighlight(soGLRenderAction);
            }
            SwRenderArea.this.clearWindowElement(swRenderArea.sceneMgr.getHandleEventAction());
            SwRenderArea.this.clearWindowElement(swRenderArea.sceneMgr.getGLRenderAction());
        }
    }

    public static enum FloatColorBufferSize {
        FLOAT_16_COLOR_BUFFER,
        FLOAT_32_COLOR_BUFFER;

    }
}

