/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.awt.SwIcons;
import com.openinventor.inventor.awt.SwImageButton;
import com.openinventor.inventor.awt.SwScene;
import com.openinventor.inventor.awt.SwViewer;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;

@Deprecated
public class SwSceneViewer
extends SwViewer {
    public static final int EXAMINER = 0;
    public static final int PLANE = 1;
    public static final int WALK = 2;
    public static final int FLY = 3;
    static final int NUM_AREA = 2;
    public static final int CAM_PUSH = 0;
    public static final int CAM_PUSH_NUM = 1;
    public static final int X_PUSH = 0;
    public static final int Y_PUSH = 1;
    public static final int Z_PUSH = 2;
    public static final int XYZ_PUSH_NUM = 3;
    private SwImageButton[] camButtonList;
    private SwImageButton[] xyzButtonList;
    private int currentType = -1;

    public SwSceneViewer(SwScene swScene) {
        this("Simple Viewer", swScene);
    }

    public SwSceneViewer(String string, SwScene swScene) {
        super(255L, 0);
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwSimpleViewer.SwSimpleViewer");
        }
        this.setName(string);
        this.camButtonList = new SwImageButton[1];
        this.camButtonList[0] = new SwImageButton(SwIcons.PERSP_BITS, 24, 24);
        this.camButtonList[0].setState(false);
        this.camButtonList[0].addMouseListener(new ListenCamButtons(this));
        this.xyzButtonList = new SwImageButton[3];
        this.xyzButtonList[0] = new SwImageButton(SwIcons.X_BITS, 24, 24);
        this.xyzButtonList[0].setState(false);
        this.xyzButtonList[0].addMouseListener(new ListenXYZButtons(this, 0));
        this.xyzButtonList[1] = new SwImageButton(SwIcons.Y_BITS, 24, 24);
        this.xyzButtonList[1].setState(false);
        this.xyzButtonList[1].addMouseListener(new ListenXYZButtons(this, 1));
        this.xyzButtonList[2] = new SwImageButton(SwIcons.Z_BITS, 24, 24);
        this.xyzButtonList[2].setState(false);
        this.xyzButtonList[2].addMouseListener(new ListenXYZButtons(this, 2));
        this.setScene(swScene);
    }

    @Override
    public void update(Observable observable, Object object) throws IllegalArgumentException {
        super.update(observable, object);
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwSimpleViewer.update");
        }
        if (this.scene.isCameraUpdated()) {
            if (this.scene.getCamera() instanceof SoOrthographicCamera) {
                if (this.camButtonList[0] != null) {
                    this.camButtonList[0].setImage(SwIcons.ORTHO_BITS, 24, 24);
                }
            } else if (this.camButtonList[0] != null) {
                this.camButtonList[0].setImage(SwIcons.PERSP_BITS, 24, 24);
            }
        }
        if (this.currentType == this.scene.getType()) {
            return;
        }
        if (this.helpFrame != null) {
            this.helpFrame.setVisible(false);
            this.helpFrame = null;
        }
        switch (this.currentType) {
            case 0: {
                this.imageButtonForm.remove(this.camButtonList[0]);
                break;
            }
            case 1: {
                this.imageButtonForm.remove(this.xyzButtonList[0]);
                this.imageButtonForm.remove(this.xyzButtonList[1]);
                this.imageButtonForm.remove(this.xyzButtonList[2]);
                break;
            }
            case 2: {
                break;
            }
        }
        this.currentType = this.scene.getType();
        switch (this.currentType) {
            case 0: {
                this.setBottomWheelString(resources.getString("V_ROTY"));
                this.setLeftWheelString(resources.getString("V_ROTX"));
                this.setRightWheelString(resources.getString("V_DOLLY"));
                this.imageButtonForm.add(this.camButtonList[0]);
                break;
            }
            case 1: {
                this.setBottomWheelString(resources.getString("V_TRANSX"));
                this.setLeftWheelString(resources.getString("V_TRANSY"));
                this.setRightWheelString(resources.getString("V_DOLLY"));
                this.imageButtonForm.add(this.camButtonList[0]);
                this.imageButtonForm.add(this.xyzButtonList[0]);
                this.imageButtonForm.add(this.xyzButtonList[1]);
                this.imageButtonForm.add(this.xyzButtonList[2]);
                break;
            }
            case 2: {
                this.setBottomWheelString(resources.getString("V_ROTATE"));
                this.setLeftWheelString(resources.getString("V_TILT"));
                this.setRightWheelString(resources.getString("V_DOLLY"));
                break;
            }
            case 3: {
                this.setBottomWheelString(resources.getString("V_ROTATE"));
                this.setLeftWheelString(resources.getString("V_TILT"));
                this.setRightWheelString(resources.getString("V_DOLLY"));
            }
        }
        this.validate();
    }

    @Override
    protected void bottomWheelMotion(float f) {
        this.scene.yAxisCameraAction(this.bottomWheelVal - f);
        super.bottomWheelMotion(f);
    }

    @Override
    protected void leftWheelMotion(float f) {
        this.scene.xAxisCameraAction(f - this.leftWheelVal);
        super.leftWheelMotion(f);
    }

    @Override
    protected void rightWheelMotion(float f) {
        this.scene.zAxisCameraAction(f - this.rightWheelVal);
        super.rightWheelMotion(f);
    }

    class ListenXYZButtons
    extends MouseAdapter {
        SwViewer v;
        int type;

        public ListenXYZButtons(SwViewer swViewer, int n) {
            this.v = swViewer;
            this.type = n;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ((SwImageButton)mouseEvent.getSource()).setState(true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ((SwImageButton)mouseEvent.getSource()).setState(false);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            switch (this.type) {
                case 0: {
                    this.v.setPlane(new SbVec3f(1.0f, 0.0f, 0.0f), new SbVec3f(0.0f, 0.0f, -1.0f));
                    break;
                }
                case 1: {
                    this.v.setPlane(new SbVec3f(0.0f, 1.0f, 0.0f), new SbVec3f(1.0f, 0.0f, 0.0f));
                    break;
                }
                case 2: {
                    this.v.setPlane(new SbVec3f(0.0f, 0.0f, 1.0f), new SbVec3f(1.0f, 0.0f, 0.0f));
                }
            }
        }
    }

    class ListenCamButtons
    extends MouseAdapter {
        SwViewer v;

        public ListenCamButtons(SwViewer swViewer) {
            this.v = swViewer;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ((SwImageButton)mouseEvent.getSource()).setState(true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ((SwImageButton)mouseEvent.getSource()).setState(false);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.v.scene.toggleCameraClass();
        }
    }
}

