/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.awt.SwActiveArea;
import com.openinventor.inventor.awt.SwExaminerArea;
import com.openinventor.inventor.awt.SwFlyArea;
import com.openinventor.inventor.awt.SwIcons;
import com.openinventor.inventor.awt.SwImageButton;
import com.openinventor.inventor.awt.SwPanel;
import com.openinventor.inventor.awt.SwPlaneArea;
import com.openinventor.inventor.awt.SwPopupMenu;
import com.openinventor.inventor.awt.SwViewer;
import com.openinventor.inventor.awt.SwWalkArea;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.util.Scene;
import java.awt.Choice;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.Observable;

@Deprecated
public class SwSimpleViewer
extends SwViewer {
    public static final int EXAMINER = 0;
    public static final int PLANE = 1;
    public static final int FLY = 2;
    public static final int WALK = 3;
    static final int NUM_AREA = 4;
    protected int areaType = -1;
    protected SwExaminerArea m_examinerArea = null;
    protected SwPlaneArea m_planeArea = null;
    protected SwFlyArea m_flyArea = null;
    protected SwWalkArea m_walkArea = null;
    public static final int CAM_PUSH = 0;
    public static final int CAM_PUSH_NUM = 1;
    public static final int X_PUSH = 0;
    public static final int Y_PUSH = 1;
    public static final int Z_PUSH = 2;
    public static final int XYZ_PUSH_NUM = 3;
    private static final float WHEEL_HEIGHT_FACTOR = 0.01f;
    private SwImageButton[] camButtonList;
    private SwImageButton[] xyzButtonList;
    Choice typeChoice;
    protected SwPopupMenu popup;

    public SwSimpleViewer() {
        this("Simple Viewer", 0);
    }

    public SwSimpleViewer(String string) {
        this(string, 0);
    }

    public SwSimpleViewer(int n) {
        this("Simple Viewer", n);
    }

    public SwSimpleViewer(String string, int n) {
        super(255L, 0);
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwSimpleViewer.SwSimpleViewer");
        }
        if (n >= 4) {
            throw new IllegalArgumentException("The areaType argument value is not valid.");
        }
        this.setName(string);
        this.camButtonList = new SwImageButton[1];
        this.camButtonList[0] = new SwImageButton(SwIcons.PERSP_BITS, 24, 24);
        this.camButtonList[0].setState(false);
        this.camButtonList[0].addMouseListener(new ListenCamButtons(this));
        this.xyzButtonList = new SwImageButton[3];
        this.xyzButtonList[0] = new SwImageButton(SwIcons.X_BITS, 24, 24);
        this.xyzButtonList[0].setState(false);
        this.xyzButtonList[0].addMouseListener(new ListenXYZButtons(this, 0));
        this.xyzButtonList[1] = new SwImageButton(SwIcons.Y_BITS, 24, 24);
        this.xyzButtonList[1].setState(false);
        this.xyzButtonList[1].addMouseListener(new ListenXYZButtons(this, 1));
        this.xyzButtonList[2] = new SwImageButton(SwIcons.Z_BITS, 24, 24);
        this.xyzButtonList[2].setState(false);
        this.xyzButtonList[2].addMouseListener(new ListenXYZButtons(this, 2));
        this.typeChoice = new Choice();
        this.typeChoice.addItem(resources.getString("V_AREA_EXAM"));
        this.typeChoice.addItem(resources.getString("V_AREA_PLANE"));
        this.typeChoice.addItem(resources.getString("V_AREA_FLY"));
        this.typeChoice.addItem(resources.getString("V_AREA_WALK"));
        this.typeChoice.select(n);
        this.typeChoice.addItemListener(new AreaTypeListener(this));
        this.typeChoice.setVisible(false);
        this.rightPart.add((Component)this.typeChoice, 0);
        this.popup = new SwPopupMenu(this);
        this.add(this.popup);
        this.setAreaType(n);
    }

    @Override
    public void setResources(Locale locale) {
        super.setResources(locale);
        switch (this.areaType) {
            case 0: {
                this.setLeftWheelString(resources.getString("V_ROTX"));
                this.setBottomWheelString(resources.getString("V_ROTY"));
                break;
            }
            case 1: {
                this.setBottomWheelString(resources.getString("V_TRANSX"));
                this.setLeftWheelString(resources.getString("V_TRANSY"));
                break;
            }
            case 3: {
                this.setBottomWheelString(resources.getString("V_ROTATE"));
                this.setLeftWheelString(resources.getString("V_TILT"));
                this.setHeightWheelString(resources.getString("V_HEIGHT"));
                break;
            }
            case 2: {
                this.setBottomWheelString(resources.getString("V_ROTATE"));
                this.setLeftWheelString(resources.getString("V_TILT"));
            }
        }
        int n = this.typeChoice.getSelectedIndex();
        this.typeChoice.removeAll();
        this.typeChoice.addItem(resources.getString("V_AREA_EXAM"));
        this.typeChoice.addItem(resources.getString("V_AREA_PLANE"));
        this.typeChoice.addItem(resources.getString("V_AREA_FLY"));
        this.typeChoice.addItem(resources.getString("V_AREA_WALK"));
        this.typeChoice.select(n);
        this.popup.setResources(locale);
    }

    public void setAreaChoiceVisible(boolean bl) {
        this.typeChoice.setVisible(bl);
    }

    synchronized void setAreaType(int n) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwSimpleViewer.setAreaType");
        }
        if (this.areaType == n || n >= 4 || n < 0) {
            return;
        }
        this.typeChoice.select(n);
        SwActiveArea swActiveArea = (SwActiveArea)this.scene;
        switch (this.areaType) {
            case 0: {
                this.imageButtonForm.remove(this.camButtonList[0]);
                break;
            }
            case 1: {
                this.imageButtonForm.remove(this.xyzButtonList[0]);
                this.imageButtonForm.remove(this.xyzButtonList[1]);
                this.imageButtonForm.remove(this.xyzButtonList[2]);
                this.imageButtonForm.remove(this.camButtonList[0]);
                break;
            }
            case 3: {
                this.leftWheelsPanel.remove(this.heightWheel);
                this.leftWheelsPanel.remove(this.heightWheelLabel);
                break;
            }
        }
        this.areaType = n;
        SwActiveArea swActiveArea2 = null;
        boolean bl = true;
        this.m_examinerArea = null;
        this.m_planeArea = null;
        this.m_flyArea = null;
        this.m_walkArea = null;
        switch (n) {
            case 0: {
                if (this.m_examinerArea == null) {
                    this.m_examinerArea = new SwExaminerArea(0);
                    swActiveArea2 = this.m_examinerArea;
                    bl = false;
                } else {
                    swActiveArea2 = this.m_examinerArea;
                }
                this.setBottomWheelString(resources.getString("V_ROTY"));
                this.setLeftWheelString(resources.getString("V_ROTX"));
                this.setRightWheelString(resources.getString("V_DOLLY"));
                this.imageButtonForm.add(this.camButtonList[0]);
                break;
            }
            case 1: {
                if (this.m_planeArea == null) {
                    this.m_planeArea = new SwPlaneArea(0);
                    swActiveArea2 = this.m_planeArea;
                    bl = false;
                } else {
                    swActiveArea2 = this.m_planeArea;
                }
                this.setBottomWheelString(resources.getString("V_TRANSX"));
                this.setLeftWheelString(resources.getString("V_TRANSY"));
                this.setRightWheelString(resources.getString("V_DOLLY"));
                this.imageButtonForm.add(this.camButtonList[0]);
                this.imageButtonForm.add(this.xyzButtonList[0]);
                this.imageButtonForm.add(this.xyzButtonList[1]);
                this.imageButtonForm.add(this.xyzButtonList[2]);
                break;
            }
            case 3: {
                if (this.m_walkArea == null) {
                    this.m_walkArea = new SwWalkArea(0);
                    swActiveArea2 = this.m_walkArea;
                    bl = false;
                } else {
                    swActiveArea2 = this.m_walkArea;
                }
                this.setBottomWheelString(resources.getString("V_ROTATE"));
                this.setLeftWheelString(resources.getString("V_TILT"));
                this.setRightWheelString(resources.getString("V_DOLLY"));
                this.setHeightWheelString(resources.getString("V_HEIGHT"));
                this.leftWheelsPanel.add((Component)this.heightWheel, 0);
                this.leftWheelsPanel.add((Component)this.heightWheelLabel, 1);
                break;
            }
            case 2: {
                if (this.m_flyArea == null) {
                    this.m_flyArea = new SwFlyArea(0);
                    swActiveArea2 = this.m_flyArea;
                    bl = false;
                } else {
                    swActiveArea2 = this.m_flyArea;
                }
                this.setBottomWheelString(resources.getString("V_ROTATE"));
                this.setLeftWheelString(resources.getString("V_TILT"));
                this.setRightWheelString(resources.getString("V_DOLLY"));
            }
        }
        if (swActiveArea2 != null) {
            if (swActiveArea != null) {
                swActiveArea2.setConfigAs(swActiveArea);
                swActiveArea.setHeadlight(false);
                if (bl) {
                    swActiveArea2.activate();
                }
                swActiveArea.deactivate();
            }
            this.setScene(swActiveArea2);
            swActiveArea2.setVisible(true);
            this.validate();
        }
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwSimpleViewer.setAreaType fin");
        }
    }

    public SwPopupMenu getPopup() {
        return this.popup;
    }

    public SwActiveArea getArea() {
        return (SwActiveArea)this.scene;
    }

    @Override
    public void update(Observable observable, Object object) throws IllegalArgumentException {
        super.update(observable, object);
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwSimpleViewer.update");
        }
        if (this.scene.isCameraUpdated()) {
            if (this.scene.getCamera() instanceof SoOrthographicCamera) {
                if (this.camButtonList[0] != null) {
                    this.camButtonList[0].setImage(SwIcons.ORTHO_BITS, 24, 24);
                }
            } else if (this.camButtonList[0] != null) {
                this.camButtonList[0].setImage(SwIcons.PERSP_BITS, 24, 24);
            }
        }
    }

    @Override
    public void setScene(Scene scene) {
        super.setScene(scene);
        this.popup.setScene(scene);
        if (scene instanceof Component) {
            ((Component)((Object)scene)).addMouseListener(new PopupLaunch());
        }
    }

    @Override
    protected void bottomWheelMotion(float f) {
        this.scene.yAxisCameraAction(this.bottomWheelVal - f);
        super.bottomWheelMotion(f);
    }

    @Override
    protected void leftWheelMotion(float f) {
        this.scene.xAxisCameraAction(f - this.leftWheelVal);
        super.leftWheelMotion(f);
    }

    @Override
    protected void rightWheelMotion(float f) {
        this.scene.zAxisCameraAction(f - this.rightWheelVal);
        super.rightWheelMotion(f);
    }

    @Override
    protected void heightWheelMotion(float f) {
        this.scene.yPlaneCameraAction((this.heightWheelVal - f) * 0.01f);
        super.heightWheelMotion(f);
    }

    class AreaTypeListener
    implements ItemListener {
        SwSimpleViewer v;

        AreaTypeListener(SwSimpleViewer swSimpleViewer2) {
            this.v = swSimpleViewer2;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (SwPanel.DEBUG) {
                System.out.println("DEBUG: JAVA MTHD->SwSimpleViewer$$AreaTypeListener.itemStateChanged");
            }
            Choice choice = (Choice)itemEvent.getSource();
            this.v.setAreaType(choice.getSelectedIndex());
        }
    }

    class ListenXYZButtons
    extends MouseAdapter {
        SwViewer v;
        int type;

        public ListenXYZButtons(SwViewer swViewer, int n) {
            this.v = swViewer;
            this.type = n;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ((SwImageButton)mouseEvent.getSource()).setState(true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ((SwImageButton)mouseEvent.getSource()).setState(false);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            switch (this.type) {
                case 0: {
                    this.v.setPlane(new SbVec3f(1.0f, 0.0f, 0.0f), new SbVec3f(0.0f, 0.0f, -1.0f));
                    break;
                }
                case 1: {
                    this.v.setPlane(new SbVec3f(0.0f, 1.0f, 0.0f), new SbVec3f(1.0f, 0.0f, 0.0f));
                    break;
                }
                case 2: {
                    this.v.setPlane(new SbVec3f(0.0f, 0.0f, 1.0f), new SbVec3f(1.0f, 0.0f, 0.0f));
                }
            }
        }
    }

    class ListenCamButtons
    extends MouseAdapter {
        SwViewer v;

        public ListenCamButtons(SwViewer swViewer) {
            this.v = swViewer;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ((SwImageButton)mouseEvent.getSource()).setState(true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ((SwImageButton)mouseEvent.getSource()).setState(false);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.v.scene.toggleCameraClass();
        }
    }

    class PopupLaunch
    extends MouseAdapter {
        PopupLaunch() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 4) != 0) {
                SwActiveArea swActiveArea = (SwActiveArea)mouseEvent.getSource();
                SwSimpleViewer.this.popup.show(swActiveArea, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

