/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.awt.SwActiveArea;
import com.openinventor.inventor.awt.SwFlyArea;
import com.openinventor.inventor.awt.SwIcons;
import com.openinventor.inventor.awt.SwImageButton;
import com.openinventor.inventor.awt.SwPanel;
import com.openinventor.inventor.awt.SwThumbwheel;
import com.openinventor.inventor.awt.SwWalkArea;
import com.openinventor.inventor.awt.SwWheel;
import com.openinventor.inventor.awt.event.SwWheelEvent;
import com.openinventor.inventor.awt.event.SwWheelListener;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoPerspectiveCamera;
import com.openinventor.util.Scene;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Observable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;

@Deprecated
public class SwViewer
extends SwPanel {
    public static final long BUILD_NONE = 0L;
    public static final long BUILD_DECORATION = 1L;
    public static final long BUILD_POPUP = 2L;
    public static final long BUILD_ALL = 255L;
    protected boolean decorationFlag;
    protected Panel leftTrimForm;
    protected Panel bottomTrimForm;
    protected Panel rightTrimForm;
    protected static final int DECOR_SIZE = 28;
    protected static final int LABEL_SPACE = 3;
    protected static final int LABEL_SEPARATION = 12;
    protected static final int TRIM_MARGIN = 2;
    protected static final float WHEEL_DOLLY_FACTOR = 0.5f;
    protected static final int PICK_PUSH = 0;
    protected static final int VIEW_PUSH = 1;
    protected static final int HELP_PUSH = 2;
    protected static final int HOME_PUSH = 3;
    protected static final int SET_HOME_PUSH = 4;
    protected static final int VIEW_ALL_PUSH = 5;
    protected static final int SEEK_PUSH = 6;
    protected static final int PUSH_NUM = 7;
    protected static final int ZOOM_LABEL = 0;
    protected static final int ZOOM_SLIDER = 1;
    protected static final int ZOOM_FIELD = 2;
    protected static final int ZOOM_RANGE_LAB1 = 3;
    protected static final int ZOOM_RANGE_FIELD1 = 4;
    protected static final int ZOOM_RANGE_LAB2 = 5;
    protected static final int ZOOM_RANGE_FIELD2 = 6;
    protected static final int ZOOM_NUM = 7;
    protected static String stereoErrorTitle = "Stereo Error Dialog";
    protected static String stereoError = "Stereo Viewing can't be set on this machine.";
    protected String bottomWheelStr;
    protected String rightWheelStr;
    protected String leftWheelStr;
    protected String heightWheelStr;
    protected Label bottomWheelLabel;
    protected Label rightWheelLabel;
    protected Label leftWheelLabel;
    protected Label heightWheelLabel;
    protected float bottomWheelVal;
    protected float rightWheelVal;
    protected float leftWheelVal;
    protected float heightWheelVal;
    protected SwThumbwheel leftWheel;
    protected SwThumbwheel bottomWheel;
    protected SwThumbwheel rightWheel;
    protected SwThumbwheel heightWheel;
    protected Panel leftWheelsPanel;
    protected Panel leftTrim;
    protected Panel bottomTrim;
    protected Panel rightTrim;
    protected Panel scenePanel = null;
    protected Panel rightPart;
    protected SwImageButton[] appButtonList;
    private SwImageButton[] buttonList;
    protected static final int ICON_WIDTH = 24;
    protected static final int ICON_HEIGHT = 24;
    protected MemoryImageSource[] bitmaps = new MemoryImageSource[]{SwIcons.PICK, SwIcons.VIEW, SwIcons.HELP, SwIcons.HOME, SwIcons.SET_HOME, SwIcons.SEE_ALL, SwIcons.SEEK_BITS, SwIcons.ORTHO_BITS, SwIcons.PERSP_BITS, SwIcons.X_BITS, SwIcons.Y_BITS, SwIcons.Z_BITS};
    protected JFrame helpFrame = null;
    protected static String[] buttonHelp = new String[]{"HELP_BUTTON_PICK", "HELP_BUTTON_VIEW", "HELP_BUTTON_HELP", "HELP_BUTTON_HOME", "HELP_BUTTON_SET_HOME", "HELP_BUTTON_SEE_ALL", "HELP_BUTTON_SEEK_BITS", "HELP_BUTTON_ORTHO_BITS", "HELP_BUTTON_PERSP_BITS", "HELP_BUTTON_X_BITS", "HELP_BUTTON_Y_BITS", "HELP_BUTTON_Z_BITS"};
    protected static String[] keyUsageHelp = new String[]{"HELP_KEY_ESC", "HELP_KEY_HOME", "HELP_KEY_SEEK"};
    Component[] zooms;
    Label zoomLabel;
    Scrollbar zoomScrollbar;
    TextField zoomText;
    Panel imageButtonForm;
    Panel appButtonForm;
    private SbVec2f zoomSldRange;

    public SwViewer() {
        this(255L, 0);
    }

    public SwViewer(long l, int n) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.SwViewer");
        }
        this.setLayout(new BorderLayout());
        this.setSize(400, 400);
        this.decorationFlag = (l & 1L) != 0L;
        this.zoomSldRange = new SbVec2f(1.0f, 140.0f);
        this.zooms = new Component[7];
        this.buttonList = new SwImageButton[7];
        this.appButtonList = new SwImageButton[0];
        if (this.decorationFlag) {
            this.buildDecoration();
        }
        this.setRightWheelString(resources.getString("V_DOLLY"));
    }

    @Override
    public void setResources(Locale locale) {
        super.setResources(locale);
        if (this.scene != null && this.scene.getCamera() != null) {
            if (this.scene.getCamera() instanceof SoOrthographicCamera) {
                this.setRightWheelString(resources.getString("V_ZOOM"));
            } else {
                this.setRightWheelString(resources.getString("V_DOLLY"));
            }
        }
        if (this.helpFrame != null) {
            this.helpFrame.setVisible(false);
            this.helpFrame = null;
        }
    }

    @Override
    public void setScene(Scene scene) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.setScene");
        }
        if (this.scene != null && this.scene instanceof Component) {
            this.remove((Component)((Object)this.scene));
        }
        if (this.scene != null && this.scene instanceof SwActiveArea) {
            ((SwActiveArea)this.scene).deactivate();
        }
        super.setScene(scene);
        if (this.scene instanceof Component) {
            this.add((Component)((Object)this.scene), "Center");
        }
        if (this.helpFrame != null) {
            this.helpFrame.setVisible(false);
            this.helpFrame = null;
        }
    }

    @Override
    public void deleteScene() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.deleteScene");
        }
        if (this.scene != null && this.scene instanceof Component) {
            this.remove((Component)((Object)this.scene));
        }
        super.deleteScene();
    }

    @Override
    public void update(Observable observable, Object object) throws IllegalArgumentException {
        super.update(observable, object);
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.update");
        }
        if (this.scene.isCameraUpdated()) {
            if (this.scene.getCamera() instanceof SoOrthographicCamera) {
                this.setRightWheelString(resources.getString("V_ZOOM"));
            } else {
                this.setRightWheelString(resources.getString("V_DOLLY"));
            }
            if (this.zooms[1] != null) {
                boolean bl = this.scene.getCamera() != null && this.scene.getCamera() instanceof SoPerspectiveCamera;
                for (int i = 0; i < 7; ++i) {
                    this.zooms[i].setEnabled(bl);
                }
            }
        }
        if (this.scene.isViewingUpdated()) {
            if (this.buttonList[1] != null) {
                this.buttonList[1].setState(this.scene.isViewing());
            }
            if (this.buttonList[0] != null) {
                this.buttonList[0].setState(!this.scene.isViewing());
            }
        }
    }

    protected GridBagConstraints constraints(int n, int n2, int n3, int n4, float f, float f2, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = f;
        gridBagConstraints.weighty = f2;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.ipadx = n7;
        gridBagConstraints.ipady = n8;
        gridBagConstraints.insets = new Insets(n9, n10, n11, n12);
        return gridBagConstraints;
    }

    @Override
    public void setDecoration(boolean bl) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.setDecoration");
        }
        if (bl == this.decorationFlag) {
            this.decorationFlag = bl;
            return;
        }
        this.decorationFlag = bl;
        if (this.decorationFlag) {
            if (this.leftTrimForm == null) {
                this.buildDecoration();
            } else {
                this.leftTrimForm.setVisible(true);
                this.bottomTrimForm.setVisible(true);
                this.rightTrimForm.setVisible(true);
            }
        } else if (this.leftTrimForm != null) {
            this.leftTrimForm.setVisible(false);
            this.bottomTrimForm.setVisible(false);
            this.rightTrimForm.setVisible(false);
        }
        this.validate();
    }

    @Override
    public boolean isDecoration() {
        return this.decorationFlag;
    }

    protected void setBottomWheelString(String string) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.setBottomWheelString");
        }
        this.bottomWheelStr = new String(string);
        this.bottomWheelLabel.setText(string);
    }

    protected void setHeightWheelString(String string) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.setHeightWheelString");
        }
        this.heightWheelStr = new String(string);
        this.heightWheelLabel.setText(string);
    }

    protected void setLeftWheelString(String string) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.setLeftWheelString");
        }
        this.leftWheelStr = new String(string);
        this.leftWheelLabel.setText(string);
    }

    protected void setRightWheelString(String string) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.setRightWheelString");
        }
        this.rightWheelStr = new String(string);
        this.rightWheelLabel.setText(string);
    }

    protected void buildDecoration() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.buildDecoration");
        }
        this.leftTrimForm = this.buildLeftTrim();
        this.bottomTrimForm = this.buildBottomTrim();
        this.rightTrimForm = this.buildRightTrim();
        this.add((Component)this.leftTrimForm, "West");
        this.add((Component)this.bottomTrimForm, "South");
        this.add((Component)this.rightTrimForm, "East");
    }

    protected void buildLeftWheel() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.buildLeftWheel");
        }
        SwWheel swWheel = new SwWheel(0.0f, 0.0f, 0.0f, 0.0f);
        swWheel.setUnitsPerRotation(360.0f);
        swWheel.setHorizontal(false);
        this.leftWheel = new SwThumbwheel(swWheel);
        swWheel.addWheelListener(new ListenLeftWheel());
        this.leftWheelVal = 0.0f;
    }

    protected void buildHeightWheel() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.buildLeftWheel");
        }
        SwWheel swWheel = new SwWheel(0.0f, 0.0f, 0.0f, 0.0f);
        swWheel.setUnitsPerRotation(360.0f);
        swWheel.setHorizontal(false);
        this.heightWheel = new SwThumbwheel(swWheel);
        swWheel.addWheelListener(new ListenHeightWheel());
        this.heightWheelVal = 0.0f;
    }

    protected Panel buildLeftTrim() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.buildLeftTrim");
        }
        Panel panel = new Panel();
        panel.setName("LeftTrimForm");
        panel.setLayout(new BorderLayout());
        this.leftWheelsPanel = new Panel();
        this.leftWheelsPanel.setLayout(new BoxLayout(this.leftWheelsPanel, 1));
        this.buildLeftWheel();
        this.buildHeightWheel();
        Panel panel2 = this.buildAppButtons();
        this.heightWheelLabel = new Label();
        this.heightWheelLabel.setAlignment(1);
        panel.add((Component)panel2, "North");
        this.leftWheelsPanel.add(this.leftWheel);
        panel.add((Component)this.leftWheelsPanel, "South");
        return panel;
    }

    protected Panel buildBottomTrim() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.buildBottomTrim");
        }
        Panel panel = new Panel();
        panel.setName("BottomTrimForm");
        Panel panel2 = new Panel();
        this.rightPart = new Panel();
        panel.setLayout(new BorderLayout());
        panel2.setLayout(new BoxLayout(panel2, 0));
        this.rightPart.setLayout(new BoxLayout(this.rightPart, 0));
        this.rightWheelLabel = new Label("MotionZ");
        this.rightWheelLabel.setAlignment(2);
        this.bottomWheelLabel = new Label("MotionX");
        this.bottomWheelLabel.setAlignment(2);
        this.leftWheelLabel = new Label("MotionY");
        this.leftWheelLabel.setAlignment(0);
        SwWheel swWheel = new SwWheel(0.0f, 0.0f, 0.0f, 0.0f);
        swWheel.setUnitsPerRotation(360.0f);
        swWheel.setHorizontal(true);
        this.bottomWheel = new SwThumbwheel(swWheel);
        swWheel.addWheelListener(new ListenBottomWheel());
        panel2.add(this.leftWheelLabel);
        panel2.add(this.bottomWheelLabel);
        panel2.add(this.bottomWheel);
        this.bottomWheelVal = 0.0f;
        this.rightPart.add(this.rightWheelLabel);
        panel.add((Component)panel2, "West");
        panel.add((Component)this.rightPart, "East");
        return panel;
    }

    protected Panel buildRightTrim() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.buildRightTrim");
        }
        Panel panel = new Panel();
        panel.setName("RightTrimForm");
        panel.setLayout(new BorderLayout());
        SwWheel swWheel = new SwWheel(0.0f, 0.0f, 0.0f, 0.0f);
        swWheel.setUnitsPerRotation(360.0f);
        swWheel.setHorizontal(false);
        this.rightWheel = new SwThumbwheel(swWheel);
        swWheel.addWheelListener(new ListenRightWheel());
        this.imageButtonForm = this.buildViewerButtons();
        panel.add((Component)this.imageButtonForm, "North");
        panel.add((Component)this.rightWheel, "South");
        this.rightWheelVal = 0.0f;
        return panel;
    }

    protected Panel buildViewerButtons() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.buildViewerButtons");
        }
        Panel panel = new Panel();
        panel.setName("RightButtonForm");
        GridLayout gridLayout = new GridLayout(0, 1);
        panel.setLayout(gridLayout);
        for (int i = 0; i < 7; ++i) {
            this.buttonList[i] = new SwImageButton(this.bitmaps[i], 24, 24);
            this.buttonList[i].addMouseListener(new ListenImageButton(this, i));
            this.buttonList[i].setState(false);
            panel.add(this.buttonList[i]);
        }
        this.buttonList[1].setState(true);
        this.buttonList[0].setState(false);
        return panel;
    }

    protected JPanel buttonHelpPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 10, 5);
        for (int i = 0; i < this.bitmaps.length; ++i) {
            JLabel jLabel = new JLabel();
            ImageIcon imageIcon = new ImageIcon(jLabel.createImage(this.bitmaps[i]));
            jLabel.setIcon(imageIcon);
            jPanel.add((Component)jLabel, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            JTextArea jTextArea = new JTextArea(resources.getString(buttonHelp[i]));
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setBackground(Color.white);
            jTextArea.setEditable(false);
            jPanel.add((Component)jTextArea, new GridBagConstraints(1, i, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        }
        Component component = Box.createVerticalGlue();
        jPanel.add(component, new GridBagConstraints(0, this.bitmaps.length, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        Component component2 = Box.createVerticalGlue();
        jPanel.add(component2, new GridBagConstraints(0, this.bitmaps.length, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        return jPanel;
    }

    @Override
    public void openHelpCard(String string) {
        if (this.helpFrame != null) {
            if (!this.helpFrame.isVisible()) {
                this.updateHelpFrameLookAndFeel();
                this.helpFrame.setVisible(true);
            }
        } else {
            String string2 = SoPreferences.getValue("OIV_HELP_URL");
            JComponent jComponent = string2 == null ? this.createSwingHelpPanel() : this.createURLHelpPanel(string2);
            this.helpFrame = new JFrame(string);
            this.helpFrame.getContentPane().add(jComponent);
            this.helpFrame.setSize(400, 500);
            this.helpFrame.setVisible(true);
        }
    }

    public void updateHelpFrameLookAndFeel() {
        if (this.helpFrame != null) {
            SwingUtilities.updateComponentTreeUI(this.helpFrame);
        }
    }

    protected JComponent createURLHelpPanel(String string) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        try {
            jEditorPane.setPage(new URL(string));
        }
        catch (Exception exception) {
            jEditorPane.setText(exception.getMessage());
        }
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        return jScrollPane;
    }

    protected JComponent createSwingHelpPanel() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JScrollPane jScrollPane = new JScrollPane(this.buttonHelpPanel());
        jTabbedPane.addTab(resources.getString("HELP_BUTTON_TITLE"), jScrollPane);
        HtmlHelpPanel htmlHelpPanel = new HtmlHelpPanel(keyUsageHelp);
        if (this.scene instanceof SwFlyArea) {
            htmlHelpPanel.insertLine("HELP_KEY_FLY_UP");
            htmlHelpPanel.insertLine("HELP_KEY_FLY_STOP");
        } else if (this.scene instanceof SwWalkArea) {
            htmlHelpPanel.insertLine("HELP_KEY_WALK_UP");
        }
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setViewportView(htmlHelpPanel.closePanel());
        jTabbedPane.addTab(resources.getString("HELP_KEY_TITLE"), jScrollPane2);
        JScrollPane jScrollPane3 = new JScrollPane();
        HtmlHelpPanel htmlHelpPanel2 = new HtmlHelpPanel(this.scene.getMouseResourcesName());
        jScrollPane3.setViewportView(htmlHelpPanel2.closePanel());
        jTabbedPane.addTab(resources.getString("HELP_MOUSE_TITLE"), jScrollPane3);
        return jTabbedPane;
    }

    protected Panel buildAppButtons() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.buildAppButtons");
        }
        this.appButtonForm = new Panel();
        this.appButtonForm.setName("AppButtForm");
        if (this.appButtonList.length > 0) {
            this.doAppButtonLayout(0);
        }
        return this.appButtonForm;
    }

    private void doAppButtonLayout(int n) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.doAppButtonLayout");
        }
        int n2 = this.appButtonList.length - n;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.appButtonForm.setLayout(gridBagLayout);
        for (int i = 0; i < this.appButtonList.length; ++i) {
            Container container = this.appButtonList[i].getParent();
            if (container != null) {
                container.remove(this.appButtonList[i]);
            }
            gridBagLayout.setConstraints(this.appButtonList[i], this.constraints(0, i, 1, 1, 0.0f, 0.0f, 18, 0, 0, 0, 0, 0, 0, 0));
            this.appButtonForm.add(this.appButtonList[i]);
        }
    }

    private void setCameraZoom(float f) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.setCameraZoom");
        }
        if (this.scene == null || this.scene.getCamera() == null) {
            return;
        }
        if (this.scene.getCamera() instanceof SoPerspectiveCamera) {
            ((SoPerspectiveCamera)this.scene.getCamera()).heightAngle.setValue((float)((double)f * Math.PI) / 180.0f);
        } else if (this.scene.getCamera() instanceof SoOrthographicCamera) {
            ((SoOrthographicCamera)this.scene.getCamera()).height.setValue(f);
        }
    }

    private float getCameraZoom() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.getCameraZoom");
        }
        if (this.scene == null || this.scene.getCamera() == null) {
            return 0.0f;
        }
        if (this.scene.getCamera() instanceof SoPerspectiveCamera) {
            return ((SoPerspectiveCamera)this.scene.getCamera()).heightAngle.getValue() * 180.0f / (float)Math.PI;
        }
        if (this.scene.getCamera() instanceof SoOrthographicCamera) {
            return ((SoOrthographicCamera)this.scene.getCamera()).height.getValue();
        }
        return 0.0f;
    }

    private void setZoomSliderPosition(float f) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.setZoomSliderPosition");
        }
        if (this.zoomScrollbar == null) {
            return;
        }
        float f2 = (f - this.zoomSldRange.getX()) / (this.zoomSldRange.getY() - this.zoomSldRange.getX());
        f2 = f2 < 0.0f ? 0.0f : (f2 > 1.0f ? 1.0f : f2);
        f2 = (float)Math.sqrt(f2);
        this.zoomScrollbar.setValue(Math.round(f2 * 1000.0f));
    }

    private void setZoomFieldString(float f) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwViewer.setZoomFieldString");
        }
        if (this.zoomScrollbar == null) {
            return;
        }
        this.zoomText.setText(String.valueOf(f));
    }

    protected void rightWheelStart() {
        this.scene.interactiveCountInc();
        this.stopAnimating();
    }

    protected void bottomWheelStart() {
        this.scene.interactiveCountInc();
        this.stopAnimating();
    }

    protected void leftWheelStart() {
        this.scene.interactiveCountInc();
        this.stopAnimating();
    }

    protected void heightWheelStart() {
        this.scene.interactiveCountInc();
        this.stopAnimating();
    }

    protected void rightWheelFinish() {
        this.scene.interactiveCountDec();
    }

    protected void bottomWheelFinish() {
        this.scene.interactiveCountDec();
    }

    protected void leftWheelFinish() {
        this.scene.interactiveCountDec();
    }

    protected void heightWheelFinish() {
        this.scene.interactiveCountDec();
    }

    protected void heightWheelMotion(float f) {
        this.heightWheelVal = f;
    }

    protected void bottomWheelMotion(float f) {
        this.bottomWheelVal = f;
    }

    protected void leftWheelMotion(float f) {
        this.leftWheelVal = f;
    }

    protected void rightWheelMotion(float f) {
        this.rightWheelVal = f;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (DEBUG) {
            System.err.println("DEBUG: JAVA MTHD->SwViewer.writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        if (DEBUG) {
            System.err.println("DEBUG: JAVA MTHD->SwViewer.readObject");
        }
    }

    protected class HtmlHelpPanel {
        private JPanel textPanel = new JPanel();
        private StringBuffer htmlBuffer;

        public HtmlHelpPanel(String[] stringArray) {
            this.textPanel.setLayout(new BorderLayout());
            this.textPanel.setBackground(Color.white);
            if (stringArray == null) {
                return;
            }
            this.htmlBuffer = new StringBuffer();
            this.htmlBuffer.append("<table border=0 cellpadding=5 cellspacing=0>");
            for (int i = 0; i < stringArray.length; ++i) {
                this.insertLine(stringArray[i]);
            }
        }

        public void insertLine(String string) {
            this.htmlBuffer.append("<tr>");
            String string2 = SwPanel.resources.getString(string);
            int n = string2.indexOf("<td>");
            if (n != -1) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 4, string2.length());
                this.htmlBuffer.append("<td valign=top width=120><font size=2>");
                this.htmlBuffer.append(string3);
                this.htmlBuffer.append("<td valign=top><font size=2>");
                this.htmlBuffer.append(string4);
            } else {
                this.htmlBuffer.append("<td valign=top width=120><font size=2>");
                this.htmlBuffer.append(string2);
            }
        }

        public JPanel closePanel() {
            this.htmlBuffer.append("</table>");
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setEditable(false);
            jEditorPane.setEditorKit(new HTMLEditorKit());
            jEditorPane.setText(new String(this.htmlBuffer));
            this.textPanel.add((Component)jEditorPane, "Center");
            this.textPanel.setPreferredSize(new Dimension(300, 600));
            return this.textPanel;
        }
    }

    class ListenRightWheel
    extends ListenWheel {
        ListenRightWheel() {
        }

        @Override
        public void wheelDragged(SwWheelEvent swWheelEvent) {
            SwWheel swWheel = (SwWheel)swWheelEvent.getSource();
            SwViewer swViewer = this.getViewer(swWheel);
            if (!this.drag) {
                swViewer.rightWheelStart();
                this.drag = true;
            }
            swViewer.rightWheelMotion((float)((double)(-swWheel.getValue()) * Math.PI / 180.0));
            swViewer.repaint(0L);
        }

        @Override
        public void wheelChanged(SwWheelEvent swWheelEvent) {
            SwWheel swWheel = (SwWheel)swWheelEvent.getSource();
            this.getViewer(swWheel).rightWheelFinish();
            this.drag = false;
        }
    }

    class ListenHeightWheel
    extends ListenWheel {
        ListenHeightWheel() {
        }

        @Override
        public void wheelDragged(SwWheelEvent swWheelEvent) {
            SoCamera soCamera = SwViewer.this.scene.getCamera();
            if (soCamera == null) {
                return;
            }
            if (!this.drag) {
                SwViewer.this.heightWheelStart();
                this.drag = true;
            }
            SwWheel swWheel = (SwWheel)swWheelEvent.getSource();
            SwViewer.this.heightWheelMotion(swWheel.getValue());
        }

        @Override
        public void wheelChanged(SwWheelEvent swWheelEvent) {
            SoCamera soCamera = SwViewer.this.scene.getCamera();
            if (soCamera == null) {
                return;
            }
            SwViewer.this.heightWheelFinish();
            this.drag = false;
        }
    }

    class ListenLeftWheel
    extends ListenWheel {
        ListenLeftWheel() {
        }

        @Override
        public void wheelDragged(SwWheelEvent swWheelEvent) {
            SwWheel swWheel = (SwWheel)swWheelEvent.getSource();
            SwViewer swViewer = this.getViewer(swWheel);
            if (!this.drag) {
                swViewer.leftWheelStart();
                this.drag = true;
            }
            swViewer.leftWheelMotion((float)(-((double)swWheel.getValue() * Math.PI / 180.0)));
            swViewer.repaint(0L);
        }

        @Override
        public void wheelChanged(SwWheelEvent swWheelEvent) {
            SwWheel swWheel = (SwWheel)swWheelEvent.getSource();
            this.getViewer(swWheel).leftWheelFinish();
            this.drag = false;
        }
    }

    class ListenBottomWheel
    extends ListenWheel {
        ListenBottomWheel() {
        }

        @Override
        public void wheelDragged(SwWheelEvent swWheelEvent) {
            SwWheel swWheel = (SwWheel)swWheelEvent.getSource();
            SwViewer swViewer = this.getViewer(swWheel);
            if (!this.drag) {
                swViewer.bottomWheelStart();
                this.drag = true;
            }
            swViewer.bottomWheelMotion((float)((double)swWheel.getValue() * Math.PI / 180.0));
            swViewer.repaint(0L);
        }

        @Override
        public void wheelChanged(SwWheelEvent swWheelEvent) {
            SwWheel swWheel = (SwWheel)swWheelEvent.getSource();
            this.getViewer(swWheel).bottomWheelFinish();
            this.drag = false;
        }
    }

    class ListenWheel
    implements SwWheelListener {
        boolean drag = false;

        ListenWheel() {
        }

        protected SwViewer getViewer(SwWheel swWheel) {
            Container container;
            for (container = swWheel.getParent(); container != null && !(container instanceof SwViewer); container = container.getParent()) {
            }
            return (SwViewer)container;
        }

        @Override
        public void wheelChanged(SwWheelEvent swWheelEvent) {
        }

        @Override
        public void wheelDragged(SwWheelEvent swWheelEvent) {
        }
    }

    class ListenImageButton
    extends MouseAdapter {
        SwViewer v;
        int id;

        public ListenImageButton(SwViewer swViewer2, int n) {
            this.v = swViewer2;
            this.id = n;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            SwImageButton swImageButton = (SwImageButton)mouseEvent.getSource();
            switch (this.id) {
                case 0: {
                    if (SwViewer.this.scene == null) break;
                    this.v.scene.setViewing(false, mouseEvent);
                    break;
                }
                case 1: {
                    if (SwViewer.this.scene == null) break;
                    this.v.scene.setViewing(true, mouseEvent);
                    break;
                }
                case 2: {
                    this.v.openHelpCard(SwPanel.resources.getString("HELP_FRAME_TITLE"));
                    break;
                }
                case 3: {
                    this.v.resetToHomePosition();
                    break;
                }
                case 4: {
                    this.v.saveHomePosition();
                    break;
                }
                case 5: {
                    this.v.viewAll();
                    break;
                }
                case 6: {
                    if (SwViewer.this.scene == null) break;
                    this.v.scene.setSeekMode(!this.v.scene.isSeekMode());
                }
            }
            if (this.id != 0 && this.id != 1) {
                swImageButton.setState(!swImageButton.getState());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            SwImageButton swImageButton = (SwImageButton)mouseEvent.getSource();
            if (this.id != 0 && this.id != 1) {
                swImageButton.setState(!swImageButton.getState());
            }
        }
    }
}

