/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoPickedPoint;
import com.openinventor.inventor.actions.SoRayPickAction;
import com.openinventor.inventor.awt.SwConstrainedArea;
import com.openinventor.inventor.awt.SwCursor;
import com.openinventor.inventor.awt.SwDrawingArea;
import com.openinventor.inventor.awt.SwPreferences;
import com.openinventor.inventor.awt.SwWalkPreferences;
import com.openinventor.inventor.awt.event.SwActiveAreaKeyboard;
import com.openinventor.inventor.awt.event.SwActiveAreaMouse;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.misc.callbacks.SoCallbackListCB;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.sensors.SoFieldSensor;
import com.openinventor.util.Scene;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

@Deprecated
public class SwWalkArea
extends SwConstrainedArea {
    protected static String[] mouseHelp = new String[]{"HELP_MOUSE_WALK_AROUND", "HELP_MOUSE_WALK_PAN", "HELP_MOUSE_WALK_LOOK", "HELP_MOUSE_WALK_MENU"};
    private static final short REC_SIZE = 12;
    private static final short CROSS = 12;
    private static final float TURN_SPEED = 5.0f;
    private static final float WALK_SPEED_FACTOR = 6.0f;
    private Scene.ViewingModes mode;
    private SbRotation camStartOrientation;
    protected SoFieldSensor animationSensor;
    private SbTime prevAnimTime;
    private float speed;
    private float maxSpeed;
    private float maxStraightSpeed;
    private float speedLimit;
    private float speedLimitFactor;
    private SbVec2s prevPos;
    private boolean animationEnabled;
    private boolean animatingFlag;
    private SetFocalPointFinishCallback focalPtFinishCallback;

    public SwWalkArea(int n) {
        super(n);
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwWalkArea.SwWalkArea");
        }
        this.addMouseDevice(new SwWalkAreaMouse());
        this.addKeyboardDevice(new SwWalkAreaKeyboard());
        this.mode = this.isViewing() ? Scene.ViewingModes.VIEW_MODE : Scene.ViewingModes.PICK_MODE;
        this.prevPos = new SbVec2s();
        this.prevAnimTime = new SbTime();
        this.animationEnabled = true;
        this.animatingFlag = false;
        this.animationSensor = new SoFieldSensor();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.animationSensor.setTask(new AnimationSensorTask());
        if (this.isAnimating()) {
            this.animationSensor.attach(areaRealTime);
        }
        this.focalPtFinishCallback = new SetFocalPointFinishCallback();
        this.addFinishCallback(this.focalPtFinishCallback, this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.animationSensor.detach();
        this.focalPtFinishCallback.dispose();
    }

    @Override
    public SwPreferences getPreferencesPanel() {
        if (this.preferences == null) {
            this.preferences = new SwWalkPreferences(this);
        }
        return this.preferences;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void setViewing(boolean bl, AWTEvent aWTEvent) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwWalkArea.setViewing");
        }
        if (bl == this.viewingFlag) {
            return;
        }
        super.setViewing(bl, aWTEvent);
        this.updateCursor();
        this.setMode(this.isViewing() ? Scene.ViewingModes.VIEW_MODE : Scene.ViewingModes.PICK_MODE, aWTEvent);
    }

    @Override
    public void updateCursor() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwWalkArea.updateCursor");
        }
        switch (this.mode) {
            case PICK_MODE: {
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case VIEW_MODE: 
            case WALK_MODE_ACTIVE: {
                this.setCursor(SwCursor.getPredefinedCursor(107));
                break;
            }
            case PAN_MODE: 
            case PAN_MODE_ACTIVE: {
                this.setCursor(SwCursor.getPredefinedCursor(108));
                break;
            }
            case TILT_MODE_ACTIVE: {
                this.setCursor(SwCursor.getPredefinedCursor(109));
                break;
            }
            case SEEK_MODE: {
                this.setCursor(SwCursor.getPredefinedCursor(105));
                break;
            }
            case SET_UP_MODE: {
                this.setCursor(SwCursor.getPredefinedCursor(106));
            }
        }
    }

    @Override
    public void setCamera(SoCamera soCamera) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwWalkArea.setCamera camera = " + this.camera);
        }
        if (this.camera == soCamera) {
            return;
        }
        super.setCamera(soCamera);
        if (this.camera != null && this.camera instanceof SoOrthographicCamera) {
            this.toggleCameraClass();
        }
    }

    @Override
    public void setCameraClass(Class clazz) {
    }

    @Override
    public void setSeekMode(boolean bl) {
        super.setSeekMode(bl);
        this.setMode(this.isSeekMode() ? Scene.ViewingModes.SEEK_MODE : (this.isViewing() ? Scene.ViewingModes.VIEW_MODE : Scene.ViewingModes.PICK_MODE), null);
    }

    @Override
    public void updateMode(AWTEvent aWTEvent) {
        boolean bl;
        if (aWTEvent == null || !(aWTEvent instanceof InputEvent)) {
            return;
        }
        int n = ((InputEvent)aWTEvent).getModifiersEx();
        boolean bl2 = (n & 0x400) != 0;
        boolean bl3 = (n & 0x800) != 0;
        boolean bl4 = (n & 0x80) != 0;
        boolean bl5 = bl = aWTEvent instanceof MouseEvent && ((MouseEvent)aWTEvent).getID() == 501 || aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getID() == 401;
        if (bl && bl2 && bl3) {
            this.setMode(Scene.ViewingModes.TILT_MODE_ACTIVE, aWTEvent);
        } else if (bl && bl2) {
            if (bl4) {
                this.setMode(Scene.ViewingModes.PAN_MODE_ACTIVE, aWTEvent);
            } else {
                if (DEBUG) {
                    System.out.println("WalkArea updateMode setMode(WALK_MODE_ACTIVE");
                }
                this.setMode(Scene.ViewingModes.WALK_MODE_ACTIVE, aWTEvent);
            }
        } else if (bl && bl3) {
            if (bl4) {
                this.setMode(Scene.ViewingModes.TILT_MODE_ACTIVE, aWTEvent);
            } else {
                this.setMode(Scene.ViewingModes.PAN_MODE_ACTIVE, aWTEvent);
            }
        } else if (bl && bl4) {
            this.setMode(Scene.ViewingModes.PAN_MODE, aWTEvent);
        } else {
            this.setMode(Scene.ViewingModes.VIEW_MODE, aWTEvent);
        }
    }

    @Override
    protected void actualRedraw() {
        super.actualRedraw();
        if (this.isViewing() && (this.mode == Scene.ViewingModes.WALK_MODE_ACTIVE || this.mode == Scene.ViewingModes.PAN_MODE_ACTIVE || this.mode == Scene.ViewingModes.TILT_MODE_ACTIVE)) {
            this.setFeedbackOrthoProjection(this.getSize());
            if (this.mode == Scene.ViewingModes.WALK_MODE_ACTIVE || this.mode == Scene.ViewingModes.PAN_MODE_ACTIVE) {
                this.drawRectFeedback(this.startPos, (short)12, 1, true);
            } else {
                this.drawCrossFeedback(this.startPos, (short)12, 1, true);
            }
            this.restoreGLStateAfterFeedback();
        }
    }

    @Override
    public Scene.ViewingModes getMode() {
        return this.mode;
    }

    @Override
    public void setMode(Scene.ViewingModes viewingModes, AWTEvent aWTEvent) {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwWalkArea.setMode (" + viewingModes + ")");
        }
        if (this.mode == viewingModes) {
            return;
        }
        boolean bl = false;
        Scene.ViewingModes viewingModes2 = this.mode;
        this.mode = viewingModes;
        this.updateCursor();
        if (DEBUG) {
            System.out.println("WALK_MODE_ACTIVE = " + Scene.ViewingModes.WALK_MODE_ACTIVE + " PAN_MODE_ACTIVE = " + Scene.ViewingModes.PAN_MODE_ACTIVE + " TILT_MODE_ACTIVE = " + Scene.ViewingModes.TILT_MODE_ACTIVE);
        }
        switch (viewingModes2) {
            case WALK_MODE_ACTIVE: 
            case PAN_MODE_ACTIVE: {
                if (DEBUG) {
                    System.out.println("SwWalkArea. prevMode PAN_MODE_ACTIVE WALK_MODE_ACTIVE = (" + viewingModes2 + ")");
                }
                this.stopAnimating();
                bl = true;
                break;
            }
            case TILT_MODE_ACTIVE: {
                if (DEBUG) {
                    System.out.println("SwWalkArea. prevMode TILT_MODE_ACTIVE = (" + viewingModes2 + ")");
                }
                bl = true;
                this.interactiveCountDec();
            }
        }
        switch (viewingModes) {
            case PICK_MODE: {
                this.stopAnimating();
                break;
            }
            case WALK_MODE_ACTIVE: 
            case PAN_MODE_ACTIVE: {
                if (DEBUG) {
                    System.out.println("SwWalkArea. newMode PAN_MODE_ACTIVE WALK_MODE_ACTIVE = (" + viewingModes + ")");
                }
                this.startPos.setValue(this.locator);
                this.startAnimating();
                bl = true;
                break;
            }
            case TILT_MODE_ACTIVE: {
                if (DEBUG) {
                    System.out.println("SwWalkArea. newMode TILT_MODE_ACTIVE = (" + viewingModes + ")");
                }
                this.prevPos.setValue(this.locator);
                this.startPos.setValue(this.prevPos);
                bl = true;
                this.interactiveCountInc();
            }
        }
        if (DEBUG) {
            System.out.println("WalkARea setMode redrawNeeded = " + bl);
        }
        if (bl) {
            this.scheduleRedraw();
        }
    }

    private void startAnimating() {
        if (DEBUG) {
            System.out.println("WalkArea.startAnimating isAnimating() = " + this.isAnimating());
        }
        if (!this.isAnimationEnabled()) {
            return;
        }
        if (!this.isAnimating()) {
            this.animationSensor.attach(areaRealTime);
            this.animationSensor.schedule();
            this.prevAnimTime.setValue(areaRealTime.getValue());
            this.interactiveCountInc();
            this.setAnimating(true);
        }
    }

    @Override
    public void stopAnimating() {
        if (DEBUG) {
            System.out.println("WalkArea.stopAnimating isAnimating() = " + this.isAnimating());
        }
        if (this.isAnimating()) {
            this.setAnimating(false);
            this.animationSensor.detach();
            this.animationSensor.unschedule();
            this.interactiveCountDec();
        }
    }

    private void rotateCamera() {
        float f;
        if (this.camera == null) {
            return;
        }
        Dimension dimension = this.getSize();
        float f2 = (float)(this.locator.getY() - this.prevPos.getY()) / (float)dimension.height;
        if (f2 != 0.0f) {
            super.tiltCamera((float)((double)f2 * Math.PI));
        }
        if ((f = (float)(this.locator.getX() - this.prevPos.getX()) / (float)dimension.width) != 0.0f) {
            float f3 = (float)((double)(-f) * Math.PI);
            SbRotation sbRotation = new SbRotation(this.upDirection, f3);
            SbRotation sbRotation2 = this.camera.orientation.getValue().times(sbRotation);
            this.camera.orientation.setValue(sbRotation2);
        }
        this.prevPos.setValue(this.locator);
    }

    @Override
    public void yPlaneCameraAction(float f) {
        float f2 = f * this.sceneHeight * this.areaSpeed;
        SbVec3f sbVec3f = new SbVec3f(this.upDirection);
        sbVec3f.multiply(f2);
        sbVec3f.add(this.camera.position.getValue());
        this.camera.position.setValue(sbVec3f);
    }

    protected void doCameraAnimation() {
        if (DEBUG) {
            System.out.println("DEBUG: JAVA MTHD->SwWalkArea.doCameraAnimation");
        }
        if (this.camera == null) {
            return;
        }
        SbTime sbTime = areaRealTime.getValue();
        SbTime sbTime2 = sbTime.minus(this.prevAnimTime);
        float f = (float)sbTime2.getDoubleValue();
        this.prevAnimTime.setValue(sbTime);
        if ((double)f == 0.0) {
            f = 0.013888889f;
        }
        Dimension dimension = this.getSize();
        if (this.mode == Scene.ViewingModes.WALK_MODE_ACTIVE) {
            float f2 = (float)(this.locator.getX() - this.startPos.getX()) / (float)dimension.width;
            float f3 = 5.0f * (f2 * f2) * f;
            if (f3 != 0.0f) {
                if (f2 < 0.0f) {
                    f3 = -f3;
                }
                SbRotation sbRotation = new SbRotation(this.upDirection, -f3);
                SbRotation sbRotation2 = this.camera.orientation.getValue().times(sbRotation);
                this.camera.orientation.setValue(sbRotation2);
            }
            float f4 = (float)(this.locator.getY() - this.startPos.getY()) / (float)dimension.height;
            float f5 = this.areaSpeed * this.sceneSize * (f4 * f4) * f * 6.0f;
            if (f4 < 0.0f) {
                f5 = -f5;
            }
            if (f5 != 0.0f) {
                this.dollyCameraWalk(f5);
            }
        } else if (this.mode == Scene.ViewingModes.PAN_MODE_ACTIVE) {
            float f6 = (float)(this.locator.getX() - this.startPos.getX()) / (float)dimension.width;
            float f7 = (float)(this.locator.getY() - this.startPos.getY()) / (float)dimension.height;
            float f8 = this.areaSpeed * this.sceneHeight * (f6 * f6) * f * 6.0f;
            float f9 = this.areaSpeed * this.sceneHeight * (f7 * f7) * f * 6.0f;
            if (f6 < 0.0f) {
                f8 = -f8;
            }
            if (f7 < 0.0f) {
                f9 = -f9;
            }
            SbMatrix sbMatrix = new SbMatrix();
            sbMatrix.setRotate(this.camera.orientation.getValue());
            float[] fArray = sbMatrix.getColumn(1);
            SbVec3f sbVec3f = new SbVec3f(fArray[0], fArray[1], fArray[2]);
            fArray = sbMatrix.getColumn(0);
            SbVec3f sbVec3f2 = new SbVec3f(fArray[0], fArray[1], fArray[2]);
            SbVec3f sbVec3f3 = new SbVec3f();
            if (f8 != 0.0f) {
                sbVec3f3 = sbVec3f2.times(f8);
                sbVec3f3.add(this.camera.position.getValue());
                this.camera.position.setValue(sbVec3f3);
            }
            if (f9 != 0.0f) {
                sbVec3f3 = sbVec3f.times(f9);
                sbVec3f3.add(this.camera.position.getValue());
                this.camera.position.setValue(sbVec3f3);
            }
        }
    }

    protected void dollyCameraWalk(float f) {
        if (this.camera == null) {
            return;
        }
        SbMatrix sbMatrix = new SbMatrix();
        sbMatrix.setRotate(this.camera.orientation.getValue());
        float[] fArray = sbMatrix.getColumn(0);
        SbVec3f sbVec3f = this.upDirection.cross(new SbVec3f(fArray[0], fArray[1], fArray[2]));
        sbVec3f.normalize();
        SbVec3f sbVec3f2 = sbVec3f.times(f);
        sbVec3f2.add(this.camera.position.getValue());
        this.camera.position.setValue(sbVec3f2);
        this.camera.focalDistance.setValue(this.camera.focalDistance.getValue() - f);
    }

    private void updateCameraFocalPoint() {
        int n = 0;
        float f = 0.0f;
        float[][] fArrayArray = new float[][]{{0.5f, 0.3f}, {0.5f, 0.7f}, {0.3f, 0.5f}, {0.7f, 0.5f}};
        SbVec3f sbVec3f = this.camera.position.getValue();
        SoRayPickAction soRayPickAction = new SoRayPickAction(new SbViewportRegion(this.getSize()));
        soRayPickAction.setRadius(1.0f);
        soRayPickAction.setPickAll(false);
        for (int i = 0; i < 4; ++i) {
            soRayPickAction.setNormalizedPoint(new SbVec2f(fArrayArray[i]));
            soRayPickAction.apply(this.internalSceneRoot);
            SoPickedPoint soPickedPoint = soRayPickAction.getPickedPoint();
            if (soPickedPoint == null) continue;
            SbVec3f sbVec3f2 = soPickedPoint.getPoint().minus(sbVec3f);
            f += sbVec3f2.length();
            if (++n == 2) break;
        }
        if (n > 1) {
            f /= (float)n;
        }
        if (f != 0.0f) {
            this.camera.enableNotify(false);
            this.camera.focalDistance.setValue(f);
            this.camera.enableNotify(true);
        }
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float f) {
        this.speed = f;
    }

    public float getSpeedLimit() {
        return this.speedLimit;
    }

    public void setSpeedLimit(float f) {
        this.speedLimit = f;
    }

    public float getSpeedLimitFactor() {
        return this.speedLimitFactor;
    }

    public void setSpeedLimitFactor(float f) {
        this.speedLimitFactor = f;
    }

    public float getMaxStraightSpeed() {
        return this.maxStraightSpeed;
    }

    public void setMaxStraightSpeed(float f) {
        this.maxStraightSpeed = f;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float f) {
        this.maxSpeed = f;
    }

    public SoFieldSensor getAnimationSensor() {
        return this.animationSensor;
    }

    public void setPrevAnimTime(SbTime sbTime) {
        this.prevAnimTime.setValue(sbTime);
    }

    public SbRotation getCamStartOrientation() {
        return this.camStartOrientation;
    }

    @Override
    public void setAnimating(boolean bl) {
        this.animatingFlag = bl;
    }

    @Override
    public boolean isAnimating() {
        return this.animatingFlag;
    }

    @Override
    public void setAnimationEnabled(boolean bl) {
        if (this.animationEnabled == bl) {
            return;
        }
        this.animationEnabled = bl;
        if (!this.animationEnabled && this.isAnimating()) {
            this.stopAnimating();
        }
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    @Override
    public String[] getMouseResourcesName() {
        return mouseHelp;
    }

    class SwWalkAreaMouse
    extends SwActiveAreaMouse {
        boolean pressed = true;

        SwWalkAreaMouse() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (this.pressed) {
                super.mousePressed(mouseEvent);
                if (mouseEvent.isConsumed()) {
                    return;
                }
            }
            if ((n = mouseEvent.getButton()) != 1 && n != 2) {
                return;
            }
            Dimension dimension = SwWalkArea.this.getSize();
            SwWalkArea.this.setLocator(mouseEvent.getX(), dimension.height - mouseEvent.getY());
            if (SwDrawingArea.DEBUG) {
                System.out.println("WalkAreaMouse mousePressed setLocator(" + mouseEvent.getX() + ", " + (dimension.height - mouseEvent.getY()) + ")");
            }
            if (SwWalkArea.this.mode == Scene.ViewingModes.SEEK_MODE) {
                if (SwDrawingArea.DEBUG) {
                    System.out.println("WalkAreaMouse SEEK_MODE");
                }
                if (this.pressed) {
                    SwWalkArea.this.seekToPoint(SwWalkArea.this.locator);
                }
            } else if (SwWalkArea.this.mode == Scene.ViewingModes.SET_UP_MODE) {
                if (SwDrawingArea.DEBUG) {
                    System.out.println("WalkAreaMouse SET_UP_MODE");
                }
                if (this.pressed) {
                    SwWalkArea.this.findUpDirection(SwWalkArea.this.locator);
                    SwWalkArea.this.setMode(Scene.ViewingModes.VIEW_MODE, mouseEvent);
                }
            } else {
                if (SwDrawingArea.DEBUG) {
                    System.out.println("WalkAreaMouse !SET_UP_MODE et !SEEK_MODE");
                }
                SwWalkArea.this.updateMode(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.pressed = false;
            this.mousePressed(mouseEvent);
            this.pressed = true;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.mouseDragged(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
            if (mouseEvent.isConsumed()) {
                return;
            }
            Dimension dimension = SwWalkArea.this.getSize();
            SwWalkArea.this.setLocator(mouseEvent.getX(), dimension.height - mouseEvent.getY());
            if (SwWalkArea.this.mode == Scene.ViewingModes.TILT_MODE_ACTIVE) {
                SwWalkArea.this.rotateCamera();
            }
        }
    }

    class SwWalkAreaKeyboard
    extends SwActiveAreaKeyboard {
        boolean pressed = true;

        SwWalkAreaKeyboard() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            SoKeyboardEvent.Keys keys;
            if (this.pressed) {
                super.keyPressed(keyEvent);
                if (keyEvent.isConsumed()) {
                    return;
                }
            }
            if ((keys = SoKeyboardEvent.getKeySym(keyEvent.getKeyCode())) == SoKeyboardEvent.Keys.LEFT_CONTROL || keys == SoKeyboardEvent.Keys.RIGHT_CONTROL) {
                SwWalkArea.this.updateMode(keyEvent);
            } else if (keys == SoKeyboardEvent.Keys.U && this.pressed) {
                if (SwWalkArea.this.isSeekMode()) {
                    SwWalkArea.this.setSeekMode(false);
                }
                SwWalkArea.this.setMode(SwWalkArea.this.getMode() == Scene.ViewingModes.SET_UP_MODE ? Scene.ViewingModes.VIEW_MODE : Scene.ViewingModes.SET_UP_MODE, keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            super.keyReleased(keyEvent);
            if (keyEvent.isConsumed()) {
                return;
            }
            this.pressed = false;
            this.keyPressed(keyEvent);
            this.pressed = true;
        }
    }

    class SetFocalPointFinishCallback
    extends SoCallbackListCB {
        SetFocalPointFinishCallback() {
        }

        @Override
        public void invoke(Object object) {
            if (!SwWalkArea.this.isSeekMode()) {
                SwWalkArea.this.updateCameraFocalPoint();
            }
        }
    }

    class AnimationSensorTask
    implements Runnable {
        AnimationSensorTask() {
        }

        @Override
        public void run() {
            SwWalkArea.this.doCameraAnimation();
        }
    }
}

