/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt;

import com.openinventor.inventor.awt.event.SwWheelEvent;
import com.openinventor.inventor.awt.event.SwWheelListener;
import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

@Deprecated
public class SwWheel
extends Canvas {
    private static final float LIGHT = 0.9f;
    protected static final int WHEEL_WIDTH = 120;
    protected static final int WHEEL_HEIGHT = 20;
    protected static final float VIEWABLE_ANGLE = 150.0f;
    private Vector wheelListenerList;
    float lowerBound;
    float upperBound;
    float angleRange;
    float value;
    float unitsPerRotation;
    float homePosition;
    float viewablePixels;
    boolean horizontal;
    boolean animate;
    boolean infinite;
    boolean dragging;
    boolean highlighted = false;
    boolean pegged;
    int wheel_x;
    int wheel_y;
    boolean firstPaint;
    Image[] wheels;
    Color[] wheelColors;
    int currentWheel;
    Color medium;
    Color light;
    Color lighter;
    Color verylight;
    Color lightest;
    Color dark;
    Color veryDark;
    Color darkest;
    Insets insets;

    public SwWheel() {
        this(0.0f, 100.0f);
    }

    public SwWheel(float f, float f2) {
        this(f, f2, 150.0f, 0.0f, 50.0f);
    }

    public SwWheel(float f, float f2, float f3, float f4) {
        this(f, f2, f3, f4, 50.0f);
    }

    public SwWheel(float f, float f2, float f3, float f4, float f5) {
        this(f, f2, f3, f4, f5, 240.0f);
    }

    public SwWheel(float f, float f2, float f3, float f4, float f5, float f6) {
        this(f, f2, f3, f4, f5, f6, true);
    }

    public SwWheel(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        this.unitsPerRotation = f6;
        this.horizontal = bl;
        this.lowerBound = f;
        this.upperBound = f2;
        this.angleRange = f3;
        this.value = f4;
        this.homePosition = f5;
        this.constructorCommon();
    }

    private void constructorCommon() {
        InternalListenWheel internalListenWheel = new InternalListenWheel();
        this.wheelListenerList = new Vector();
        this.addMouseMotionListener(internalListenWheel);
        this.addMouseListener(internalListenWheel);
        this.firstPaint = true;
        this.insets = new Insets(2, 2, 2, 2);
        this.wheels = new Image[8];
        this.wheelColors = new Color[7];
        this.currentWheel = 0;
        if (this.lowerBound > this.upperBound) {
            float f = this.lowerBound;
            this.lowerBound = this.upperBound;
            this.upperBound = f;
        } else if (this.upperBound == this.lowerBound || this.angleRange == 0.0f) {
            this.infinite = true;
        }
        if (!this.infinite) {
            if (this.value < this.lowerBound) {
                this.value = this.lowerBound;
            }
            if (this.value > this.upperBound) {
                this.value = this.upperBound;
            }
            if (this.homePosition < this.lowerBound) {
                this.homePosition = this.lowerBound;
            }
            if (this.homePosition > this.upperBound) {
                this.homePosition = this.upperBound;
            }
        }
        this.viewablePixels = 120.0f;
    }

    public void addWheelListener(SwWheelListener swWheelListener) {
        if (swWheelListener != null) {
            this.wheelListenerList.addElement(swWheelListener);
        }
    }

    public void removeWheelListener(SwWheelListener swWheelListener) {
        int n;
        if (swWheelListener == null) {
            return;
        }
        while ((n = this.wheelListenerList.indexOf(swWheelListener)) > 0) {
            this.wheelListenerList.removeElementAt(n);
        }
    }

    @Override
    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof SwWheelEvent) {
            this.processWheelEvent((SwWheelEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    public void processWheelEvent(SwWheelEvent swWheelEvent) {
        block4: for (int i = 0; i < this.wheelListenerList.size(); ++i) {
            switch (swWheelEvent.getType()) {
                case 0: {
                    ((SwWheelListener)this.wheelListenerList.elementAt(i)).wheelChanged(swWheelEvent);
                    continue block4;
                }
                case 1: {
                    ((SwWheelListener)this.wheelListenerList.elementAt(i)).wheelDragged(swWheelEvent);
                }
            }
        }
    }

    protected void increase(int n) {
        if (this.setValueToAdd(this.convertPixelsToUserUnits(n))) {
            this.currentWheel = this.currentWheel == 3 ? 0 : ++this.currentWheel;
        }
    }

    protected void decrease(int n) {
        if (this.setValueToAdd(this.convertPixelsToUserUnits(-n))) {
            this.currentWheel = this.currentWheel == 0 ? 3 : --this.currentWheel;
        }
    }

    private float pixelsToAngleFactor() {
        return 150.0f / this.viewablePixels;
    }

    private float angleToUserUnitFactor() {
        return this.infinite ? this.unitsPerRotation / 360.0f : (this.upperBound - this.lowerBound) / this.angleRange;
    }

    private float convertPixelsToUserUnits(int n) {
        float f = n > 0 ? (float)n * this.pixelsToAngleFactor() * this.angleToUserUnitFactor() + 0.5f : (float)n * this.pixelsToAngleFactor() * this.angleToUserUnitFactor() - 0.5f;
        return f;
    }

    private int convertUserUnitsToPixels(float f) {
        float f2 = f > 0.0f ? f / this.pixelsToAngleFactor() / this.angleToUserUnitFactor() + 0.5f : f / this.pixelsToAngleFactor() / this.angleToUserUnitFactor() - 0.5f;
        return (int)f2;
    }

    boolean setValueToAdd(float f) {
        float f2 = this.value;
        this.value += f;
        if (!this.infinite) {
            if (this.value < this.lowerBound) {
                this.value = this.lowerBound;
            } else if (this.value > this.upperBound) {
                this.value = this.upperBound;
            }
        }
        return this.value != f2;
    }

    void hasChanged(float f) {
        this.dispatchEvent(new SwWheelEvent(this, 0, f, this.value));
    }

    void isDragged(float f) {
        this.dispatchEvent(new SwWheelEvent(this, 1, f, this.value));
    }

    public void setToHomePosition() {
        float f = this.value;
        this.value = this.homePosition;
        if (this.value != f) {
            this.hasChanged(f);
        }
    }

    protected void setHighlighted(boolean bl) {
        if (bl == this.highlighted) {
            return;
        }
        this.highlighted = bl;
        this.repaint();
    }

    public void setHorizontal(boolean bl) {
        if (this.horizontal == bl) {
            return;
        }
        this.horizontal = bl;
        this.firstPaint = true;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.horizontal ? new Dimension(120, 20) : new Dimension(20, 120);
    }

    public void setUnitsPerRotation(float f) {
        this.unitsPerRotation = f;
    }

    public float getViewablePixels() {
        return this.viewablePixels;
    }

    public void setValue(float f) {
        this.setValue(f, true);
    }

    public void setValue(float f, boolean bl) {
        float f2 = this.value;
        this.value = f;
        if (!this.infinite) {
            if (this.value < this.lowerBound) {
                this.value = this.lowerBound;
            } else if (this.value > this.upperBound) {
                this.value = this.upperBound;
            }
        }
        if (bl && this.value != f2) {
            this.hasChanged(f2);
        }
    }

    public float getValue() {
        return this.value;
    }

    public float getAngleFactor() {
        return this.unitsPerRotation;
    }

    public float getUpperBound() {
        return this.upperBound;
    }

    public float getLowerBound() {
        return this.lowerBound;
    }

    public float getAngleRange() {
        return this.angleRange;
    }

    public void setUpperBound(float f) {
        this.upperBound = f < this.lowerBound ? this.lowerBound : f;
        this.infinite = this.upperBound == this.lowerBound;
    }

    public void setLowerBound(float f) {
        this.lowerBound = f > this.upperBound ? this.upperBound : f;
        this.infinite = this.lowerBound == this.upperBound;
    }

    public void setHomePosition(float f) {
        this.homePosition = f;
        if (!this.infinite) {
            if (f < this.lowerBound) {
                this.homePosition = this.lowerBound;
            } else if (f > this.upperBound) {
                this.homePosition = this.upperBound;
            }
        }
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void wheelDrawLine(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        if (graphics == null) {
            return;
        }
        graphics.setColor(color);
        if (this.horizontal) {
            graphics.drawLine(n, n2, n3, n4);
        } else {
            graphics.drawLine(n2, n, n4, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.firstPaint) {
            this.medium = new Color(Color.gray.darker().getRGB());
            this.light = new Color(Color.gray.getRGB());
            this.lighter = new Color(0.9f, 0.9f, 0.9f);
            this.verylight = this.light.brighter();
            this.lightest = new Color(Color.white.getRGB());
            this.dark = new Color(Color.darkGray.getRGB());
            this.veryDark = this.dark.darker().darker();
            this.darkest = new Color(Color.black.getRGB());
            this.wheels[0] = this.createWheel(0, false);
            this.wheels[1] = this.createWheel(2, false);
            this.wheels[2] = this.createWheel(4, false);
            this.wheels[3] = this.createWheel(-2, false);
            this.wheels[4] = this.createWheel(0, true);
            this.wheels[5] = this.createWheel(2, true);
            this.wheels[6] = this.createWheel(4, true);
            this.wheels[7] = this.createWheel(-2, true);
            this.firstPaint = false;
        }
        Dimension dimension = this.getSize();
        graphics.setColor(this.lighter);
        graphics.drawLine(0, 0, dimension.width - 1, 0);
        graphics.drawLine(0, 1, dimension.width - 1, 1);
        graphics.drawLine(0, 0, 0, dimension.height - 1);
        graphics.drawLine(1, 0, 1, dimension.height - 1);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(2, dimension.height - 2, dimension.width - 1, dimension.height - 2);
        graphics.drawLine(dimension.width - 1, 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 2, 2, dimension.width - 2, dimension.height - 1);
        graphics.setColor(this.highlighted ? this.verylight : this.light);
        graphics.fillRect(this.insets.left, this.insets.top, dimension.width - (this.insets.left + this.insets.right), dimension.height - (this.insets.bottom + this.insets.top));
        this.redraw();
    }

    public void redraw() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.drawImage(this.wheels[this.currentWheel + (this.highlighted || !this.isEnabled() ? 4 : 0)], this.insets.left, this.insets.top, this);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.redraw();
    }

    private Image createWheel(int n, boolean bl) {
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            dimension = this.getPreferredSize();
        }
        Image image = this.createImage(dimension.width - (this.insets.left + this.insets.right), dimension.height - (this.insets.bottom + this.insets.top));
        Graphics graphics = image.getGraphics();
        graphics.setColor(bl ? this.verylight : this.light);
        graphics.fillRect(0, 0, dimension.width - (this.insets.left + this.insets.right), dimension.height - (this.insets.bottom + this.insets.top));
        this.wheelDrawLine(graphics, this.veryDark, 3, 2, 112, 2);
        this.wheelDrawLine(graphics, this.darkest, 3, 13, 112, 13);
        this.wheelDrawLine(graphics, this.darkest, 3, 3, 8, 3);
        this.wheelDrawLine(graphics, this.darkest, 3, 12, 8, 12);
        this.wheelDrawLine(graphics, this.dark, 9, 3, 15, 3);
        this.wheelDrawLine(graphics, this.dark, 9, 12, 15, 12);
        this.wheelDrawLine(graphics, this.medium, 16, 3, 23, 3);
        this.wheelDrawLine(graphics, this.medium, 16, 12, 23, 12);
        this.wheelDrawLine(graphics, this.light, 24, 3, 34, 3);
        this.wheelDrawLine(graphics, this.light, 24, 12, 34, 12);
        this.wheelDrawLine(graphics, this.verylight, 35, 3, 45, 3);
        this.wheelDrawLine(graphics, this.verylight, 35, 12, 45, 12);
        this.wheelDrawLine(graphics, this.lightest, 46, 3, 68, 3);
        this.wheelDrawLine(graphics, this.lightest, 46, 12, 68, 12);
        this.wheelDrawLine(graphics, this.verylight, 69, 3, 79, 3);
        this.wheelDrawLine(graphics, this.verylight, 69, 12, 79, 12);
        this.wheelDrawLine(graphics, this.light, 80, 3, 90, 3);
        this.wheelDrawLine(graphics, this.light, 80, 12, 90, 12);
        this.wheelDrawLine(graphics, this.medium, 91, 3, 98, 3);
        this.wheelDrawLine(graphics, this.medium, 91, 12, 98, 12);
        this.wheelDrawLine(graphics, this.dark, 99, 3, 105, 3);
        this.wheelDrawLine(graphics, this.dark, 99, 12, 105, 12);
        this.wheelDrawLine(graphics, this.darkest, 106, 3, 112, 3);
        this.wheelDrawLine(graphics, this.darkest, 106, 12, 112, 12);
        this.wheelDrawLine(graphics, this.darkest, 3, 4, 3, 11);
        this.wheelDrawLine(graphics, this.dark, 4, 4, 4, 11);
        this.wheelDrawLine(graphics, this.dark, 111, 4, 111, 11);
        this.wheelDrawLine(graphics, this.darkest, 112, 4, 112, 11);
        this.wheelDrawLine(graphics, this.darkest, 5, 4, 5, 11);
        this.wheelDrawLine(graphics, this.dark, 6, 4, 6, 11);
        this.wheelDrawLine(graphics, this.darkest, 8, 4, 8, 11);
        this.wheelDrawLine(graphics, this.darkest, 107, 4, 107, 11);
        this.wheelDrawLine(graphics, this.dark, 109, 4, 109, 11);
        this.wheelDrawLine(graphics, this.darkest, 110, 4, 110, 11);
        if (n > -2) {
            this.wheelDrawLine(graphics, this.dark, 9 + n, 4, 9 + n, 11);
        }
        this.wheelDrawLine(graphics, this.veryDark, 12 + n, 4, 12 + n, 11);
        this.wheelDrawLine(graphics, this.verylight, 17 + n, 4, 17 + n, 11);
        this.wheelDrawLine(graphics, this.dark, 18 + n, 4, 18 + n, 11);
        this.wheelDrawLine(graphics, this.verylight, 23 + n, 4, 23 + n, 11);
        this.wheelDrawLine(graphics, this.dark, 24 + n, 4, 24 + n, 11);
        this.wheelDrawLine(graphics, this.lightest, 30 + n, 4, 30 + n, 11);
        this.wheelDrawLine(graphics, this.dark, 31 + n, 4, 31 + n, 11);
        this.wheelDrawLine(graphics, this.lightest, 37 + n, 4, 37 + n, 11);
        this.wheelDrawLine(graphics, this.dark, 38 + n, 4, 38 + n, 11);
        this.wheelDrawLine(graphics, this.lightest, 44 + n, 4, 44 + n, 11);
        this.wheelDrawLine(graphics, this.lightest, 45 + n, 4, 45 + n, 11);
        this.wheelDrawLine(graphics, this.dark, 46 + n, 4, 46 + n, 11);
        this.wheelDrawLine(graphics, this.lightest, 52 + n, 4, 52 + n, 11);
        this.wheelDrawLine(graphics, this.lightest, 53 + n, 4, 53 + n, 11);
        this.wheelDrawLine(graphics, this.dark, 54 + n, 4, 54 + n, 11);
        this.wheelDrawLine(graphics, this.lightest, 60 + n, 4, 60 + n, 11);
        this.wheelDrawLine(graphics, this.lightest, 61 + n, 4, 61 + n, 11);
        this.wheelDrawLine(graphics, this.dark, 62 + n, 4, 62 + n, 11);
        this.wheelDrawLine(graphics, this.lightest, 68 + n, 4, 68 + n, 11);
        this.wheelDrawLine(graphics, this.lightest, 69 + n, 4, 69 + n, 11);
        this.wheelDrawLine(graphics, this.dark, 70 + n, 4, 70 + n, 11);
        this.wheelDrawLine(graphics, this.lightest, 77 + n, 4, 77 + n, 11);
        this.wheelDrawLine(graphics, this.dark, 78 + n, 4, 78 + n, 11);
        this.wheelDrawLine(graphics, this.lightest, 84 + n, 4, 84 + n, 11);
        this.wheelDrawLine(graphics, this.dark, 85 + n, 4, 85 + n, 11);
        this.wheelDrawLine(graphics, this.verylight, 91 + n, 4, 91 + n, 11);
        this.wheelDrawLine(graphics, this.dark, 92 + n, 4, 92 + n, 11);
        this.wheelDrawLine(graphics, this.verylight, 97 + n, 4, 97 + n, 11);
        this.wheelDrawLine(graphics, this.dark, 98 + n, 4, 98 + n, 11);
        if (n < 4) {
            this.wheelDrawLine(graphics, this.veryDark, 103 + n, 4, 103 + n, 11);
        }
        if (n < 2) {
            this.wheelDrawLine(graphics, this.dark, 106 + n, 4, 106 + n, 11);
        }
        return image;
    }

    class InternalListenWheel
    implements MouseMotionListener,
    MouseListener {
        int lastPosition = 0;
        float oldValue;

        InternalListenWheel() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            SwWheel swWheel = (SwWheel)mouseEvent.getSource();
            this.oldValue = swWheel.getValue();
            this.lastPosition = swWheel.isHorizontal() ? mouseEvent.getX() : mouseEvent.getY();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            float f = ((SwWheel)mouseEvent.getSource()).getValue();
            if (f != this.oldValue) {
                ((SwWheel)mouseEvent.getSource()).hasChanged(this.oldValue);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            ((SwWheel)mouseEvent.getSource()).setHighlighted(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ((SwWheel)mouseEvent.getSource()).setHighlighted(false);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            SwWheel swWheel = (SwWheel)mouseEvent.getSource();
            int n = swWheel.isHorizontal() ? mouseEvent.getX() : mouseEvent.getY();
            if (n > this.lastPosition) {
                swWheel.increase(n - this.lastPosition);
            } else {
                swWheel.decrease(this.lastPosition - n);
            }
            this.lastPosition = n;
            swWheel.redraw();
            swWheel.isDragged(this.oldValue);
        }
    }
}

