/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt.event;

import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.awt.SwRenderArea;
import com.openinventor.inventor.awt.event.SwMouseDevice;
import com.openinventor.inventor.events.SoButtonEvent;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

@Deprecated
public class SwMouse
implements SwMouseDevice {
    SoMouseButtonEvent buttonEvent;
    SoLocation2Event loc2Event;
    boolean isHighResMouseEnabled = false;

    public SwMouse() {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win") && SoPreferences.getBoolean("SCALEVIZ_HIGHRES_MOUSE", false)) {
            this.isHighResMouseEnabled = true;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        SoMouseButtonEvent soMouseButtonEvent = this.translateButtonEvent(mouseEvent, SoButtonEvent.States.DOWN);
        if (soMouseButtonEvent == null) {
            return;
        }
        ((SwRenderArea)mouseEvent.getSource()).processSoEvent(soMouseButtonEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        SoMouseButtonEvent soMouseButtonEvent = this.translateButtonEvent(mouseEvent, SoButtonEvent.States.UP);
        if (soMouseButtonEvent == null) {
            return;
        }
        ((SwRenderArea)mouseEvent.getSource()).processSoEvent(soMouseButtonEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        SoLocation2Event soLocation2Event = this.translateMotionEvent(mouseEvent);
        if (soLocation2Event == null) {
            return;
        }
        ((SwRenderArea)mouseEvent.getSource()).processSoEvent(soLocation2Event);
        mouseEvent.consume();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        SoLocation2Event soLocation2Event = this.translateMotionEvent(mouseEvent);
        if (soLocation2Event == null) {
            return;
        }
        ((SwRenderArea)mouseEvent.getSource()).processSoEvent(soLocation2Event);
        mouseEvent.consume();
    }

    @Override
    public void mouseDoubleClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        SoMouseButtonEvent soMouseButtonEvent = this.translateButtonEvent(mouseEvent, SoButtonEvent.States.DBCLK);
        if (soMouseButtonEvent == null) {
            return;
        }
        ((SwRenderArea)mouseEvent.getSource()).processSoEvent(soMouseButtonEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseWheelMoved(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        SoMouseWheelEvent soMouseWheelEvent = new SoMouseWheelEvent();
        this.setCommonEventProperties(soMouseWheelEvent, mouseEvent);
        int n = ((MouseWheelEvent)mouseEvent).getWheelRotation();
        soMouseWheelEvent.setDelta(-n * SoPreferences.getInteger("OIV_WHEEL_DELTA", 120));
        ((SwRenderArea)mouseEvent.getSource()).processSoEvent(soMouseWheelEvent);
        mouseEvent.consume();
    }

    private native void checkHighResMouseNativ(long var1, float[] var3, int[] var4);

    private void setCommonEventProperties(SoEvent soEvent, MouseEvent mouseEvent) {
        SwRenderArea swRenderArea = (SwRenderArea)mouseEvent.getSource();
        Dimension dimension = swRenderArea.getSize();
        SbVec2f sbVec2f = new SbVec2f(mouseEvent.getX(), mouseEvent.getY());
        if (this.isHighResMouseEnabled) {
            try {
                Point point = swRenderArea.getLocationOnScreen();
                SbVec2i32 sbVec2i32 = new SbVec2i32(point.x + mouseEvent.getX(), point.y + mouseEvent.getY());
                this.checkHighResMouseNativ(swRenderArea.getAreaPeer().getDisplay(), sbVec2f.array, sbVec2i32.array);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        sbVec2f.setY((float)dimension.height - 1.0f - sbVec2f.getY());
        soEvent.setPosition(sbVec2f);
        long l = mouseEvent.getWhen();
        long l2 = l / 1000L;
        soEvent.setTime(new SbTime(l2, 1000L * (l - 1000L * l2)));
        soEvent.setShiftDown(mouseEvent.isShiftDown());
        soEvent.setCtrlDown(mouseEvent.isControlDown());
        soEvent.setAltDown(mouseEvent.isAltDown());
    }

    protected final SoMouseButtonEvent translateButtonEvent(MouseEvent mouseEvent, SoButtonEvent.States states) {
        this.buttonEvent = new SoMouseButtonEvent();
        this.setCommonEventProperties(this.buttonEvent, mouseEvent);
        SoMouseButtonEvent.Buttons buttons = SoMouseButtonEvent.Buttons.ANY;
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) != 0) {
            buttons = SoMouseButtonEvent.Buttons.BUTTON1;
        } else if ((n & 8) != 0) {
            buttons = SoMouseButtonEvent.Buttons.BUTTON2;
        } else if ((n & 4) != 0) {
            buttons = SoMouseButtonEvent.Buttons.BUTTON3;
        }
        this.buttonEvent.setButton(buttons);
        this.buttonEvent.setState(states);
        return this.buttonEvent;
    }

    protected final SoLocation2Event translateMotionEvent(MouseEvent mouseEvent) {
        this.loc2Event = new SoLocation2Event();
        this.setCommonEventProperties(this.loc2Event, mouseEvent);
        return this.loc2Event;
    }
}

