/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.awt.peer;

import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.awt.Sw3D;
import com.openinventor.inventor.awt.SwDrawingArea;
import com.openinventor.inventor.awt.SwGLGraphicsConfig;
import com.openinventor.inventor.awt.peer.SbSharedContextGroupKeeper;
import java.awt.Component;
import java.awt.GraphicsConfiguration;

@Deprecated
public abstract class SwDrawingAreaPeer
implements Sw3D {
    protected static SbSharedContextGroupKeeper contextKeeper = new SbSharedContextGroupKeeper();
    protected SwDrawingArea m_area;
    private long m_drawingSurface = 0L;
    private long m_drawingSurfaceInfo = 0L;
    protected long m_glContext;
    protected long m_display = 0L;
    protected long m_window = 0L;
    protected long m_visual = 0L;
    protected int m_cacheContextId;
    protected int lockCount = 0;

    public static SwDrawingAreaPeer createDrawingAreaPeer(SwDrawingArea swDrawingArea) {
        String string;
        String string2 = System.getProperty("os.name");
        if (string2.toLowerCase().startsWith("win")) {
            string = "com.openinventor.inventor.awt.peer.win32.SwWin32DrawingAreaPeer";
        } else if (!string2.startsWith("Mac")) {
            string = "com.openinventor.inventor.awt.peer.unix.SwX11DrawingAreaPeer";
        } else {
            throw new UnsupportedOperationException("Unsupported platform.");
        }
        SwDrawingAreaPeer swDrawingAreaPeer = null;
        try {
            swDrawingAreaPeer = (SwDrawingAreaPeer)Class.forName(string).newInstance();
            swDrawingAreaPeer.setArea(swDrawingArea);
        }
        catch (Exception exception) {
            System.out.println("SwDrawingAreaPeer: could not create instance of: " + string);
            exception.printStackTrace();
            return null;
        }
        return swDrawingAreaPeer;
    }

    public static boolean supportFsaaHighQuality() {
        return SwDrawingAreaPeer.supportFsaaHighQualityNative();
    }

    private static native boolean supportFsaaHighQualityNative();

    public void setArea(SwDrawingArea swDrawingArea) {
        this.m_area = swDrawingArea;
    }

    public abstract void setGraphicsConfiguration(GraphicsConfiguration var1);

    public void setGLGraphicsConfig(SwGLGraphicsConfig swGLGraphicsConfig) {
        swGLGraphicsConfig.activate();
    }

    public void lock() {
        ++this.lockCount;
        if (this.lockCount > 1) {
            return;
        }
        if (this.m_drawingSurface != 0L || this.m_drawingSurfaceInfo != 0L) {
            new IllegalStateException("Already locked").printStackTrace();
            return;
        }
        this.m_drawingSurface = this.getDrawingSurface(this.m_area);
        if (this.m_drawingSurface == 0L) {
            new IllegalStateException("Can't get drawing surface").printStackTrace();
            return;
        }
        if (!this.lockDrawingSurface(this.m_drawingSurface)) {
            new IllegalStateException("Can't lock drawing surface").printStackTrace();
            return;
        }
        this.m_drawingSurfaceInfo = this.getDrawingSurfaceInfo(this.m_drawingSurface);
        if (this.m_drawingSurfaceInfo == 0L) {
            new IllegalStateException("Can't get drawing surface info").printStackTrace();
            return;
        }
    }

    public void unlock() {
        --this.lockCount;
        if (this.lockCount > 0) {
            return;
        }
        if (this.m_drawingSurface == 0L || this.m_drawingSurfaceInfo == 0L) {
            new IllegalStateException("Nothing to unlock").printStackTrace();
            return;
        }
        this.freeDrawingSurfaceInfo(this.m_drawingSurface, this.m_drawingSurfaceInfo);
        this.m_drawingSurfaceInfo = 0L;
        this.unlockDrawingSurface(this.m_drawingSurface);
        this.freeDrawingSurface(this.m_drawingSurface);
        this.m_drawingSurface = 0L;
    }

    protected long retrieveDisplay() {
        this.lock();
        long l = this.getDisplayNative(this.m_drawingSurfaceInfo);
        this.unlock();
        if (l == 0L) {
            new RuntimeException().printStackTrace();
        }
        return l;
    }

    protected long retrieveWindow() {
        this.lock();
        long l = this.getWindowNative(this.m_drawingSurfaceInfo);
        this.unlock();
        if (l == 0L) {
            new RuntimeException().printStackTrace();
        }
        return l;
    }

    protected final long retrieveVisual() {
        if (this.m_area.getGLGraphicsConfig() == null) {
            return 0L;
        }
        return this.m_area.getGLGraphicsConfig().getVisualId();
    }

    public long getDisplay() {
        return this.m_display;
    }

    public long getWindow() {
        return this.m_window;
    }

    public long getGlContext() {
        return this.m_glContext;
    }

    public int getCacheContextId() {
        return this.m_cacheContextId;
    }

    public void updateWindowElement(SoAction soAction, SoGLRenderAction soGLRenderAction) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.updateWindowElementNative(soAction.getAddress(), soGLRenderAction.getAddress(), this.m_window, this.m_glContext, this.m_display);
    }

    private native void updateWindowElementNative(long var1, long var3, long var5, long var7, long var9);

    public void clearWindowElement(SoAction soAction) {
        this.clearWindowElementNative(soAction.getAddress());
    }

    private native void clearWindowElementNative(long var1);

    public abstract void glCreateContext();

    protected void initEnvGl() {
        this.m_display = this.retrieveDisplay();
        this.m_window = this.retrieveWindow();
        this.m_visual = this.retrieveVisual();
    }

    public void glDestroyContext() {
        this.lock();
        if (this.m_glContext != 0L) {
            contextKeeper.removeContext(this.m_glContext);
            this.glDestroyNativeContext(this.m_glContext);
            this.m_glContext = 0L;
        }
        this.unlock();
    }

    protected abstract void glDestroyNativeContext(long var1);

    public boolean glIsDirect() {
        this.lock();
        boolean bl = this.glIsDirectNative(this.m_display, this.m_glContext);
        this.unlock();
        return bl;
    }

    public void glBindContext() {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.bindContextNative(this.m_glContext);
        this.unlock();
    }

    public void glUnbindContext() {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.unbindContextNative(this.m_glContext);
        this.unlock();
    }

    public void glSwapBuffers() {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        boolean bl = SwDrawingAreaPeer.glSwapBuffersNative(this.m_glContext);
        this.unlock();
        if (!bl) {
            new IllegalArgumentException().printStackTrace();
        }
    }

    public boolean glGetBooleanv(int n) {
        if (this.m_glContext == 0L) {
            return false;
        }
        this.lock();
        boolean bl = this.glGetBooleanvNative(n);
        this.unlock();
        return bl;
    }

    public void glBegin(long l) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glBeginNative(l);
        this.unlock();
    }

    public void glClear(int n) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glClearNative(n);
        this.unlock();
    }

    public void glClearColor(float f, float f2, float f3, float f4) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glClearColorNative(f, f2, f3, f4);
        this.unlock();
    }

    public void glClearIndex(float f) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glClearIndexNative(f);
        this.unlock();
    }

    public void glColor3ub(int n, int n2, int n3) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glColor3ubNative(n, n2, n3);
        this.unlock();
    }

    public void glColor3ubv(int[] nArray) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glColor3ubvNative(nArray);
        this.unlock();
    }

    public void glDepthRange(double d, double d2) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glDepthRangeNative(d, d2);
        this.unlock();
    }

    public void glDisable(int n) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glDisableNative(n);
        this.unlock();
    }

    public void glDrawBuffer(int n) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glDrawBufferNative(n);
        this.unlock();
    }

    public void glEnable(int n) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glEnableNative(n);
        this.unlock();
    }

    public void glEnd() {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glEndNative();
        this.unlock();
    }

    public void glFlush() {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glFlushNative();
        this.unlock();
    }

    public void glColorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glColorMaskNative(bl, bl2, bl3, bl4);
        this.unlock();
    }

    String glGetString(long l) {
        this.lock();
        String string = this.glGetStringNative(l);
        this.unlock();
        return string;
    }

    public void glHint(int n, int n2) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glHintNative(n, n2);
        this.unlock();
    }

    public boolean glIsEnabled(int n) {
        if (this.m_glContext == 0L) {
            return false;
        }
        this.lock();
        boolean bl = this.glIsEnabledNative(n);
        this.unlock();
        return bl;
    }

    public void glLineWidth(float f) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glLineWidthNative(f);
        this.unlock();
    }

    public void glLoadIdentity() {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glLoadIdentityNative();
        this.unlock();
    }

    public void glMatrixMode(long l) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glMatrixModeNative(l);
        this.unlock();
    }

    public void glOrtho(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glOrthoNative(d, d2, d3, d4, d5, d6);
        this.unlock();
    }

    public void glPopAttrib() {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glPopAttribNative();
        this.unlock();
    }

    public void glPopMatrix() {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glPopMatrixNative();
        this.unlock();
    }

    public void glPushAttrib(long l) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glPushAttribNative(l);
        this.unlock();
    }

    public void glPushMatrix() {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glPushMatrixNative();
        this.unlock();
    }

    public void glRasterPos2s(short s, short s2) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glRasterPos2sNative(s, s2);
        this.unlock();
    }

    public void glReadBuffer(int n) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glReadBufferNative(n);
        this.unlock();
    }

    public void glRotatef(float f, float f2, float f3, float f4) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glRotatefNative(f, f2, f3, f4);
        this.unlock();
    }

    public void glScalef(float f, float f2, float f3) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glScalefNative(f, f2, f3);
        this.unlock();
    }

    public void glTranslatef(float f, float f2, float f3) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glTranslatefNative(f, f2, f3);
        this.unlock();
    }

    public void glVertex2s(short s, short s2) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glVertex2sNative(s, s2);
        this.unlock();
    }

    public void glVertex3fv(float[] fArray) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glVertex3fvNative(fArray);
        this.unlock();
    }

    public void glViewport(int n, int n2, int n3, int n4) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.glViewportNative(n, n2, n3, n4);
        this.unlock();
    }

    public void gluDeleteQuadric(long l) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.gluDeleteQuadricNative(l);
        this.unlock();
    }

    public void gluDisk(long l, double d, double d2, int n, int n2) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.gluDiskNative(l, d, d2, n, n2);
        this.unlock();
    }

    public long gluNewQuadric() {
        if (this.m_glContext == 0L) {
            return 0L;
        }
        this.lock();
        long l = this.gluNewQuadricNative();
        this.unlock();
        return l;
    }

    public void gluPartialDisk(long l, double d, double d2, int n, int n2, double d3, double d4) {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.gluPartialDiskNative(l, d, d2, n, n2, d3, d4);
        this.unlock();
    }

    public void bindNormalContext() {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.bindContextNative(this.getGlContext());
        this.unlock();
    }

    public void unbindNormalContext() {
        if (this.m_glContext == 0L) {
            return;
        }
        this.lock();
        this.unbindContextNative(this.getGlContext());
        this.unlock();
    }

    protected void finalize() throws Throwable {
        if (this.m_glContext != 0L) {
            this.glDestroyContext();
        }
    }

    private native long getDrawingSurface(Component var1);

    private native boolean lockDrawingSurface(long var1);

    protected abstract long getDrawingSurfaceInfo(long var1);

    private native void freeDrawingSurface(long var1);

    private native void unlockDrawingSurface(long var1);

    protected abstract void freeDrawingSurfaceInfo(long var1, long var3);

    protected abstract long getDisplayNative(long var1);

    protected abstract long getWindowNative(long var1);

    protected abstract boolean glIsDirectNative(long var1, long var3);

    protected native boolean glGetBooleanvNative(int var1);

    protected native void glBeginNative(long var1);

    protected native void glClearNative(int var1);

    protected native void glClearColorNative(float var1, float var2, float var3, float var4);

    protected native void glClearIndexNative(float var1);

    protected native void glColor3ubNative(int var1, int var2, int var3);

    protected native void glColor3ubvNative(int[] var1);

    protected native void glDepthRangeNative(double var1, double var3);

    protected native void glDisableNative(int var1);

    protected native void glDrawBufferNative(int var1);

    protected native void glEnableNative(int var1);

    protected native void glEndNative();

    protected native void glFlushNative();

    protected native void glColorMaskNative(boolean var1, boolean var2, boolean var3, boolean var4);

    protected native String glGetStringNative(long var1);

    protected native void glHintNative(int var1, int var2);

    protected native boolean glIsEnabledNative(int var1);

    protected native void glLineWidthNative(float var1);

    protected native void glLoadIdentityNative();

    protected native void glMatrixModeNative(long var1);

    protected native void glOrthoNative(double var1, double var3, double var5, double var7, double var9, double var11);

    protected native void glPopAttribNative();

    protected native void glPopMatrixNative();

    protected native void glPushAttribNative(long var1);

    protected native void glPushMatrixNative();

    protected native void glRasterPos2sNative(short var1, short var2);

    protected native void glReadBufferNative(int var1);

    protected native void glRotatefNative(float var1, float var2, float var3, float var4);

    protected native void glScalefNative(float var1, float var2, float var3);

    protected native void glTranslatefNative(float var1, float var2, float var3);

    protected native void glVertex2sNative(short var1, short var2);

    protected native void glVertex3fvNative(float[] var1);

    protected native void glViewportNative(int var1, int var2, int var3, int var4);

    protected native void gluDeleteQuadricNative(long var1);

    protected native void gluDiskNative(long var1, double var3, double var5, int var7, int var8);

    protected native long gluNewQuadricNative();

    protected native void gluPartialDiskNative(long var1, double var3, double var5, int var7, int var8, double var9, double var11);

    protected native void bindContextNative(long var1);

    protected native void unbindContextNative(long var1);

    protected static native boolean glSwapBuffersNative(long var0);
}

