/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.caches;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.RefCountedNativeResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SafeDisposable;
import com.openinventor.inventor.devices.SoDeviceContextSharedGroup;

public class SoBaseContextCache
extends Inventor
implements SafeDisposable {
    private static native void releaseImpl(long var0, long var2);

    private static native void setContextDependentImpl(long var0, boolean var2);

    private static native boolean isContextDependentImpl(long var0);

    protected SoBaseContextCache(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new RefCountedNativeResourceHandle(this, l, constructorCommand);
    }

    public void setContextDependent() {
        this.setContextDependent(true);
    }

    @Override
    public boolean isDisposable() {
        if (this.hasDispose()) {
            throw new IllegalStateException("Object already disposed.");
        }
        return this.getRefCount() == 1;
    }

    @Override
    public boolean dispose() {
        if (!this.isDisposable()) {
            throw new IllegalStateException("Object still referenced.");
        }
        this.internalDispose();
        return true;
    }

    public boolean isContextDependent() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoBaseContextCache.isContextDependentImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void release(SoDeviceContextSharedGroup soDeviceContextSharedGroup) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBaseContextCache.releaseImpl(this.getNativeResourceHandle(), soDeviceContextSharedGroup != null ? soDeviceContextSharedGroup.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setContextDependent(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBaseContextCache.setContextDependentImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

