/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.caches;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbXfBox3f;
import com.openinventor.inventor.caches.SoCache;
import com.openinventor.inventor.misc.SoState;

public class SoBoundingBoxCache
extends SoCache {
    private static native boolean hasLinesOrPointsImpl(long var0);

    private static native void getBoxImpl(long var0, float[] var2);

    private static native boolean hasScreenSpaceBoundingBoxesImpl(long var0);

    private static native boolean isCenterSetImpl(long var0);

    private static native void getCenterImpl(long var0, float[] var2);

    private static native void getProjectedBoxImpl(long var0, float[] var2);

    private static native long ctorImpl(long var0);

    private static long ctorImplSync(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoBoundingBoxCache.ctorImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setImpl(long var0, float[] var2, boolean var3, float[] var4);

    private static native void setHasLinesOrPointsImpl(long var0);

    private static native void setHasScreenSpaceBoundingBoxesImpl(long var0, boolean var2);

    protected SoBoundingBoxCache(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(SbXfBox3f sbXfBox3f, boolean bl, SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBoundingBoxCache.setImpl(this.getNativeResourceHandle(), sbXfBox3f != null ? sbXfBox3f.array : null, bl, sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void setHasScreenSpaceBoundingBoxes(SoState soState, boolean bl) {
        ObjectManager.globalLock.lock();
        try {
            SoBoundingBoxCache.setHasScreenSpaceBoundingBoxesImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoBoundingBoxCache(SoState soState) {
        this(Inventor.ConstructorCommand.CreateInstance, SoBoundingBoxCache.ctorImplSync(soState));
    }

    public SbVec3f getCenter() {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBoundingBoxCache.getCenterImpl(this.getNativeResourceHandle(), sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public SbBox3f getProjectedBox() {
        SbBox3f sbBox3f = new SbBox3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBoundingBoxCache.getProjectedBoxImpl(this.getNativeResourceHandle(), sbBox3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbBox3f;
    }

    public boolean hasLinesOrPoints() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoBoundingBoxCache.hasLinesOrPointsImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isCenterSet() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoBoundingBoxCache.isCenterSetImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void setHasLinesOrPoints(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            SoBoundingBoxCache.setHasLinesOrPointsImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SbXfBox3f getBox() {
        SbXfBox3f sbXfBox3f = new SbXfBox3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBoundingBoxCache.getBoxImpl(this.getNativeResourceHandle(), sbXfBox3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbXfBox3f;
    }

    public boolean hasScreenSpaceBoundingBoxes() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoBoundingBoxCache.hasScreenSpaceBoundingBoxesImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

