/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.caches;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.caches.SoBaseContextCache;
import com.openinventor.inventor.elements.SoElement;
import com.openinventor.inventor.misc.SoState;

public class SoCache
extends SoBaseContextCache {
    private static native long getInvalidElementImpl(long var0, long var2);

    private static native boolean isValidImpl1(long var0, long var2, boolean var4);

    private static native boolean isValidImpl(long var0, long var2);

    private static native long getCachedInvalidElementImpl(long var0, long var2);

    private static native void addIgnoredElementImpl(long var0, long var2);

    private static long ctorImplSync(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoCache.ctorImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native boolean isValidImpl2(long var0, long var2, long var4);

    private static native void addElementImpl(long var0, long var2);

    private static native long ctorImpl(long var0);

    private static native void invalidateImpl(long var0);

    private static native void addCacheDependencyImpl(long var0, long var2, long var4);

    protected SoCache(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public SoElement getInvalidElement(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoCache.getInvalidElementImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoElement getCachedInvalidElement(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoCache.getCachedInvalidElementImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addCacheDependency(SoState soState, SoCache soCache) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCache.addCacheDependencyImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soCache != null ? soCache.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isValid(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoCache.isValidImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(SoState soState, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl2 = SoCache.isValidImpl1(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
            return bl2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoCache(SoState soState) {
        this(Inventor.ConstructorCommand.CreateInstance, SoCache.ctorImplSync(soState));
    }

    public void addIgnoredElement(SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCache.addIgnoredElementImpl(this.getNativeResourceHandle(), soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void invalidate() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCache.invalidateImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addElement(SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCache.addElementImpl(this.getNativeResourceHandle(), soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(SoState soState, SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoCache.isValidImpl2(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

