/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.caches;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;

public class SoCpuBufferObjectCache
extends Inventor {
    private static native void resizeImpl(long var0, long var2);

    private static native long getSizeImpl(long var0);

    private static native void flushImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoCpuBufferObjectCache(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public long getSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoCpuBufferObjectCache.getSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void resize(long l) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCpuBufferObjectCache.resizeImpl(this.getNativeResourceHandle(), l);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void flush() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCpuBufferObjectCache.flushImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

