/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.caches;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.RefCountedNativeResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SafeDisposable;
import com.openinventor.inventor.oglobjects.SoGLDisplayList;

public class SoGLObjectCache
extends Inventor
implements SafeDisposable {
    private static native long ctorImpl(int var0, boolean var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long ctorImplSync(SoGLDisplayList.Types types, boolean bl, int n) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoGLObjectCache.ctorImpl(types.getValue(), bl, n);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected SoGLObjectCache(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new RefCountedNativeResourceHandle(this, l, constructorCommand);
    }

    @Override
    public boolean isDisposable() {
        if (this.hasDispose()) {
            throw new IllegalStateException("Object already disposed.");
        }
        return this.getRefCount() == 1;
    }

    @Override
    public boolean dispose() {
        if (!this.isDisposable()) {
            throw new IllegalStateException("Object still referenced.");
        }
        this.internalDispose();
        return true;
    }

    public SoGLObjectCache(SoGLDisplayList.Types types) {
        this(types, true, 1);
    }

    public SoGLObjectCache(SoGLDisplayList.Types types, boolean bl) {
        this(types, bl, 1);
    }

    public SoGLObjectCache(SoGLDisplayList.Types types, boolean bl, int n) {
        this(Inventor.ConstructorCommand.CreateInstance, SoGLObjectCache.ctorImplSync(types, bl, n));
    }
}

