/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.caches;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.caches.SoCache;
import com.openinventor.inventor.elements.SoGLLazyElement;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.oglobjects.SoGLDisplayList;

public class SoGLRenderCache
extends SoCache {
    private static native boolean closeImpl(long var0);

    private static native boolean isCompileAndExecuteImpl(long var0);

    private static native void setLazyBitsImpl(long var0, int var2, int var3, int var4);

    private static native void setCompileAndExecuteImpl(long var0, boolean var2);

    private static native long getLazyEltImpl(long var0);

    private static native boolean isListOpenedImpl(long var0);

    private static native void callImpl(long var0, long var2);

    private static native void openImpl(long var0, long var2);

    private static native void addNestedCacheImpl(long var0, long var2);

    protected SoGLRenderCache(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public SoGLLazyElement getLazyElt() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLLazyElement soGLLazyElement = ObjectManager.getManagedObjectFor(SoGLLazyElement.class, SoGLRenderCache.getLazyEltImpl(this.getNativeResourceHandle()));
            return soGLLazyElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addNestedCache(SoGLDisplayList soGLDisplayList) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderCache.addNestedCacheImpl(this.getNativeResourceHandle(), soGLDisplayList != null ? soGLDisplayList.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void open(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderCache.openImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void call(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderCache.callImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setCompileAndExecute(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderCache.setCompileAndExecuteImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isListOpened() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGLRenderCache.isListOpenedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLazyBits(int n, int n2, int n3) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderCache.setLazyBitsImpl(this.getNativeResourceHandle(), n, n2, n3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean close() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGLRenderCache.closeImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isCompileAndExecute() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGLRenderCache.isCompileAndExecuteImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

