/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.caches;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.caches.SoCache;
import com.openinventor.inventor.elements.SoNormalBindingElement;
import com.openinventor.inventor.misc.SoState;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class SoNormalCache
extends SoCache {
    private static native Object getDirectNormalsImpl(long var0);

    private static native void setImpl(long var0, int var2, Object[] var3, int var4);

    private static native int getNumImpl(long var0);

    private static native long getNormalsImpl(long var0);

    private static long ctorImplSync(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoNormalCache.ctorImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native int getNormalBindingImpl(long var0);

    private static native long ctorImpl(long var0);

    protected SoNormalCache(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SoNormalCache(SoState soState) {
        this(Inventor.ConstructorCommand.CreateInstance, SoNormalCache.ctorImplSync(soState));
    }

    public FloatBuffer getDirectNormals() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoNormalCache.getDirectNormalsImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public void set(SbVec3f[] sbVec3fArray, SoNormalBindingElement.Bindings bindings) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNormalCache.setImpl(this.getNativeResourceHandle(), sbVec3fArray != null ? sbVec3fArray.length : 0, sbVec3fArray, bindings.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNum() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoNormalCache.getNumImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoNormalBindingElement.Bindings getNormalBinding() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNormalBindingElement.Bindings bindings = IntegerValuedEnumHelper.fromIntValue(SoNormalBindingElement.Bindings.class, SoNormalCache.getNormalBindingImpl(this.getNativeResourceHandle()));
            return bindings;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3f[] getNormals() {
        long l = Inventor.ZeroHandle;
        this.acquireLock(ObjectManager.globalLock);
        try {
            l = SoNormalCache.getNormalsImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return SbVec3f.toArray(l, this.getNum());
    }
}

