/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.caches;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.caches.SoCache;
import com.openinventor.inventor.misc.SoState;

public class SoPrimitiveCountCache
extends SoCache {
    private static native void setCount3DTextAsTrianglesImpl(long var0, boolean var2);

    private static native void setImpl(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void getImpl(long var0, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6);

    private static native boolean contains3DTextImpl(long var0);

    private static native boolean was3DTextCountedAsTrianglesImpl(long var0);

    private static native void setIsApproximatedImpl(long var0);

    private static long ctorImplSync(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoPrimitiveCountCache.ctorImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl(long var0);

    private static native boolean isApproximateCountImpl(long var0);

    private static native void setContains3DTextImpl(long var0);

    protected SoPrimitiveCountCache(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public static void setContains3DText(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            SoPrimitiveCountCache.setContains3DTextImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void setIsApproximated(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            SoPrimitiveCountCache.setIsApproximatedImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public boolean was3DTextCountedAsTriangles() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoPrimitiveCountCache.was3DTextCountedAsTrianglesImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoPrimitiveCountCache(SoState soState) {
        this(Inventor.ConstructorCommand.CreateInstance, SoPrimitiveCountCache.ctorImplSync(soState));
    }

    public void setCount3DTextAsTriangles(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPrimitiveCountCache.setCount3DTextAsTrianglesImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean contains3DText() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoPrimitiveCountCache.contains3DTextImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] get() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPrimitiveCountCache.getImpl(this.getNativeResourceHandle(), nArray, nArray2, nArray3, nArray4, nArray5);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        int[] nArray6 = new int[]{nArray[0], nArray2[0], nArray3[0], nArray4[0], nArray5[0]};
        return nArray6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int n, int n2, int n3, int n4, int n5) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPrimitiveCountCache.setImpl(this.getNativeResourceHandle(), n, n2, n3, n4, n5);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isApproximateCount() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoPrimitiveCountCache.isApproximateCountImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

