/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.collision;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.nodes.SoTransform;
import com.openinventor.inventor.sensors.SoNodeSensor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SoCollisionManager
extends Inventor {
    private static Hashtable<Long, Filter> filtering = new Hashtable();
    private Vector<BBoxCollisionListener> bboxCollisionListeners = new Vector();
    private static Hashtable<Long, Vector<BBoxCollisionListener>> bboxCollisionListening = new Hashtable();
    private static Hashtable<Long, CollisionListener> callbackKeys2Listeners = new Hashtable();
    private Hashtable<CollisionListener, Vector<Long>> localListeners2CallbackKeys = new Hashtable();
    @Deprecated
    public static final int NEXT_PRIMITIVE = Resps.access$000();
    @Deprecated
    public static final int NEXT_SHAPE = Resps.access$100();
    @Deprecated
    public static final int ABORT = Resps.access$200();
    @Deprecated
    public static final int NONE = TransformChangeTypes.access$300();
    @Deprecated
    public static final int TRANSLATION = TransformChangeTypes.access$400();
    @Deprecated
    public static final int SCALE = TransformChangeTypes.access$500();
    @Deprecated
    public static final int ROTATION = TransformChangeTypes.access$600();
    @Deprecated
    public static final int ORIENTATION = TransformChangeTypes.access$700();
    @Deprecated
    public static final int CENTER = TransformChangeTypes.access$800();
    @Deprecated
    public static final int X_AXIS = Axis.access$900();
    @Deprecated
    public static final int Y_AXIS = Axis.access$1000();
    @Deprecated
    public static final int Z_AXIS = Axis.access$1100();
    @Deprecated
    public static final int BEGIN = Positions.access$1200();
    @Deprecated
    public static final int END = Positions.access$1300();

    public void setFilter(Filter filter) {
        if (filter != null) {
            Filter filter2 = filtering.put(new Long(this.getNativeResourceHandle()), filter);
            if (filter2 == null) {
                this.setFilterCallbackNative(this.getNativeResourceHandle());
            }
        } else {
            Filter filter3 = filtering.remove(new Long(this.getNativeResourceHandle()));
            if (filter3 != null) {
                this.unsetFilterCallbackNative(this.getNativeResourceHandle());
            }
        }
    }

    private static boolean notifyFilter(long l, long l2, long l3) {
        Filter filter = filtering.get(new Long(l));
        return filter.accept(ObjectManager.getManagedObjectFor(SoPath.class, l2), ObjectManager.getManagedObjectFor(SoPath.class, l3));
    }

    private native void setFilterCallbackNative(long var1);

    private native void unsetFilterCallbackNative(long var1);

    public void addBBoxCollisionListener(BBoxCollisionListener bBoxCollisionListener) {
        if (this.bboxCollisionListeners.isEmpty()) {
            bboxCollisionListening.put(this.getNativeResourceHandle(), this.bboxCollisionListeners);
            this.setBBoxCollisionCallbackNative(this.getNativeResourceHandle());
        }
        this.bboxCollisionListeners.add(bBoxCollisionListener);
    }

    public void removeBBoxCollisionListener(BBoxCollisionListener bBoxCollisionListener) {
        this.bboxCollisionListeners.remove(bBoxCollisionListener);
        if (this.bboxCollisionListeners.isEmpty()) {
            this.unsetBBoxCollisionCallbackNative(this.getNativeResourceHandle());
            bboxCollisionListening.remove(this.getNativeResourceHandle());
        }
    }

    private static void notifyBBoxCollisionListeners(long l, long l2, long l3) {
        Vector<BBoxCollisionListener> vector = bboxCollisionListening.get(new Long(l));
        for (int i = 0; i < vector.size(); ++i) {
            SoPath soPath = ObjectManager.getManagedObjectFor(SoPath.class, l2);
            SoPath soPath2 = ObjectManager.getManagedObjectFor(SoPath.class, l3);
            vector.get(i).bboxCollide(soPath, soPath2);
        }
    }

    private native void setBBoxCollisionCallbackNative(long var1);

    private native void unsetBBoxCollisionCallbackNative(long var1);

    public void addCollisionListener(CollisionListener collisionListener) {
        long l = this.addCollisionCallbackNative(this.getNativeResourceHandle());
        callbackKeys2Listeners.put(new Long(l), collisionListener);
        Vector<Long> vector = this.localListeners2CallbackKeys.get(collisionListener);
        if (vector == null) {
            vector = new Vector();
            this.localListeners2CallbackKeys.put(collisionListener, vector);
        }
        vector.add(new Long(l));
    }

    public void removeCollisionListener(CollisionListener collisionListener) {
        Vector<Long> vector = this.localListeners2CallbackKeys.get(collisionListener);
        if (vector != null && !vector.isEmpty()) {
            Long l = vector.remove(0);
            callbackKeys2Listeners.remove(l);
            this.removeCollisionCallbackNative(this.getNativeResourceHandle(), l);
        }
    }

    private void removeAllCollisionListeners() {
        Enumeration<Vector<Long>> enumeration = this.localListeners2CallbackKeys.elements();
        while (enumeration.hasMoreElements()) {
            Vector<Long> vector = enumeration.nextElement();
            for (int i = 0; i < vector.size(); ++i) {
                Long l = vector.get(i);
                callbackKeys2Listeners.remove(l);
                this.removeCollisionCallbackNative(this.getNativeResourceHandle(), l);
            }
        }
        this.localListeners2CallbackKeys.clear();
    }

    private static int notifyCollisionListeners(long l, long l2, SbVec3f[] sbVec3fArray, long l3, SbVec3f[] sbVec3fArray2) {
        CollidingPrimitive collidingPrimitive = null;
        CollidingPrimitive collidingPrimitive2 = null;
        if (l2 != 0L) {
            collidingPrimitive = new CollidingPrimitive(ObjectManager.getManagedObjectFor(SoPath.class, l2), sbVec3fArray);
        }
        if (l3 != 0L) {
            collidingPrimitive2 = new CollidingPrimitive(ObjectManager.getManagedObjectFor(SoPath.class, l3), sbVec3fArray2);
        }
        CollisionListener collisionListener = callbackKeys2Listeners.get(new Long(l));
        return collisionListener.collide(collidingPrimitive, collidingPrimitive2);
    }

    private native long addCollisionCallbackNative(long var1);

    private native void removeCollisionCallbackNative(long var1, long var3);

    protected void finalize() throws Throwable {
        this.unsetFilterCallbackNative(this.getNativeResourceHandle());
        filtering.remove(this.getNativeResourceHandle());
        this.unsetBBoxCollisionCallbackNative(this.getNativeResourceHandle());
        bboxCollisionListening.remove(new Long(this.getNativeResourceHandle()));
        this.removeAllCollisionListeners();
        super.finalize();
    }

    private static native boolean isActivatedImpl(long var0);

    private static native void setGluingImpl(long var0, boolean var2);

    private static native void activateImpl(long var0, boolean var2);

    private static native boolean isGluingImpl(long var0);

    private static native boolean isSceneBBoxOnlyImpl(long var0);

    private static native void setSceneImpl(long var0, long var2);

    private static native void setTransformImpl(long var0, long var2);

    private static native long getSceneImpl(long var0);

    private static native long getObjectImpl(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long ctorImplSync(SoPath soPath, SoGroup soGroup, SoTransform soTransform) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoCollisionManager.ctorImpl(soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, soGroup != null ? soGroup.getNativeResourceHandle() : Inventor.ZeroHandle, soTransform != null ? soTransform.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl(long var0, long var2, long var4);

    private static native void setObjectImpl(long var0, long var2);

    private static native boolean isObjectBBoxOnlyImpl(long var0);

    private static native void setObjectBBoxOnlyImpl(long var0, boolean var2);

    private static native void setSceneBBoxOnlyImpl(long var0, boolean var2);

    private static native long getTransformImpl(long var0);

    private static native int getGluingLevelImpl(long var0);

    private static native void setGluingLevelImpl(long var0, int var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoCollisionManager(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void setSceneBBoxOnly() {
        this.setSceneBBoxOnly(true);
    }

    public void setObjectBBoxOnly() {
        this.setObjectBBoxOnly(true);
    }

    public void activate() {
        this.activate(true);
    }

    public void setGluing() {
        this.setGluing(true);
    }

    public void setScene(SoGroup soGroup) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCollisionManager.setSceneImpl(this.getNativeResourceHandle(), soGroup != null ? soGroup.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoGroup getScene() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGroup soGroup = ObjectManager.getManagedObjectFor(SoGroup.class, SoCollisionManager.getSceneImpl(this.getNativeResourceHandle()));
            return soGroup;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setTransform(SoTransform soTransform) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCollisionManager.setTransformImpl(this.getNativeResourceHandle(), soTransform != null ? soTransform.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoCollisionManager(SoPath soPath, SoGroup soGroup, SoTransform soTransform) {
        this(Inventor.ConstructorCommand.CreateInstance, SoCollisionManager.ctorImplSync(soPath, soGroup, soTransform));
    }

    public void setObject(SoPath soPath) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCollisionManager.setObjectImpl(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoPath getObject() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPath soPath = ObjectManager.getManagedObjectFor(SoPath.class, SoCollisionManager.getObjectImpl(this.getNativeResourceHandle()));
            return soPath;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setGluing(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCollisionManager.setGluingImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isSceneBBoxOnly() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoCollisionManager.isSceneBBoxOnlyImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isGluing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoCollisionManager.isGluingImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isActivated() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoCollisionManager.isActivatedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void activate(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCollisionManager.activateImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSceneBBoxOnly(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCollisionManager.setSceneBBoxOnlyImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setGluingLevel(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCollisionManager.setGluingLevelImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoTransform getTransform() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTransform soTransform = ObjectManager.getManagedObjectFor(SoTransform.class, SoCollisionManager.getTransformImpl(this.getNativeResourceHandle()));
            return soTransform;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getGluingLevel() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoCollisionManager.getGluingLevelImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isObjectBBoxOnly() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoCollisionManager.isObjectBBoxOnlyImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setObjectBBoxOnly(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCollisionManager.setObjectBBoxOnlyImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static class CompListItem
    extends Inventor {
        private static native long ctorImpl();

        private static native void setValueImpl(long var0, long var2);

        private static native void toArrayImpl(long var0, long[] var2);

        protected CompListItem(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public CompListItem(CompListItem compListItem) {
            this();
            this.setValue(compListItem);
        }

        public void setValue(CompListItem compListItem) {
            CompListItem.setValueImpl(this.getNativeResourceHandle(), compListItem.getNativeResourceHandle());
        }

        public static CompListItem[] toArray(long l, long l2) {
            CompListItem[] compListItemArray = new CompListItem[(int)l2];
            long[] lArray = new long[(int)l2];
            int n = 0;
            while ((long)n < l2) {
                compListItemArray[n] = new CompListItem();
                lArray[n] = compListItemArray[n].getNativeResourceHandle();
                ++n;
            }
            CompListItem.toArrayImpl(l, lArray);
            return compListItemArray;
        }

        public CompListItem() {
            this(Inventor.ConstructorCommand.CreateInstance, CompListItem.ctorImpl());
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static class ManagerListItem
    extends Inventor {
        public final SoCollisionManager manager;
        public final ManagerListItem next;

        private static native long ctorImpl();

        private static native void setValueImpl(long var0, long var2);

        private static native long getNextFieldHandle(long var0);

        private static native void toArrayImpl(long var0, long[] var2);

        private static native long getManagerFieldHandle(long var0);

        protected ManagerListItem(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
            this.manager = ObjectManager.getManagedObjectFor(SoCollisionManager.class, ManagerListItem.getManagerFieldHandle(this.getNativeResourceHandle()));
            this.next = ObjectManager.getManagedObjectFor(ManagerListItem.class, ManagerListItem.getNextFieldHandle(this.getNativeResourceHandle()));
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public ManagerListItem(ManagerListItem managerListItem) {
            this();
            this.setValue(managerListItem);
        }

        public ManagerListItem() {
            this(Inventor.ConstructorCommand.CreateInstance, ManagerListItem.ctorImpl());
        }

        public static ManagerListItem[] toArray(long l, long l2) {
            ManagerListItem[] managerListItemArray = new ManagerListItem[(int)l2];
            long[] lArray = new long[(int)l2];
            int n = 0;
            while ((long)n < l2) {
                managerListItemArray[n] = new ManagerListItem();
                lArray[n] = managerListItemArray[n].getNativeResourceHandle();
                ++n;
            }
            ManagerListItem.toArrayImpl(l, lArray);
            return managerListItemArray;
        }

        public void setValue(ManagerListItem managerListItem) {
            ManagerListItem.setValueImpl(this.getNativeResourceHandle(), managerListItem.getNativeResourceHandle());
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static class PairTableItem
    extends Inventor {
        private static native long ctorImpl();

        private static native void setValueImpl(long var0, long var2);

        private static native void toArrayImpl(long var0, long[] var2);

        protected PairTableItem(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public PairTableItem(PairTableItem pairTableItem) {
            this();
            this.setValue(pairTableItem);
        }

        public void setValue(PairTableItem pairTableItem) {
            PairTableItem.setValueImpl(this.getNativeResourceHandle(), pairTableItem.getNativeResourceHandle());
        }

        public static PairTableItem[] toArray(long l, long l2) {
            PairTableItem[] pairTableItemArray = new PairTableItem[(int)l2];
            long[] lArray = new long[(int)l2];
            int n = 0;
            while ((long)n < l2) {
                pairTableItemArray[n] = new PairTableItem();
                lArray[n] = pairTableItemArray[n].getNativeResourceHandle();
                ++n;
            }
            PairTableItem.toArrayImpl(l, lArray);
            return pairTableItemArray;
        }

        public PairTableItem() {
            this(Inventor.ConstructorCommand.CreateInstance, PairTableItem.ctorImpl());
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static class SceneInformationItem
    extends Inventor {
        public final SoGroup root;
        public final SoNodeSensor sensor;
        public final ManagerListItem manager_list;
        public final ShapeBBoxInformationItem shape_bbox_information;
        public final PairTableItem pair_table;
        public final CompListItem comp_list;
        public final SceneInformationItem next;

        private static native long getComplistFieldHandle(long var0);

        private static native long getPairtableFieldHandle(long var0);

        private static native long getNextFieldHandle(long var0);

        private static native long ctorImpl();

        private static native void setValueImpl(long var0, long var2);

        private static native long getRootFieldHandle(long var0);

        private static native void toArrayImpl(long var0, long[] var2);

        private static native long getSensorFieldHandle(long var0);

        private static native long getShapebboxinformationFieldHandle(long var0);

        private static native long getManagerlistFieldHandle(long var0);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected SceneInformationItem(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
            this.root = ObjectManager.getManagedObjectFor(SoGroup.class, SceneInformationItem.getRootFieldHandle(this.getNativeResourceHandle()));
            this.sensor = ObjectManager.getManagedObjectFor(SoNodeSensor.class, SceneInformationItem.getSensorFieldHandle(this.getNativeResourceHandle()));
            this.manager_list = ObjectManager.getManagedObjectFor(ManagerListItem.class, SceneInformationItem.getManagerlistFieldHandle(this.getNativeResourceHandle()));
            this.shape_bbox_information = ObjectManager.getManagedObjectFor(ShapeBBoxInformationItem.class, SceneInformationItem.getShapebboxinformationFieldHandle(this.getNativeResourceHandle()));
            this.pair_table = ObjectManager.getManagedObjectFor(PairTableItem.class, SceneInformationItem.getPairtableFieldHandle(this.getNativeResourceHandle()));
            this.comp_list = ObjectManager.getManagedObjectFor(CompListItem.class, SceneInformationItem.getComplistFieldHandle(this.getNativeResourceHandle()));
            this.next = ObjectManager.getManagedObjectFor(SceneInformationItem.class, SceneInformationItem.getNextFieldHandle(this.getNativeResourceHandle()));
        }

        public SceneInformationItem(SceneInformationItem sceneInformationItem) {
            this();
            this.setValue(sceneInformationItem);
        }

        public SceneInformationItem() {
            this(Inventor.ConstructorCommand.CreateInstance, SceneInformationItem.ctorImpl());
        }

        public static SceneInformationItem[] toArray(long l, long l2) {
            SceneInformationItem[] sceneInformationItemArray = new SceneInformationItem[(int)l2];
            long[] lArray = new long[(int)l2];
            int n = 0;
            while ((long)n < l2) {
                sceneInformationItemArray[n] = new SceneInformationItem();
                lArray[n] = sceneInformationItemArray[n].getNativeResourceHandle();
                ++n;
            }
            SceneInformationItem.toArrayImpl(l, lArray);
            return sceneInformationItemArray;
        }

        public void setValue(SceneInformationItem sceneInformationItem) {
            SceneInformationItem.setValueImpl(this.getNativeResourceHandle(), sceneInformationItem.getNativeResourceHandle());
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static class ShapeBBoxInformationItem
    extends Inventor {
        public final SoPath path;

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl();

        private static native void toArrayImpl(long var0, long[] var2);

        private static native long getPathFieldHandle(long var0);

        protected ShapeBBoxInformationItem(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
            this.path = ObjectManager.getManagedObjectFor(SoPath.class, ShapeBBoxInformationItem.getPathFieldHandle(this.getNativeResourceHandle()));
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public ShapeBBoxInformationItem(ShapeBBoxInformationItem shapeBBoxInformationItem) {
            this();
            this.setValue(shapeBBoxInformationItem);
        }

        public ShapeBBoxInformationItem() {
            this(Inventor.ConstructorCommand.CreateInstance, ShapeBBoxInformationItem.ctorImpl());
        }

        public static ShapeBBoxInformationItem[] toArray(long l, long l2) {
            ShapeBBoxInformationItem[] shapeBBoxInformationItemArray = new ShapeBBoxInformationItem[(int)l2];
            long[] lArray = new long[(int)l2];
            int n = 0;
            while ((long)n < l2) {
                shapeBBoxInformationItemArray[n] = new ShapeBBoxInformationItem();
                lArray[n] = shapeBBoxInformationItemArray[n].getNativeResourceHandle();
                ++n;
            }
            ShapeBBoxInformationItem.toArrayImpl(l, lArray);
            return shapeBBoxInformationItemArray;
        }

        public void setValue(ShapeBBoxInformationItem shapeBBoxInformationItem) {
            ShapeBBoxInformationItem.setValueImpl(this.getNativeResourceHandle(), shapeBBoxInformationItem.getNativeResourceHandle());
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static enum Positions implements IntegerValuedEnum
    {
        BEGIN(Positions.getBEGIN()),
        END(Positions.getEND());

        private int value;

        private Positions(int n2) {
            this.value = n2;
        }

        private static native int getEND();

        private static native int getBEGIN();

        @Deprecated
        public static Positions fromValue(int n) {
            return Positions.valueOf(n);
        }

        public static Positions valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Positions.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$1200() {
            return Positions.getBEGIN();
        }

        static /* synthetic */ int access$1300() {
            return Positions.getEND();
        }
    }

    public static enum Axis implements IntegerValuedEnum
    {
        X_AXIS(Axis.getXAXIS()),
        Y_AXIS(Axis.getYAXIS()),
        Z_AXIS(Axis.getZAXIS());

        private int value;

        private static native int getZAXIS();

        private Axis(int n2) {
            this.value = n2;
        }

        private static native int getXAXIS();

        private static native int getYAXIS();

        @Deprecated
        public static Axis fromValue(int n) {
            return Axis.valueOf(n);
        }

        public static Axis valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Axis.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$900() {
            return Axis.getXAXIS();
        }

        static /* synthetic */ int access$1000() {
            return Axis.getYAXIS();
        }

        static /* synthetic */ int access$1100() {
            return Axis.getZAXIS();
        }
    }

    public static enum TransformChangeTypes implements IntegerValuedEnum
    {
        NONE(TransformChangeTypes.getNONE()),
        TRANSLATION(TransformChangeTypes.getTRANSLATION()),
        SCALE(TransformChangeTypes.getSCALE()),
        ROTATION(TransformChangeTypes.getROTATION()),
        ORIENTATION(TransformChangeTypes.getORIENTATION()),
        CENTER(TransformChangeTypes.getCENTER());

        private int value;

        private static native int getORIENTATION();

        private static native int getCENTER();

        private TransformChangeTypes(int n2) {
            this.value = n2;
        }

        private static native int getROTATION();

        private static native int getNONE();

        private static native int getTRANSLATION();

        private static native int getSCALE();

        @Deprecated
        public static TransformChangeTypes fromValue(int n) {
            return TransformChangeTypes.valueOf(n);
        }

        public static TransformChangeTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(TransformChangeTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$300() {
            return TransformChangeTypes.getNONE();
        }

        static /* synthetic */ int access$400() {
            return TransformChangeTypes.getTRANSLATION();
        }

        static /* synthetic */ int access$500() {
            return TransformChangeTypes.getSCALE();
        }

        static /* synthetic */ int access$600() {
            return TransformChangeTypes.getROTATION();
        }

        static /* synthetic */ int access$700() {
            return TransformChangeTypes.getORIENTATION();
        }

        static /* synthetic */ int access$800() {
            return TransformChangeTypes.getCENTER();
        }
    }

    public static enum Resps implements IntegerValuedEnum
    {
        NEXT_PRIMITIVE(Resps.getNEXTPRIMITIVE()),
        NEXT_SHAPE(Resps.getNEXTSHAPE()),
        ABORT(Resps.getABORT());

        private int value;

        private static native int getABORT();

        private Resps(int n2) {
            this.value = n2;
        }

        private static native int getNEXTPRIMITIVE();

        private static native int getNEXTSHAPE();

        @Deprecated
        public static Resps fromValue(int n) {
            return Resps.valueOf(n);
        }

        public static Resps valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Resps.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return Resps.getNEXTPRIMITIVE();
        }

        static /* synthetic */ int access$100() {
            return Resps.getNEXTSHAPE();
        }

        static /* synthetic */ int access$200() {
            return Resps.getABORT();
        }
    }

    public static interface CollisionListener {
        public static final int NEXT_PRIMITIVE = 0;
        public static final int NEXT_SHAPE = 1;
        public static final int ABORT = 2;

        public int collide(CollidingPrimitive var1, CollidingPrimitive var2);
    }

    public static class CollidingPrimitive {
        public SoPath path;
        public SbVec3f[] vertices;

        public CollidingPrimitive(SoPath soPath, SbVec3f[] sbVec3fArray) {
            this.path = soPath;
            this.vertices = sbVec3fArray;
        }
    }

    public static interface BBoxCollisionListener {
        public void bboxCollide(SoPath var1, SoPath var2);
    }

    public static interface Filter {
        public boolean accept(SoPath var1, SoPath var2);
    }
}

