/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.collision;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.nodes.SoTransform;

public class SoDualSceneCollider
extends Inventor {
    private static native void setStaticSceneImpl(long var0, long var2, int var4);

    private static native void setMinEdgeLengthImpl(long var0, double var2);

    private static native void activateImpl(long var0, long var2);

    private static native double getMinEdgeLengthImpl(long var0);

    private static native void setMovingSceneImpl(long var0, long var2, int var4);

    private static native boolean isMultiThreadEnabledImpl(long var0);

    private static native void enableMultiThreadImpl(long var0, boolean var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoDualSceneCollider(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void setStaticScene(SoPath soPath) {
        this.setStaticScene(soPath, 0);
    }

    public void setMovingScene(SoPath soPath) {
        this.setMovingScene(soPath, 0);
    }

    public double getMinEdgeLength() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            double d = SoDualSceneCollider.getMinEdgeLengthImpl(this.getNativeResourceHandle());
            return d;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void enableMultiThread(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDualSceneCollider.enableMultiThreadImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isMultiThreadEnabled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDualSceneCollider.isMultiThreadEnabledImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setMinEdgeLength(double d) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDualSceneCollider.setMinEdgeLengthImpl(this.getNativeResourceHandle(), d);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void activate(SoTransform soTransform) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDualSceneCollider.activateImpl(this.getNativeResourceHandle(), soTransform != null ? soTransform.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setMovingScene(SoPath soPath, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDualSceneCollider.setMovingSceneImpl(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setStaticScene(SoPath soPath, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDualSceneCollider.setStaticSceneImpl(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

