/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.devices;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.devices.SoDeviceContextSharedGroup;

public class SoBaseContextObject
extends Inventor {
    private static long ctorImplSync(SoDeviceContextSharedGroup soDeviceContextSharedGroup) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoBaseContextObject.ctorImpl(soDeviceContextSharedGroup != null ? soDeviceContextSharedGroup.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void releaseImpl(long var0);

    private static native long ctorImpl(long var0);

    private static native long getContextSharedGroupImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoBaseContextObject(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SoBaseContextObject(SoDeviceContextSharedGroup soDeviceContextSharedGroup) {
        this(Inventor.ConstructorCommand.CreateInstance, SoBaseContextObject.ctorImplSync(soDeviceContextSharedGroup));
    }

    public void release() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBaseContextObject.releaseImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoDeviceContextSharedGroup getContextSharedGroup() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDeviceContextSharedGroup soDeviceContextSharedGroup = ObjectManager.getManagedObjectFor(SoDeviceContextSharedGroup.class, SoBaseContextObject.getContextSharedGroupImpl(this.getNativeResourceHandle()));
            return soDeviceContextSharedGroup;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

