/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.devices;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.devices.SoDevice;

public class SoCpuDevice
extends SoDevice {
    @Deprecated
    public static final int X86_64 = ProcessorArchitectures.access$000();
    @Deprecated
    public static final int X86_32 = ProcessorArchitectures.access$100();
    @Deprecated
    public static final int IA64 = ProcessorArchitectures.access$200();
    @Deprecated
    public static final int PPC_32 = ProcessorArchitectures.access$300();
    @Deprecated
    public static final int PPC_64 = ProcessorArchitectures.access$400();
    @Deprecated
    public static final int UNKNOWN = ProcessorArchitectures.access$500();

    private static native long findFirstAvailableDeviceImpl();

    private static native boolean hasMMXImpl(long var0);

    private static native boolean isActiveImpl(long var0);

    private static native boolean hasSSEImpl(long var0);

    private static native long getDeviceImpl(int var0);

    private static native int getSSELevelImpl(long var0);

    private static native int getDevicesCountImpl();

    private static native int getCacheSizeImpl(long var0, int var2);

    private static native int getArchitectureImpl(long var0);

    protected SoCpuDevice(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public static SoCpuDevice getDevice() {
        return SoCpuDevice.getDevice(0);
    }

    public int getSSELevel() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoCpuDevice.getSSELevelImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static int getDevicesCount() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoCpuDevice.getDevicesCountImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public int getCacheSize(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoCpuDevice.getCacheSizeImpl(this.getNativeResourceHandle(), n);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoCpuDevice getDevice(int n) {
        ObjectManager.globalLock.lock();
        try {
            SoCpuDevice soCpuDevice = ObjectManager.getManagedObjectFor(SoCpuDevice.class, SoCpuDevice.getDeviceImpl(n));
            return soCpuDevice;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static SoCpuDevice findFirstAvailableDevice() {
        ObjectManager.globalLock.lock();
        try {
            SoCpuDevice soCpuDevice = ObjectManager.getManagedObjectFor(SoCpuDevice.class, SoCpuDevice.findFirstAvailableDeviceImpl());
            return soCpuDevice;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public boolean hasSSE() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoCpuDevice.hasSSEImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean hasMMX() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoCpuDevice.hasMMXImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ProcessorArchitectures getArchitecture() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ProcessorArchitectures processorArchitectures = IntegerValuedEnumHelper.fromIntValue(ProcessorArchitectures.class, SoCpuDevice.getArchitectureImpl(this.getNativeResourceHandle()));
            return processorArchitectures;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isActive() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoCpuDevice.isActiveImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static enum ProcessorArchitectures implements IntegerValuedEnum
    {
        X86_64(ProcessorArchitectures.getX8664()),
        X86_32(ProcessorArchitectures.getX8632()),
        IA64(ProcessorArchitectures.getIA64()),
        PPC_32(ProcessorArchitectures.getPPC32()),
        PPC_64(ProcessorArchitectures.getPPC64()),
        UNKNOWN(ProcessorArchitectures.getUNKNOWN());

        private int value;

        private static native int getPPC64();

        private static native int getUNKNOWN();

        private ProcessorArchitectures(int n2) {
            this.value = n2;
        }

        private static native int getPPC32();

        private static native int getX8664();

        private static native int getX8632();

        private static native int getIA64();

        @Deprecated
        public static ProcessorArchitectures fromValue(int n) {
            return ProcessorArchitectures.valueOf(n);
        }

        public static ProcessorArchitectures valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ProcessorArchitectures.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return ProcessorArchitectures.getX8664();
        }

        static /* synthetic */ int access$100() {
            return ProcessorArchitectures.getX8632();
        }

        static /* synthetic */ int access$200() {
            return ProcessorArchitectures.getIA64();
        }

        static /* synthetic */ int access$300() {
            return ProcessorArchitectures.getPPC32();
        }

        static /* synthetic */ int access$400() {
            return ProcessorArchitectures.getPPC64();
        }

        static /* synthetic */ int access$500() {
            return ProcessorArchitectures.getUNKNOWN();
        }
    }
}

