/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.devices;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;

public class SoDevice
extends Inventor {
    private static native String getDeviceNameImpl(long var0);

    private static native long getDeviceImpl(int var0);

    private static native int getLogicalUnitsImpl(long var0);

    private static native String getDriverVersionImpl(long var0);

    private static native int getDevicesCountImpl();

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoDevice(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public static int getDevicesCount() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoDevice.getDevicesCountImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public String getDeviceName() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoDevice.getDeviceNameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getDriverVersion() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoDevice.getDriverVersionImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getLogicalUnits() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDevice.getLogicalUnitsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoDevice getDevice(int n) {
        ObjectManager.globalLock.lock();
        try {
            SoDevice soDevice = ObjectManager.getManagedObjectFor(SoDevice.class, SoDevice.getDeviceImpl(n));
            return soDevice;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

