/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.devices;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.RefCountedNativeResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SafeDisposable;
import com.openinventor.inventor.devices.SoDeviceContextSharedGroup;

public class SoDeviceContext
extends Inventor
implements SafeDisposable {
    private SoDeviceContext m_sourceCtx_setSharedWith;
    private SoDeviceContextSharedGroup m_sharedGroup_setSharedGroup;

    private static native boolean isCurrentImpl(long var0);

    private static native boolean setSharedGroupImpl(long var0, long var2);

    private static native boolean isCompatibleImpl(long var0, long var2);

    private static native boolean isSharableImpl(long var0);

    private static native void setSharableImpl(long var0, boolean var2);

    private static native boolean setSharedWithImpl(long var0, long var2);

    private static native void bindImpl(long var0);

    private static native int getSharedIdImpl(long var0);

    private static native long getSharedGroupImpl(long var0);

    private static native boolean isSharedWithImpl(long var0, long var2);

    private static native void unbindImpl(long var0);

    protected SoDeviceContext(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new RefCountedNativeResourceHandle(this, l, constructorCommand);
    }

    @Override
    public boolean isDisposable() {
        if (this.hasDispose()) {
            throw new IllegalStateException("Object already disposed.");
        }
        return this.getRefCount() == 1;
    }

    @Override
    public boolean dispose() {
        if (!this.isDisposable()) {
            throw new IllegalStateException("Object still referenced.");
        }
        this.internalDispose();
        return true;
    }

    public boolean isCurrent() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDeviceContext.isCurrentImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isCompatible(SoDeviceContext soDeviceContext) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDeviceContext.isCompatibleImpl(this.getNativeResourceHandle(), soDeviceContext != null ? soDeviceContext.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isSharedWith(SoDeviceContext soDeviceContext) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDeviceContext.isSharedWithImpl(this.getNativeResourceHandle(), soDeviceContext != null ? soDeviceContext.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void bind() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDeviceContext.bindImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void unbind() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDeviceContext.unbindImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSharable(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDeviceContext.setSharableImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getSharedId() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDeviceContext.getSharedIdImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoDeviceContextSharedGroup getSharedGroup() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDeviceContextSharedGroup soDeviceContextSharedGroup = ObjectManager.getManagedObjectFor(SoDeviceContextSharedGroup.class, SoDeviceContext.getSharedGroupImpl(this.getNativeResourceHandle()));
            return soDeviceContextSharedGroup;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean setSharedGroup(SoDeviceContextSharedGroup soDeviceContextSharedGroup) {
        this.m_sharedGroup_setSharedGroup = soDeviceContextSharedGroup;
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDeviceContext.setSharedGroupImpl(this.getNativeResourceHandle(), soDeviceContextSharedGroup != null ? soDeviceContextSharedGroup.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isSharable() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDeviceContext.isSharableImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean setSharedWith(SoDeviceContext soDeviceContext) {
        this.m_sourceCtx_setSharedWith = soDeviceContext;
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDeviceContext.setSharedWithImpl(this.getNativeResourceHandle(), soDeviceContext != null ? soDeviceContext.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

