/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.devices;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.devices.SoDevice;
import com.openinventor.inventor.devices.SoGLDeviceSettings;
import com.openinventor.inventor.devices.SoGLScreenDevice;

public class SoGLDevice
extends SoDevice {
    private static native int getScreenDevicesCountImpl(long var0);

    private static native long getMainScreenDeviceImpl(long var0);

    private static native long findFirstAvailableDeviceImpl();

    private static native long getDeviceImpl(int var0);

    private static native int getDevicesCountImpl();

    private static native long getDeviceSettingsImpl(long var0);

    private static native long getScreenDeviceImpl(long var0, int var2);

    protected SoGLDevice(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public int getScreenDevicesCount() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoGLDevice.getScreenDevicesCountImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static int getDevicesCount() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoGLDevice.getDevicesCountImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoGLScreenDevice getMainScreenDevice() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLScreenDevice soGLScreenDevice = ObjectManager.getManagedObjectFor(SoGLScreenDevice.class, SoGLDevice.getMainScreenDeviceImpl(this.getNativeResourceHandle()));
            return soGLScreenDevice;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoGLDeviceSettings getDeviceSettings() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLDeviceSettings soGLDeviceSettings = ObjectManager.getManagedObjectFor(SoGLDeviceSettings.class, SoGLDevice.getDeviceSettingsImpl(this.getNativeResourceHandle()));
            return soGLDeviceSettings;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoGLDevice getDevice(int n) {
        ObjectManager.globalLock.lock();
        try {
            SoGLDevice soGLDevice = ObjectManager.getManagedObjectFor(SoGLDevice.class, SoGLDevice.getDeviceImpl(n));
            return soGLDevice;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static SoGLDevice findFirstAvailableDevice() {
        ObjectManager.globalLock.lock();
        try {
            SoGLDevice soGLDevice = ObjectManager.getManagedObjectFor(SoGLDevice.class, SoGLDevice.findFirstAvailableDeviceImpl());
            return soGLDevice;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoGLScreenDevice getScreenDevice(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLScreenDevice soGLScreenDevice = ObjectManager.getManagedObjectFor(SoGLScreenDevice.class, SoGLDevice.getScreenDeviceImpl(this.getNativeResourceHandle(), n));
            return soGLScreenDevice;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

