/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.devices;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;

public class SoGLDeviceSettings
extends Inventor {
    private static native int getSettingsCountImpl(long var0);

    private static native String getParameterImpl(long var0, String var2);

    private static native String getSettingNameByIndexImpl(long var0, int var2);

    private static native String getSettingNameImpl(long var0);

    private static native boolean setSettingNameImpl(long var0, String var2);

    private static native boolean setParameterImpl(long var0, String var2, String var3);

    private static native String getParameterIdbyIndexImpl(long var0, int var2);

    private static native int getParameterCountImpl(long var0);

    private static native boolean applySettingsImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoGLDeviceSettings(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public int getParameterCount() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoGLDeviceSettings.getParameterCountImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean setSettingName(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGLDeviceSettings.setSettingNameImpl(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getParameterIdbyIndex(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoGLDeviceSettings.getParameterIdbyIndexImpl(this.getNativeResourceHandle(), n);
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setParameter(String string, String string2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGLDeviceSettings.setParameterImpl(this.getNativeResourceHandle(), string, string2);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getSettingsCount() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoGLDeviceSettings.getSettingsCountImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getSettingName() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoGLDeviceSettings.getSettingNameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean applySettings() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoGLDeviceSettings.applySettingsImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getParameter(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string2 = SoGLDeviceSettings.getParameterImpl(this.getNativeResourceHandle(), string);
            return string2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getSettingNameByIndex(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoGLDeviceSettings.getSettingNameByIndexImpl(this.getNativeResourceHandle(), n);
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

