/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.devices;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.devices.SoGLDevice;

public class SoGLScreenDevice
extends Inventor {
    private static native void getResolutionImpl(long var0, int[] var2);

    private static native void getPhysicalSizeImpl(long var0, float[] var2);

    private static native int getColorDepthImpl(long var0);

    private static native long getGLDeviceImpl(long var0);

    private static native String getNameImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoGLScreenDevice(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SbVec2i32 getResolution() {
        SbVec2i32 sbVec2i32 = new SbVec2i32();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLScreenDevice.getResolutionImpl(this.getNativeResourceHandle(), sbVec2i32.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2i32;
    }

    public SoGLDevice getGLDevice() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLDevice soGLDevice = ObjectManager.getManagedObjectFor(SoGLDevice.class, SoGLScreenDevice.getGLDeviceImpl(this.getNativeResourceHandle()));
            return soGLDevice;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getColorDepth() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoGLScreenDevice.getColorDepthImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec2f getPhysicalSize() {
        SbVec2f sbVec2f = new SbVec2f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLScreenDevice.getPhysicalSizeImpl(this.getNativeResourceHandle(), sbVec2f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2f;
    }

    public String getName() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoGLScreenDevice.getNameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

