/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.elements;

import com.openinventor.internal.ElementManager;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.elements.SoElement;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoNode;

public class SoAccumulatedElement
extends SoElement {
    protected static <E extends SoAccumulatedElement> E getElement(SoState soState, Class<E> clazz, SoNode soNode) {
        SoAccumulatedElement soAccumulatedElement = (SoAccumulatedElement)SoAccumulatedElement.getElement(soState, clazz);
        if (soAccumulatedElement != null) {
            soAccumulatedElement.addNodeId(soNode);
        }
        return (E)soAccumulatedElement;
    }

    private static native void addNodeIdImpl(long var0, long var2);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoAccumulatedElement.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long copyMatchInfoImpl(long var0);

    private static native void clearNodeIdsImpl(long var0);

    private static native void setNodeIdImpl(long var0, long var2);

    private static native int initCustomClass(long var0, Inventor var2, boolean var3, String var4, int var5);

    private static native void nativeDerivedClassInit();

    private static native void captureThisImpl(long var0, long var2);

    private static native void pushImpl(long var0, long var2);

    private static native boolean matchesImpl(long var0, long var2);

    private static native long ctorImpl();

    private static native int getClassStackIndexImpl();

    private static native void replaceNodeIdImpl(long var0, long var2, long var4);

    protected SoAccumulatedElement(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected SoAccumulatedElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Override
    protected boolean matches(SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoAccumulatedElement.matchesImpl(this.getNativeResourceHandle(), soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected void captureThis(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAccumulatedElement.captureThisImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void replaceNodeId(SoNode soNode, SoNode soNode2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAccumulatedElement.replaceNodeIdImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, soNode2 != null ? soNode2.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void setNodeId(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAccumulatedElement.setNodeIdImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected SoAccumulatedElement() {
        this(Inventor.ConstructorCommand.CreateFromInstance, SoAccumulatedElement.ctorImplSync());
        Class<?> clazz = this.getClass();
        int n = SoAccumulatedElement.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz), ElementManager.getSavedClassStackIndex(clazz));
        ElementManager.saveClassStackIndex(clazz, n);
    }

    protected void clearNodeIds() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAccumulatedElement.clearNodeIdsImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected SoElement copyMatchInfo() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoAccumulatedElement.copyMatchInfoImpl(this.getNativeResourceHandle()));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void addNodeId(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAccumulatedElement.addNodeIdImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void push(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAccumulatedElement.pushImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public static int getClassStackIndex() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoAccumulatedElement.getClassStackIndexImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    static {
        SoAccumulatedElement.nativeDerivedClassInit();
    }
}

