/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.elements;

import com.openinventor.internal.ElementManager;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.caches.SoCache;
import com.openinventor.inventor.elements.SoElement;
import com.openinventor.inventor.misc.SoState;

public class SoCacheElement
extends SoElement {
    private static native void closeAnyOpenImpl(long var0);

    private static native void invalidateImpl(long var0);

    private static native boolean anyOpenImpl(long var0);

    private static native long ctorImpl();

    private static native void initImpl(long var0, long var2);

    private static native long copyMatchInfoImpl(long var0);

    private static native boolean matchesImpl(long var0, long var2);

    private static native int initCustomClass(long var0, Inventor var2, boolean var3, String var4, int var5);

    private static native long getNextCacheElementImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoCacheElement.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void nativeDerivedClassInit();

    private static native int getClassStackIndexImpl();

    private static native long getCacheImpl(long var0);

    private static native void setImpl(long var0, long var2);

    private static native void popImpl(long var0, long var2, long var4);

    protected SoCacheElement(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected SoCacheElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Override
    protected boolean matches(SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoCacheElement.matchesImpl(this.getNativeResourceHandle(), soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected SoCacheElement() {
        this(Inventor.ConstructorCommand.CreateFromInstance, SoCacheElement.ctorImplSync());
        Class<?> clazz = this.getClass();
        int n = SoCacheElement.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz), ElementManager.getSavedClassStackIndex(clazz));
        ElementManager.saveClassStackIndex(clazz, n);
    }

    @Override
    protected void init(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCacheElement.initImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected SoElement copyMatchInfo() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoCacheElement.copyMatchInfoImpl(this.getNativeResourceHandle()));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void invalidate(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            SoCacheElement.invalidateImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public static int getClassStackIndex() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoCacheElement.getClassStackIndexImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void closeAnyOpen(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            SoCacheElement.closeAnyOpenImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void set(SoState soState, SoCache soCache) {
        ObjectManager.globalLock.lock();
        try {
            SoCacheElement.setImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soCache != null ? soCache.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoCacheElement getNextCacheElement() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCacheElement soCacheElement = ObjectManager.getManagedObjectFor(SoCacheElement.class, SoCacheElement.getNextCacheElementImpl(this.getNativeResourceHandle()));
            return soCacheElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void pop(SoState soState, SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCacheElement.popImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoCache getCache() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCache soCache = ObjectManager.getManagedObjectFor(SoCache.class, SoCacheElement.getCacheImpl(this.getNativeResourceHandle()));
            return soCache;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static boolean anyOpen(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoCacheElement.anyOpenImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    static {
        SoCacheElement.nativeDerivedClassInit();
    }
}

