/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.elements;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ElementManager;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.misc.SoState;

public abstract class SoElement
extends Inventor {
    public static <E extends SoElement> int getClassStackIndex(Class<E> clazz) {
        return ElementManager.getClassStackIndex(clazz);
    }

    protected static <E extends SoElement> E getElement(SoState soState, Class<E> clazz) {
        return (E)((SoElement)clazz.cast(SoElement.getElement(soState, clazz, SoElement.getClassStackIndex(clazz))));
    }

    protected static <E extends SoElement> E getConstElement(SoState soState, Class<E> clazz) {
        return (E)((SoElement)clazz.cast(SoElement.getConstElement(soState, clazz, SoElement.getClassStackIndex(clazz))));
    }

    private static native long getNextInStackImpl(long var0);

    private static native long insertAtDepthImpl(long var0, long var2, int var4);

    private static native long ctorImpl();

    private static native boolean matchesImpl(long var0, long var2);

    private static native long copyMatchInfoImpl(long var0);

    private static native long replaceElementImpl(long var0, long var2, long var4, long var6);

    private static native void captureThisImpl(long var0, long var2);

    private static native long getNextFreeImpl(long var0);

    private static native void setTypeIdImpl(long var0, String var2);

    private static native boolean isPoppedImpl(long var0);

    private static native void captureImpl(long var0, long var2);

    private static native void setPoppedImpl(long var0, boolean var2);

    private static native long getConstElementImpl(long var0, String var2, int var3);

    private static native void pushImpl(long var0, long var2);

    private static native void popImpl(long var0, long var2, long var4);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoElement.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void nativeDerivedClassInit();

    private static native int initCustomClass(long var0, Inventor var2, boolean var3, String var4, int var5);

    private static native int createStackIndexImpl(String var0);

    private static native long getElementImpl(long var0, String var2, int var3);

    private static native void initImpl(long var0, long var2);

    private static native long getElementImpl1(long var0, int var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    protected SoElement(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    static native String getClassTypeId();

    protected void setTypeId(Class<? extends Inventor> clazz) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement.setTypeIdImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    protected static SoElement getElement(SoState soState, int n) {
        ObjectManager.globalLock.lock();
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoElement.getElementImpl1(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, n));
            return soElement;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected void setPopped(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement.setPoppedImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void captureThis(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement.captureThisImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected SoElement getNextFree() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoElement.getNextFreeImpl(this.getNativeResourceHandle()));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected static int createStackIndex(Class<? extends Inventor> clazz) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            int n = SoElement.createStackIndexImpl(string);
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected boolean isPopped() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoElement.isPoppedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SoElement replaceElement(SoState soState, SoElement soElement, SoElement soElement2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement3 = ObjectManager.getManagedObjectFor(SoElement.class, SoElement.replaceElementImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle, soElement2 != null ? soElement2.getNativeResourceHandle() : Inventor.ZeroHandle));
            return soElement3;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected boolean matches(SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoElement.matchesImpl(this.getNativeResourceHandle(), soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected SoElement getNextInStack() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoElement.getNextInStackImpl(this.getNativeResourceHandle()));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SoElement getConstElement(SoState soState, Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoElement.getConstElementImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, string, n));
            return soElement;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected SoElement copyMatchInfo() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoElement.copyMatchInfoImpl(this.getNativeResourceHandle()));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void capture(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement.captureImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void init(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement.initImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SoElement getElement(SoState soState, Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoElement.getElementImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, string, n));
            return soElement;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected SoElement() {
        this(Inventor.ConstructorCommand.CreateFromInstance, SoElement.ctorImplSync());
        Class<?> clazz = this.getClass();
        int n = SoElement.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz), ElementManager.getSavedClassStackIndex(clazz));
        ElementManager.saveClassStackIndex(clazz, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SoElement insertAtDepth(SoElement soElement, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement2 = ObjectManager.getManagedObjectFor(SoElement.class, SoElement.insertAtDepthImpl(this.getNativeResourceHandle(), soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle, n));
            return soElement2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void pop(SoState soState, SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement.popImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void push(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement.pushImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    static {
        SoElement.nativeDerivedClassInit();
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

