/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.elements;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ElementManager;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.elements.SoElement;
import com.openinventor.inventor.elements.SoReplacedElement;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoNode;

public class SoEnvironmentElement
extends SoReplacedElement {
    @Deprecated
    public static final int NONE = FogTypes.access$000();
    @Deprecated
    public static final int HAZE = FogTypes.access$100();
    @Deprecated
    public static final int FOG = FogTypes.access$200();
    @Deprecated
    public static final int SMOKE = FogTypes.access$300();

    private static native void getImpl1(long var0, long var2);

    private static native boolean matchesImpl(long var0, long var2);

    private static native long copyMatchInfoImpl(long var0);

    private static native void setEltImpl(long var0, float var2, float[] var3, float[] var4, int var5, float[] var6, float var7);

    private static native void setImpl1(long var0, long var2, long var4);

    private static native long ctorImpl();

    private static native void getLightAttenuationImpl(long var0, float[] var2);

    private static native void getAmbientColorImpl(long var0, float[] var2);

    private static native float getAmbientIntensityImpl(long var0);

    private static native void initImpl(long var0, long var2);

    private static native void pushImpl(long var0, long var2);

    private static native int getClassStackIndexImpl();

    private static native int initCustomClass(long var0, Inventor var2, boolean var3, String var4, int var5);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoEnvironmentElement.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void nativeDerivedClassInit();

    private static native void setEltImpl1(long var0, long var2);

    private static native void setImpl(long var0, long var2, float var4, float[] var5, float[] var6, int var7, float[] var8, float var9);

    protected SoEnvironmentElement(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected SoEnvironmentElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    protected void setElt(EnvironmentParameters environmentParameters) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEnvironmentElement.setEltImpl1(this.getNativeResourceHandle(), environmentParameters != null ? environmentParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected SoEnvironmentElement() {
        this(Inventor.ConstructorCommand.CreateFromInstance, SoEnvironmentElement.ctorImplSync());
        Class<?> clazz = this.getClass();
        int n = SoEnvironmentElement.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz), ElementManager.getSavedClassStackIndex(clazz));
        ElementManager.saveClassStackIndex(clazz, n);
    }

    @Override
    protected SoElement copyMatchInfo() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoEnvironmentElement.copyMatchInfoImpl(this.getNativeResourceHandle()));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected boolean matches(SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoEnvironmentElement.matchesImpl(this.getNativeResourceHandle(), soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected void init(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEnvironmentElement.initImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setElt(float f, SbColor sbColor, SbVec3f sbVec3f, FogTypes fogTypes, SbColor sbColor2, float f2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEnvironmentElement.setEltImpl(this.getNativeResourceHandle(), f, sbColor != null ? sbColor.array : null, sbVec3f != null ? sbVec3f.array : null, fogTypes.getValue(), sbColor2 != null ? sbColor2.array : null, f2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static float getAmbientIntensity(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            float f = SoEnvironmentElement.getAmbientIntensityImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
            return f;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static SbVec3f getLightAttenuation(SoState soState) {
        SbVec3f sbVec3f = new SbVec3f();
        ObjectManager.globalLock.lock();
        try {
            SoEnvironmentElement.getLightAttenuationImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec3f.array);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return sbVec3f;
    }

    public static SbColor getAmbientColor(SoState soState) {
        SbColor sbColor = new SbColor();
        ObjectManager.globalLock.lock();
        try {
            SoEnvironmentElement.getAmbientColorImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, sbColor.array);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return sbColor;
    }

    public static EnvironmentParameters get(SoState soState) {
        EnvironmentParameters environmentParameters = new EnvironmentParameters();
        ObjectManager.globalLock.lock();
        try {
            SoEnvironmentElement.getImpl1(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, environmentParameters != null ? environmentParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return environmentParameters;
    }

    public static void set(SoState soState, SoNode soNode, EnvironmentParameters environmentParameters) {
        ObjectManager.globalLock.lock();
        try {
            SoEnvironmentElement.setImpl1(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, environmentParameters != null ? environmentParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public static int getClassStackIndex() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoEnvironmentElement.getClassStackIndexImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Override
    public void push(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEnvironmentElement.pushImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void set(SoState soState, SoNode soNode, float f, SbColor sbColor, SbVec3f sbVec3f, FogTypes fogTypes, SbColor sbColor2, float f2) {
        ObjectManager.globalLock.lock();
        try {
            SoEnvironmentElement.setImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, f, sbColor != null ? sbColor.array : null, sbVec3f != null ? sbVec3f.array : null, fogTypes.getValue(), sbColor2 != null ? sbColor2.array : null, f2);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    static {
        SoEnvironmentElement.nativeDerivedClassInit();
    }

    public static class EnvironmentParameters
    extends Inventor {
        public final SbColor ambientColor;
        public final SbVec3f attenuation;
        public final SbColor fogColor;

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl();

        private static native long ctorImpl1(float var0, float[] var1, float[] var2, int var3, float[] var4, float var5, float var6);

        private static native long getFogColorFieldHandle(long var0);

        private static native void toArrayImpl(long var0, long[] var2);

        private static native long getAmbientColorFieldHandle(long var0);

        private static native long getAttenuationFieldHandle(long var0);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected EnvironmentParameters(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
            this.ambientColor = ObjectManager.getBasicObjectFor(SbColor.class, EnvironmentParameters.getAmbientColorFieldHandle(this.getNativeResourceHandle()));
            this.attenuation = ObjectManager.getBasicObjectFor(SbVec3f.class, EnvironmentParameters.getAttenuationFieldHandle(this.getNativeResourceHandle()));
            this.fogColor = ObjectManager.getBasicObjectFor(SbColor.class, EnvironmentParameters.getFogColorFieldHandle(this.getNativeResourceHandle()));
        }

        public EnvironmentParameters(EnvironmentParameters environmentParameters) {
            this();
            this.setValue(environmentParameters);
        }

        public EnvironmentParameters(float f, SbColor sbColor, SbVec3f sbVec3f, FogTypes fogTypes, SbColor sbColor2, float f2, float f3) {
            this(Inventor.ConstructorCommand.CreateInstance, EnvironmentParameters.ctorImpl1(f, sbColor != null ? sbColor.array : null, sbVec3f != null ? sbVec3f.array : null, fogTypes.getValue(), sbColor2 != null ? sbColor2.array : null, f2, f3));
        }

        public static EnvironmentParameters[] toArray(long l, long l2) {
            EnvironmentParameters[] environmentParametersArray = new EnvironmentParameters[(int)l2];
            long[] lArray = new long[(int)l2];
            int n = 0;
            while ((long)n < l2) {
                environmentParametersArray[n] = new EnvironmentParameters();
                lArray[n] = environmentParametersArray[n].getNativeResourceHandle();
                ++n;
            }
            EnvironmentParameters.toArrayImpl(l, lArray);
            return environmentParametersArray;
        }

        public void setValue(EnvironmentParameters environmentParameters) {
            EnvironmentParameters.setValueImpl(this.getNativeResourceHandle(), environmentParameters.getNativeResourceHandle());
        }

        public EnvironmentParameters() {
            this(Inventor.ConstructorCommand.CreateInstance, EnvironmentParameters.ctorImpl());
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static enum FogTypes implements IntegerValuedEnum
    {
        NONE(FogTypes.getNONE()),
        HAZE(FogTypes.getHAZE()),
        FOG(FogTypes.getFOG()),
        SMOKE(FogTypes.getSMOKE());

        private int value;

        private static native int getSMOKE();

        private FogTypes(int n2) {
            this.value = n2;
        }

        private static native int getFOG();

        private static native int getNONE();

        private static native int getHAZE();

        @Deprecated
        public static FogTypes fromValue(int n) {
            return FogTypes.valueOf(n);
        }

        public static FogTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(FogTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return FogTypes.getNONE();
        }

        static /* synthetic */ int access$100() {
            return FogTypes.getHAZE();
        }

        static /* synthetic */ int access$200() {
            return FogTypes.getFOG();
        }

        static /* synthetic */ int access$300() {
            return FogTypes.getSMOKE();
        }
    }
}

