/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.elements;

import com.openinventor.internal.ElementManager;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.elements.SoElement;
import com.openinventor.inventor.elements.SoModelMatrixElement;
import com.openinventor.inventor.misc.SoState;

public class SoGLModelMatrixElement
extends SoModelMatrixElement {
    private static native void updateShaderStateMatrixImpl(long var0, long var2);

    private static native void setEltImpl(long var0, float[] var2, boolean var3);

    private static native void scaleEltByImpl(long var0, float[] var2);

    private static native void makeEltIdentityImpl(long var0);

    private static native void multEltImpl(long var0, float[] var2);

    private static native void rotateEltByImpl(long var0, float[] var2);

    private static native void pushMatrixEltImpl(long var0, float[] var2);

    private static native void translateEltByImpl(long var0, float[] var2);

    private static native void popMatrixEltImpl(long var0, float[] var2);

    private static native void initImpl(long var0, long var2);

    private static native int getClassStackIndexImpl();

    private static native int initCustomClass(long var0, Inventor var2, boolean var3, String var4, int var5);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoGLModelMatrixElement.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void nativeDerivedClassInit();

    private static native long ctorImpl();

    private static native void popImpl(long var0, long var2, long var4);

    private static native void pushImpl(long var0, long var2);

    @Override
    protected void setElt(SbMatrix sbMatrix) {
        this.setElt(sbMatrix, true);
    }

    protected SoGLModelMatrixElement(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected SoGLModelMatrixElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    protected SoGLModelMatrixElement() {
        this(Inventor.ConstructorCommand.CreateFromInstance, SoGLModelMatrixElement.ctorImplSync());
        Class<?> clazz = this.getClass();
        int n = SoGLModelMatrixElement.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz), ElementManager.getSavedClassStackIndex(clazz));
        ElementManager.saveClassStackIndex(clazz, n);
    }

    @Override
    protected SbMatrix pushMatrixElt() {
        SbMatrix sbMatrix = new SbMatrix();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLModelMatrixElement.pushMatrixEltImpl(this.getNativeResourceHandle(), sbMatrix.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbMatrix;
    }

    @Override
    protected void updateShaderStateMatrix(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLModelMatrixElement.updateShaderStateMatrixImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected void popMatrixElt(SbMatrix sbMatrix) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLModelMatrixElement.popMatrixEltImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected void multElt(SbMatrix sbMatrix) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLModelMatrixElement.multEltImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected void rotateEltBy(SbRotation sbRotation) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLModelMatrixElement.rotateEltByImpl(this.getNativeResourceHandle(), sbRotation != null ? sbRotation.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected void translateEltBy(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLModelMatrixElement.translateEltByImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected void init(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLModelMatrixElement.initImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected void scaleEltBy(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLModelMatrixElement.scaleEltByImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected void setElt(SbMatrix sbMatrix, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLModelMatrixElement.setEltImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null, bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected void makeEltIdentity() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLModelMatrixElement.makeEltIdentityImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void push(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLModelMatrixElement.pushImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void pop(SoState soState, SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLModelMatrixElement.popImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public static int getClassStackIndex() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoGLModelMatrixElement.getClassStackIndexImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    static {
        SoGLModelMatrixElement.nativeDerivedClassInit();
    }
}

