/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.elements;

import com.openinventor.internal.ElementManager;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.elements.SoElement;
import com.openinventor.inventor.misc.SoState;

public class SoInteractionElement
extends SoElement {
    private SoState m_state_setElt;

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoInteractionElement.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native boolean matchesImpl(long var0, long var2);

    private static native int getElapsedFramesImpl(long var0);

    private static native double getElapsedSecondsImpl(long var0);

    private static native long copyMatchInfoImpl(long var0);

    private static native int initCustomClass(long var0, Inventor var2, boolean var3, String var4, int var5);

    private static native void nativeDerivedClassInit();

    private static native void setEltImpl(long var0, long var2, boolean var4);

    private static native long ctorImpl();

    private static native int getClassStackIndexImpl();

    private static native boolean isInteractingImpl(long var0);

    private static native void setImpl(long var0, boolean var2);

    protected SoInteractionElement(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected SoInteractionElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Override
    protected SoElement copyMatchInfo() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoInteractionElement.copyMatchInfoImpl(this.getNativeResourceHandle()));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected SoInteractionElement() {
        this(Inventor.ConstructorCommand.CreateFromInstance, SoInteractionElement.ctorImplSync());
        Class<?> clazz = this.getClass();
        int n = SoInteractionElement.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz), ElementManager.getSavedClassStackIndex(clazz));
        ElementManager.saveClassStackIndex(clazz, n);
    }

    @Override
    protected boolean matches(SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoInteractionElement.matchesImpl(this.getNativeResourceHandle(), soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void setElt(SoState soState, boolean bl) {
        this.m_state_setElt = soState;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoInteractionElement.setEltImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static int getElapsedFrames(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            int n = SoInteractionElement.getElapsedFramesImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static double getElapsedSeconds(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            double d = SoInteractionElement.getElapsedSecondsImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
            return d;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static boolean isInteracting(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoInteractionElement.isInteractingImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void set(SoState soState, boolean bl) {
        ObjectManager.globalLock.lock();
        try {
            SoInteractionElement.setImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public static int getClassStackIndex() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoInteractionElement.getClassStackIndexImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    static {
        SoInteractionElement.nativeDerivedClassInit();
    }
}

