/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.elements;

import com.openinventor.internal.ElementManager;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.elements.SoAccumulatedElement;
import com.openinventor.inventor.elements.SoElement;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoLight;
import com.openinventor.inventor.nodes.SoNode;
import java.util.Vector;

public class SoLightElement
extends SoAccumulatedElement {
    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoLightElement.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void getMatrixImpl(long var0, int var2, float[] var3);

    private static native long ctorImpl();

    private static native int initCustomClass(long var0, Inventor var2, boolean var3, String var4, int var5);

    private static native void nativeDerivedClassInit();

    private static native void pushImpl(long var0, long var2);

    private static native void popImpl(long var0, long var2, long var4);

    private static native long[] getLightsImpl(long var0);

    private static native void initImpl(long var0, long var2);

    private static native void addImpl(long var0, long var2, float[] var4);

    private static native int getClassStackIndexImpl();

    protected SoLightElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    protected SoLightElement(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Override
    protected void init(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLightElement.initImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected SoLightElement() {
        this(Inventor.ConstructorCommand.CreateFromInstance, SoLightElement.ctorImplSync());
        Class<?> clazz = this.getClass();
        int n = SoLightElement.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz), ElementManager.getSavedClassStackIndex(clazz));
        ElementManager.saveClassStackIndex(clazz, n);
    }

    public static SbMatrix getMatrix(SoState soState, int n) {
        SbMatrix sbMatrix = new SbMatrix();
        ObjectManager.globalLock.lock();
        try {
            SoLightElement.getMatrixImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, n, sbMatrix.array);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return sbMatrix;
    }

    public static void add(SoState soState, SoLight soLight, SbMatrix sbMatrix) {
        ObjectManager.globalLock.lock();
        try {
            SoLightElement.addImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soLight != null ? soLight.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static Vector<SoNode> getLights(SoState soState) {
        Vector<SoNode> vector = null;
        ObjectManager.globalLock.lock();
        try {
            vector = SoLightElement.toVector(SoNode.class, SoLightElement.getLightsImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle));
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return vector;
    }

    @Override
    public void push(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLightElement.pushImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void pop(SoState soState, SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLightElement.popImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public static int getClassStackIndex() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoLightElement.getClassStackIndexImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    static {
        SoLightElement.nativeDerivedClassInit();
    }
}

