/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.elements;

import com.openinventor.internal.ElementManager;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.elements.SoAccumulatedElement;
import com.openinventor.inventor.elements.SoElement;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoNode;

public class SoModelMatrixElement
extends SoAccumulatedElement {
    private static native void setCullMatrixImpl(long var0, long var2, float[] var4);

    private static native void pushMatrixEltImpl(long var0, float[] var2);

    private static native void getCombinedCullMatrixImpl(long var0, float[] var2);

    private static native void scaleEltByImpl(long var0, float[] var2);

    private static native void pushMatrixImpl(long var0, float[] var2);

    private static native void initImpl(long var0, long var2);

    private static native void popMatrixImpl(long var0, float[] var2);

    private static native void popMatrixEltImpl(long var0, float[] var2);

    private static native void rotateEltByImpl(long var0, float[] var2);

    private static native void makeEltIdentityImpl(long var0);

    private static native void setEltImpl(long var0, float[] var2, boolean var3);

    private static native boolean matchesImpl(long var0, long var2);

    private static native long ctorImpl();

    private static native void translateEltByImpl(long var0, float[] var2);

    private static native void getImpl(long var0, float[] var2);

    private static native void multEltImpl(long var0, float[] var2);

    private static native void makeIdentityImpl(long var0, long var2);

    private static native int initCustomClass(long var0, Inventor var2, boolean var3, String var4, int var5);

    private static native void setImpl(long var0, long var2, float[] var4, boolean var5);

    private static native void pushImpl(long var0, long var2);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoModelMatrixElement.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long copyMatchInfoImpl(long var0);

    private static native int getClassStackIndexImpl();

    private static native void nativeDerivedClassInit();

    private static native void updateShaderStateMatrixImpl(long var0, long var2);

    private static native void rotateByImpl(long var0, long var2, float[] var4);

    private static native void scaleByImpl(long var0, long var2, float[] var4);

    private static native void translateByImpl(long var0, long var2, float[] var4);

    private static native void multImpl(long var0, long var2, float[] var4);

    protected void setElt(SbMatrix sbMatrix) {
        this.setElt(sbMatrix, true);
    }

    protected SoModelMatrixElement(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected SoModelMatrixElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public static void set(SoState soState, SoNode soNode, SbMatrix sbMatrix) {
        SoModelMatrixElement.set(soState, soNode, sbMatrix, true);
    }

    @Override
    protected boolean matches(SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoModelMatrixElement.matchesImpl(this.getNativeResourceHandle(), soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void updateShaderStateMatrix(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoModelMatrixElement.updateShaderStateMatrixImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void popMatrixElt(SbMatrix sbMatrix) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoModelMatrixElement.popMatrixEltImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void translateEltBy(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoModelMatrixElement.translateEltByImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void scaleEltBy(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoModelMatrixElement.scaleEltByImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void makeEltIdentity() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoModelMatrixElement.makeEltIdentityImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void multElt(SbMatrix sbMatrix) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoModelMatrixElement.multEltImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void setElt(SbMatrix sbMatrix, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoModelMatrixElement.setEltImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null, bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected void init(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoModelMatrixElement.initImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void rotateEltBy(SbRotation sbRotation) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoModelMatrixElement.rotateEltByImpl(this.getNativeResourceHandle(), sbRotation != null ? sbRotation.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected SoElement copyMatchInfo() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoModelMatrixElement.copyMatchInfoImpl(this.getNativeResourceHandle()));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected SoModelMatrixElement() {
        this(Inventor.ConstructorCommand.CreateFromInstance, SoModelMatrixElement.ctorImplSync());
        Class<?> clazz = this.getClass();
        int n = SoModelMatrixElement.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz), ElementManager.getSavedClassStackIndex(clazz));
        ElementManager.saveClassStackIndex(clazz, n);
    }

    protected SbMatrix pushMatrixElt() {
        SbMatrix sbMatrix = new SbMatrix();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoModelMatrixElement.pushMatrixEltImpl(this.getNativeResourceHandle(), sbMatrix.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbMatrix;
    }

    public static void scaleBy(SoState soState, SoNode soNode, SbVec3f sbVec3f) {
        ObjectManager.globalLock.lock();
        try {
            SoModelMatrixElement.scaleByImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public static int getClassStackIndex() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoModelMatrixElement.getClassStackIndexImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void makeIdentity(SoState soState, SoNode soNode) {
        ObjectManager.globalLock.lock();
        try {
            SoModelMatrixElement.makeIdentityImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void rotateBy(SoState soState, SoNode soNode, SbRotation sbRotation) {
        ObjectManager.globalLock.lock();
        try {
            SoModelMatrixElement.rotateByImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbRotation != null ? sbRotation.array : null);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void translateBy(SoState soState, SoNode soNode, SbVec3f sbVec3f) {
        ObjectManager.globalLock.lock();
        try {
            SoModelMatrixElement.translateByImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void setCullMatrix(SoState soState, SoNode soNode, SbMatrix sbMatrix) {
        ObjectManager.globalLock.lock();
        try {
            SoModelMatrixElement.setCullMatrixImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void popMatrix(SoState soState, SbMatrix sbMatrix) {
        ObjectManager.globalLock.lock();
        try {
            SoModelMatrixElement.popMatrixImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static SbMatrix pushMatrix(SoState soState) {
        SbMatrix sbMatrix = new SbMatrix();
        ObjectManager.globalLock.lock();
        try {
            SoModelMatrixElement.pushMatrixImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix.array);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return sbMatrix;
    }

    public static SbMatrix getCombinedCullMatrix(SoState soState) {
        SbMatrix sbMatrix = new SbMatrix();
        ObjectManager.globalLock.lock();
        try {
            SoModelMatrixElement.getCombinedCullMatrixImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix.array);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return sbMatrix;
    }

    public static SbMatrix get(SoState soState) {
        SbMatrix sbMatrix = new SbMatrix();
        ObjectManager.globalLock.lock();
        try {
            SoModelMatrixElement.getImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix.array);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return sbMatrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(SoState soState, SoNode soNode, SbMatrix sbMatrix, boolean bl) {
        ObjectManager.globalLock.lock();
        try {
            SoModelMatrixElement.setImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix != null ? sbMatrix.array : null, bl);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void mult(SoState soState, SoNode soNode, SbMatrix sbMatrix) {
        ObjectManager.globalLock.lock();
        try {
            SoModelMatrixElement.multImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Override
    public void push(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoModelMatrixElement.pushImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    static {
        SoModelMatrixElement.nativeDerivedClassInit();
    }
}

