/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.elements;

import com.openinventor.internal.ElementManager;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.elements.SoElement;
import com.openinventor.inventor.elements.SoReplacedElement;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoMultipleInstance;
import com.openinventor.inventor.nodes.SoNode;

public class SoMultipleInstanceElement
extends SoReplacedElement {
    private static native void initImpl(long var0, long var2);

    private static native int getNumInstanceImpl(long var0);

    private static native long copyMatchInfoImpl(long var0);

    private static native long getImpl(long var0);

    private static native int getNumBatchesImpl(long var0);

    private static native long getDefaultImpl();

    private static native long ctorImpl();

    private static native int initCustomClass(long var0, Inventor var2, boolean var3, String var4, int var5);

    private static native void nativeDerivedClassInit();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMultipleInstanceElement.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setImpl(long var0, long var2, long var4);

    private static native boolean matchesImpl(long var0, long var2);

    private static native int getClassStackIndexImpl();

    protected SoMultipleInstanceElement(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected SoMultipleInstanceElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Override
    protected boolean matches(SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoMultipleInstanceElement.matchesImpl(this.getNativeResourceHandle(), soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected SoMultipleInstanceElement() {
        this(Inventor.ConstructorCommand.CreateFromInstance, SoMultipleInstanceElement.ctorImplSync());
        Class<?> clazz = this.getClass();
        int n = SoMultipleInstanceElement.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz), ElementManager.getSavedClassStackIndex(clazz));
        ElementManager.saveClassStackIndex(clazz, n);
    }

    @Override
    protected void init(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMultipleInstanceElement.initImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected SoElement copyMatchInfo() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoMultipleInstanceElement.copyMatchInfoImpl(this.getNativeResourceHandle()));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoMultipleInstance get(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            SoMultipleInstance soMultipleInstance = ObjectManager.getManagedObjectFor(SoMultipleInstance.class, SoMultipleInstanceElement.getImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle));
            return soMultipleInstance;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static int getNumBatches(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            int n = SoMultipleInstanceElement.getNumBatchesImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void set(SoState soState, SoNode soNode, SoMultipleInstance soMultipleInstance) {
        ObjectManager.globalLock.lock();
        try {
            SoMultipleInstanceElement.setImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, soMultipleInstance != null ? soMultipleInstance.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static int getNumInstance(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            int n = SoMultipleInstanceElement.getNumInstanceImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static SoMultipleInstance getDefault() {
        ObjectManager.globalLock.lock();
        try {
            SoMultipleInstance soMultipleInstance = ObjectManager.getManagedObjectFor(SoMultipleInstance.class, SoMultipleInstanceElement.getDefaultImpl());
            return soMultipleInstance;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public static int getClassStackIndex() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoMultipleInstanceElement.getClassStackIndexImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    static {
        SoMultipleInstanceElement.nativeDerivedClassInit();
    }
}

