/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.engines;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoOutput;
import com.openinventor.inventor.engines.SoEngineOutput;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;

public class SoEngine
extends SoFieldContainer {
    private static native void inputChangedImpl(long var0, long var2);

    private static native boolean getOutputNameImpl(long var0, long var2, String[] var4);

    private static native void writeOutputTypesImpl(long var0, long var2);

    private static native long getOutputImpl(long var0, String var2);

    private static native void evaluateImpl(long var0);

    private static native long ctorImpl();

    private static native long copyImpl(long var0);

    private static native boolean readInstanceImpl(long var0, long var2, short var4);

    private static native void initCustomClass(long var0, Inventor var2, boolean var3, String var4);

    private static native void nativeDerivedClassInit();

    private static native long getByNameImpl(String var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoEngine.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected SoEngine(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected SoEngine(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    protected void inputChanged(SoField soField) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEngine.inputChangedImpl(this.getNativeResourceHandle(), soField != null ? soField.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void writeOutputTypes(SoOutput soOutput) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEngine.writeOutputTypesImpl(this.getNativeResourceHandle(), soOutput != null ? soOutput.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void evaluate() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEngine.evaluateImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean readInstance(SoInput soInput, short s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoEngine.readInstanceImpl(this.getNativeResourceHandle(), soInput != null ? soInput.getNativeResourceHandle() : Inventor.ZeroHandle, s);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected SoEngine() {
        this(Inventor.ConstructorCommand.CreateInstance, SoEngine.ctorImplSync());
        Class<?> clazz = this.getClass();
        SoEngine.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz));
    }

    public SoEngineOutput getOutput(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEngineOutput soEngineOutput = ObjectManager.getManagedObjectFor(SoEngineOutput.class, SoEngine.getOutputImpl(this.getNativeResourceHandle(), string));
            return soEngineOutput;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoEngine getByName(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoEngine soEngine = ObjectManager.getManagedObjectFor(SoEngine.class, SoEngine.getByNameImpl(string));
            return soEngine;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoEngine copy() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEngine soEngine = ObjectManager.getManagedObjectFor(SoEngine.class, SoEngine.copyImpl(this.getNativeResourceHandle()));
            return soEngine;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOutputName(SoEngineOutput soEngineOutput) {
        String[] stringArray = new String[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoEngine.getOutputNameImpl(this.getNativeResourceHandle(), soEngineOutput != null ? soEngineOutput.getNativeResourceHandle() : Inventor.ZeroHandle, stringArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return stringArray[0];
        }
        return null;
    }

    static {
        SoEngine.nativeDerivedClassInit();
    }
}

