/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.errors;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;

public class SoError
extends Inventor {
    private static Handler m_handler = null;
    private static boolean m_nativeCallbackInitialized = false;

    public static void setHandlerCallback(Handler handler) {
        m_handler = handler;
        if (!m_nativeCallbackInitialized) {
            SoError.initNativeCallback();
            m_nativeCallbackInitialized = true;
        }
    }

    private static native void initNativeCallback();

    private static void invoke(long l) {
        if (m_handler != null) {
            SoError soError = ObjectManager.getManagedObjectFor(SoError.class, l);
            m_handler.invoke(soError);
        }
    }

    private static native void postImpl(String var0);

    private static native String getDebugStringImpl(long var0);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoError.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoError(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public SoError() {
        this(Inventor.ConstructorCommand.CreateInstance, SoError.ctorImplSync());
    }

    public String getDebugString() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoError.getDebugStringImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void post(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoError.postImpl(string);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static interface Handler {
        public void invoke(SoError var1);
    }
}

