/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.events;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbLine;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;

public class SbTrackerInfo
extends Inventor {
    private static native void getOrientationImpl(long var0, float[] var2);

    private static native void setOrientationImpl3(long var0, float[] var2);

    private static native void getPosition3Impl(long var0, float[] var2);

    private static native void setOrientationImpl1(long var0, float[] var2);

    private static native void setOrientationImpl(long var0, float var2, float var3, float var4, float var5);

    private static native void setOrientationImpl2(long var0, float[] var2, float var3);

    private static native void setOrientationImpl4(long var0, float var2, float var3, float var4);

    private static native long ctorImpl();

    private static native void setValueImpl(long var0, long var2);

    private static native void toArrayImpl(long var0, long[] var2);

    private static native void getRayImpl(long var0, float[] var2);

    private static native void setPosition3Impl(long var0, float[] var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SbTrackerInfo(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SbTrackerInfo(SbTrackerInfo sbTrackerInfo) {
        this();
        this.setValue(sbTrackerInfo);
    }

    public void setOrientation(SbVec3f sbVec3f, float f) {
        SbTrackerInfo.setOrientationImpl2(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, f);
    }

    public static SbTrackerInfo[] toArray(long l, long l2) {
        SbTrackerInfo[] sbTrackerInfoArray = new SbTrackerInfo[(int)l2];
        long[] lArray = new long[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            sbTrackerInfoArray[n] = new SbTrackerInfo();
            lArray[n] = sbTrackerInfoArray[n].getNativeResourceHandle();
            ++n;
        }
        SbTrackerInfo.toArrayImpl(l, lArray);
        return sbTrackerInfoArray;
    }

    public SbTrackerInfo() {
        this(Inventor.ConstructorCommand.CreateInstance, SbTrackerInfo.ctorImpl());
    }

    public void setValue(SbTrackerInfo sbTrackerInfo) {
        SbTrackerInfo.setValueImpl(this.getNativeResourceHandle(), sbTrackerInfo.getNativeResourceHandle());
    }

    public void setOrientation(SbRotation sbRotation) {
        SbTrackerInfo.setOrientationImpl3(this.getNativeResourceHandle(), sbRotation != null ? sbRotation.array : null);
    }

    public SbRotation getOrientation() {
        SbRotation sbRotation = new SbRotation();
        SbTrackerInfo.getOrientationImpl(this.getNativeResourceHandle(), sbRotation.array);
        return sbRotation;
    }

    public void setOrientation(float[] fArray) {
        if (fArray.length != 4) {
            throw new IllegalArgumentException("Expected size is 4");
        }
        SbTrackerInfo.setOrientationImpl1(this.getNativeResourceHandle(), fArray);
    }

    public void setOrientation(float f, float f2, float f3, float f4) {
        SbTrackerInfo.setOrientationImpl(this.getNativeResourceHandle(), f, f2, f3, f4);
    }

    public SbLine getRay() {
        SbLine sbLine = new SbLine();
        SbTrackerInfo.getRayImpl(this.getNativeResourceHandle(), sbLine.array);
        return sbLine;
    }

    public void setPosition3(SbVec3f sbVec3f) {
        SbTrackerInfo.setPosition3Impl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
    }

    public void setOrientation(float f, float f2, float f3) {
        SbTrackerInfo.setOrientationImpl4(this.getNativeResourceHandle(), f, f2, f3);
    }

    public SbVec3f getPosition3() {
        SbVec3f sbVec3f = new SbVec3f();
        SbTrackerInfo.getPosition3Impl(this.getNativeResourceHandle(), sbVec3f.array);
        return sbVec3f;
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

