/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.events;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbLine;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.events.SbTrackerInfo;
import com.openinventor.inventor.events.SoButtonEvent;
import com.openinventor.inventor.events.SoEvent;

public class SoControllerButtonEvent
extends SoButtonEvent {
    @Deprecated
    public static final int ANY = Buttons.access$000();
    @Deprecated
    public static final int BUTTON1 = Buttons.access$100();
    @Deprecated
    public static final int BUTTON2 = Buttons.access$200();
    @Deprecated
    public static final int BUTTON3 = Buttons.access$300();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoControllerButtonEvent.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setOrientationImpl(long var0, float var2, float var3, float var4);

    private static native void setPosition3Impl(long var0, float[] var2);

    private static native void setButtonImpl(long var0, int var2);

    private static native int getButtonImpl(long var0);

    private static native void getRayImpl(long var0, float[] var2);

    private static native void trackerInfoImpl(long var0, long var2);

    private static native void getOrientationImpl(long var0, float[] var2);

    private static native void setOrientationImpl1(long var0, float[] var2);

    private static native void setOrientationImpl2(long var0, float[] var2, float var3);

    private static native void getPosition3Impl(long var0, float[] var2);

    private static native long ctorImpl();

    private static native boolean isButtonReleaseEventImpl(long var0, int var2);

    private static native boolean isButtonPressEventImpl(long var0, int var2);

    protected SoControllerButtonEvent(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public SbLine getRay() {
        SbLine sbLine = new SbLine();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoControllerButtonEvent.getRayImpl(this.getNativeResourceHandle(), sbLine.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbLine;
    }

    public SbTrackerInfo trackerInfo() {
        SbTrackerInfo sbTrackerInfo = new SbTrackerInfo();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoControllerButtonEvent.trackerInfoImpl(this.getNativeResourceHandle(), sbTrackerInfo.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbTrackerInfo;
    }

    public void setButton(Buttons buttons) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoControllerButtonEvent.setButtonImpl(this.getNativeResourceHandle(), buttons.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static boolean isButtonPressEvent(SoEvent soEvent, Buttons buttons) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoControllerButtonEvent.isButtonPressEventImpl(soEvent != null ? soEvent.getNativeResourceHandle() : Inventor.ZeroHandle, buttons.getValue());
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoControllerButtonEvent() {
        this(Inventor.ConstructorCommand.CreateInstance, SoControllerButtonEvent.ctorImplSync());
    }

    public SbVec3f getPosition3() {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoControllerButtonEvent.getPosition3Impl(this.getNativeResourceHandle(), sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public Buttons getButton() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Buttons buttons = IntegerValuedEnumHelper.fromIntValue(Buttons.class, SoControllerButtonEvent.getButtonImpl(this.getNativeResourceHandle()));
            return buttons;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setPosition3(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoControllerButtonEvent.setPosition3Impl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrientation(float f, float f2, float f3) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoControllerButtonEvent.setOrientationImpl(this.getNativeResourceHandle(), f, f2, f3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setOrientation(SbVec3f sbVec3f, float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoControllerButtonEvent.setOrientationImpl2(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbRotation getOrientation() {
        SbRotation sbRotation = new SbRotation();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoControllerButtonEvent.getOrientationImpl(this.getNativeResourceHandle(), sbRotation.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbRotation;
    }

    public void setOrientation(SbRotation sbRotation) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoControllerButtonEvent.setOrientationImpl1(this.getNativeResourceHandle(), sbRotation != null ? sbRotation.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static boolean isButtonReleaseEvent(SoEvent soEvent, Buttons buttons) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoControllerButtonEvent.isButtonReleaseEventImpl(soEvent != null ? soEvent.getNativeResourceHandle() : Inventor.ZeroHandle, buttons.getValue());
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static enum Buttons implements IntegerValuedEnum
    {
        ANY(Buttons.getANY()),
        BUTTON1(Buttons.getBUTTON1()),
        BUTTON2(Buttons.getBUTTON2()),
        BUTTON3(Buttons.getBUTTON3());

        private int value;

        private static native int getBUTTON3();

        private Buttons(int n2) {
            this.value = n2;
        }

        private static native int getBUTTON2();

        private static native int getANY();

        private static native int getBUTTON1();

        @Deprecated
        public static Buttons fromValue(int n) {
            return Buttons.valueOf(n);
        }

        public static Buttons valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Buttons.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return Buttons.getANY();
        }

        static /* synthetic */ int access$100() {
            return Buttons.getBUTTON1();
        }

        static /* synthetic */ int access$200() {
            return Buttons.getBUTTON2();
        }

        static /* synthetic */ int access$300() {
            return Buttons.getBUTTON3();
        }
    }
}

