/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.engines.SoEngineOutput;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.vrmlnodes.SoVRMLInterpOutput;

public abstract class SoField
extends Inventor {
    private static native boolean equalsImpl(long var0, long var2);

    private static native void disconnectImpl2(long var0, long var2);

    private static native int getNumConnectionsImpl(long var0);

    private static native void getImpl(long var0, String[] var2);

    private static native void touchImpl(long var0);

    private static native boolean getConnectedEngineImpl(long var0, long[] var2);

    private static native boolean appendConnectionImpl1(long var0, long var2);

    private static native boolean appendConnectionImpl2(long var0, long var2);

    private static native void disconnectImpl1(long var0, long var2);

    private static native void disconnectImpl(long var0, long var2);

    private static native boolean isConnectedFromEngineImpl(long var0);

    private static native long getContainerImpl(long var0);

    private static native boolean getConnectedVRMLInterpImpl(long var0, long[] var2);

    private static native boolean getConnectedFieldImpl(long var0, long[] var2);

    private static native boolean isConnectedFromFieldImpl(long var0);

    private static native void disconnectImpl3(long var0);

    private static native boolean isConnectedImpl(long var0);

    private static native boolean isConnectedFromVRMLInterpImpl(long var0);

    private static native boolean setImpl(long var0, String var2);

    private static native boolean isIgnoredImpl(long var0);

    private static native boolean connectFromImpl(long var0, long var2);

    private static native boolean isDefaultImpl(long var0);

    private static native void enableConnectionImpl(long var0, boolean var2);

    private static native void setIgnoredImpl(long var0, boolean var2);

    private static native boolean connectFromImpl2(long var0, long var2);

    private static native boolean appendConnectionImpl(long var0, long var2);

    private static native boolean isConnectionEnabledImpl(long var0);

    private static native boolean connectFromImpl1(long var0, long var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoField(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public boolean connectFrom(SoEngineOutput soEngineOutput) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.connectFromImpl(this.getNativeResourceHandle(), soEngineOutput != null ? soEngineOutput.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isConnectionEnabled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.isConnectionEnabledImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoFieldContainer getContainer() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoFieldContainer soFieldContainer = ObjectManager.getManagedObjectFor(SoFieldContainer.class, SoField.getContainerImpl(this.getNativeResourceHandle()));
            return soFieldContainer;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean set(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.setImpl(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isConnectedFromVRMLInterp() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.isConnectedFromVRMLInterpImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isConnectedFromEngine() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.isConnectedFromEngineImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoVRMLInterpOutput getConnectedVRMLInterp() {
        long[] lArray = new long[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoField.getConnectedVRMLInterpImpl(this.getNativeResourceHandle(), lArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return ObjectManager.getManagedObjectFor(SoVRMLInterpOutput.class, lArray[0]);
        }
        return null;
    }

    public boolean isConnectedFromField() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.isConnectedFromFieldImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoField getConnectedField() {
        long[] lArray = new long[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoField.getConnectedFieldImpl(this.getNativeResourceHandle(), lArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return ObjectManager.getManagedObjectFor(SoField.class, lArray[0]);
        }
        return null;
    }

    public SoEngineOutput getConnectedEngine() {
        long[] lArray = new long[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoField.getConnectedEngineImpl(this.getNativeResourceHandle(), lArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return ObjectManager.getManagedObjectFor(SoEngineOutput.class, lArray[0]);
        }
        return null;
    }

    public boolean isDefault() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.isDefaultImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void enableConnection(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoField.enableConnectionImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setIgnored(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoField.setIgnoredImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isIgnored() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.isIgnoredImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean appendConnection(SoVRMLInterpOutput soVRMLInterpOutput) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.appendConnectionImpl2(this.getNativeResourceHandle(), soVRMLInterpOutput != null ? soVRMLInterpOutput.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disconnect(SoEngineOutput soEngineOutput) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoField.disconnectImpl(this.getNativeResourceHandle(), soEngineOutput != null ? soEngineOutput.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disconnect(SoField soField) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoField.disconnectImpl1(this.getNativeResourceHandle(), soField != null ? soField.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean appendConnection(SoField soField) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.appendConnectionImpl1(this.getNativeResourceHandle(), soField != null ? soField.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean connectFrom(SoField soField) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.connectFromImpl1(this.getNativeResourceHandle(), soField != null ? soField.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean connectFrom(SoVRMLInterpOutput soVRMLInterpOutput) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.connectFromImpl2(this.getNativeResourceHandle(), soVRMLInterpOutput != null ? soVRMLInterpOutput.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean appendConnection(SoEngineOutput soEngineOutput) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.appendConnectionImpl(this.getNativeResourceHandle(), soEngineOutput != null ? soEngineOutput.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disconnect(SoVRMLInterpOutput soVRMLInterpOutput) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoField.disconnectImpl2(this.getNativeResourceHandle(), soVRMLInterpOutput != null ? soVRMLInterpOutput.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String get() {
        String[] stringArray = new String[1];
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoField.getImpl(this.getNativeResourceHandle(), stringArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return stringArray[0];
    }

    public boolean isConnected() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoField.isConnectedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disconnect() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoField.disconnectImpl3(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumConnections() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoField.getNumConnectionsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoField) {
            SoField soField = (SoField)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoField.equalsImpl(this.getNativeResourceHandle(), soField.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public void touch() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoField.touchImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static enum FieldTypes implements IntegerValuedEnum
    {
        EVENT_IN(1),
        EVENT_OUT(2),
        FIELD__EVENTIN(3),
        INTERNAL_FIELD(4),
        EXPOSED_FIELD(5);

        private int value;

        private FieldTypes(int n2) {
            this.value = n2;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static FieldTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(FieldTypes.class, n);
        }
    }
}

