/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.misc.SoBase;
import java.lang.reflect.Method;

public class SoFieldContainer
extends SoBase {
    @Override
    protected void preMortenClean() {
        SoField[] soFieldArray = this.getAllFields();
        try {
            Method method = Inventor.class.getDeclaredMethod("internalDispose", new Class[0]);
            for (int i = 0; i < soFieldArray.length; ++i) {
                ObjectManager.helperFor(Inventor.class).invokeMethod(method, soFieldArray[i], null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static native long getFieldHandle(long var0, String var2);

    public SoField[] getAllFields() {
        ObjectManager.globalLock.lock();
        try {
            SoField[] soFieldArray = this.getFieldsNativ(this.getNativeResourceHandle());
            return soFieldArray;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private native SoField[] getFieldsNativ(long var1);

    private static native void getImpl(long var0, String[] var2);

    private static native long ctorImpl();

    private static native long ctorImpl1(long var0);

    private static native boolean setImpl1(long var0, String var2);

    private static native boolean isNotifyEnabledImpl(long var0);

    private static native boolean getFieldNameImpl(long var0, long var2, String[] var4);

    private static native long getEventOutImpl(long var0, String var2);

    private static native long getEventInImpl(long var0, String var2);

    private static native long getFieldImpl(long var0, String var2);

    private static native boolean enableNotifyImpl(long var0, boolean var2);

    private static native boolean readInstanceImpl(long var0, long var2, short var4);

    private static native void setToDefaultsImpl(long var0);

    private static long ctorImpl1Sync(SoFieldContainer soFieldContainer) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoFieldContainer.ctorImpl1(soFieldContainer != null ? soFieldContainer.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoFieldContainer.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void nativeDerivedClassInit();

    private static native void initCustomClass(long var0, Inventor var2, boolean var3, String var4);

    private static native boolean fieldsAreEqualImpl(long var0, long var2);

    private static native void copyFieldValuesImpl(long var0, long var2, boolean var4);

    private static native boolean hasDefaultValuesImpl(long var0);

    protected SoFieldContainer(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected SoFieldContainer(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public void copyFieldValues(SoFieldContainer soFieldContainer) {
        this.copyFieldValues(soFieldContainer, false);
    }

    protected SoFieldContainer(SoFieldContainer soFieldContainer) {
        this(Inventor.ConstructorCommand.CreateInstance, SoFieldContainer.ctorImpl1Sync(soFieldContainer));
        Class<?> clazz = this.getClass();
        SoFieldContainer.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz));
    }

    protected SoFieldContainer() {
        this(Inventor.ConstructorCommand.CreateInstance, SoFieldContainer.ctorImplSync());
        Class<?> clazz = this.getClass();
        SoFieldContainer.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean readInstance(SoInput soInput, short s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoFieldContainer.readInstanceImpl(this.getNativeResourceHandle(), soInput != null ? soInput.getNativeResourceHandle() : Inventor.ZeroHandle, s);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean hasDefaultValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoFieldContainer.hasDefaultValuesImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean enableNotify(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl2 = SoFieldContainer.enableNotifyImpl(this.getNativeResourceHandle(), bl);
            return bl2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setToDefaults() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoFieldContainer.setToDefaultsImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFieldName(SoField soField) {
        String[] stringArray = new String[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoFieldContainer.getFieldNameImpl(this.getNativeResourceHandle(), soField != null ? soField.getNativeResourceHandle() : Inventor.ZeroHandle, stringArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return stringArray[0];
        }
        return null;
    }

    public SoField getEventOut(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoField soField = ObjectManager.getManagedObjectFor(SoField.class, SoFieldContainer.getEventOutImpl(this.getNativeResourceHandle(), string));
            return soField;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoField getField(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoField soField = ObjectManager.getManagedObjectFor(SoField.class, SoFieldContainer.getFieldImpl(this.getNativeResourceHandle(), string));
            return soField;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String get() {
        String[] stringArray = new String[1];
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoFieldContainer.getImpl(this.getNativeResourceHandle(), stringArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return stringArray[0];
    }

    public boolean isNotifyEnabled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoFieldContainer.isNotifyEnabledImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoField getEventIn(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoField soField = ObjectManager.getManagedObjectFor(SoField.class, SoFieldContainer.getEventInImpl(this.getNativeResourceHandle(), string));
            return soField;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void copyFieldValues(SoFieldContainer soFieldContainer, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoFieldContainer.copyFieldValuesImpl(this.getNativeResourceHandle(), soFieldContainer != null ? soFieldContainer.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean fieldsAreEqual(SoFieldContainer soFieldContainer) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoFieldContainer.fieldsAreEqualImpl(this.getNativeResourceHandle(), soFieldContainer != null ? soFieldContainer.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean set(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoFieldContainer.setImpl1(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    static {
        SoFieldContainer.nativeDerivedClassInit();
    }
}

