/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;

public class SoMFBufferObject
extends SoMField {
    private SoBufferObject m_newValue_set1Value;
    private SoBufferObject m_newValue_setValue;

    private static native void setValuesImpl(long var0, int var2, int var3, long[] var4);

    private static native int findImpl(long var0, long var2, boolean var4);

    private static native void setValueImpl(long var0, long var2);

    private static native boolean equalsImpl(long var0, long var2);

    private static native long getValueSizeImpl(long var0);

    private static native void set1ValueImpl(long var0, int var2, long var3);

    private static native void disableDeleteValuesImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFBufferObject.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static native long ctorImpl();

    private static native long getValueAtImpl(long var0, int var2);

    protected SoMFBufferObject(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected void internalDispose() {
        int n = this.getNum();
        if (n > 0) {
            int n2;
            SoBufferObject[] soBufferObjectArray = new SoBufferObject[n];
            for (n2 = 0; n2 < n; ++n2) {
                soBufferObjectArray[n2] = this.getValueAt(n2);
            }
            this.deleteValues(0, n);
            for (n2 = 0; n2 < n; ++n2) {
                if (soBufferObjectArray[n2] == null || !soBufferObjectArray[n2].isDisposable()) continue;
                soBufferObjectArray[n2].dispose();
            }
        }
        super.internalDispose();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoBufferObject get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBufferObject soBufferObject = this.getValueAt(n);
            return soBufferObject;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int find(SoBufferObject soBufferObject) {
        return this.find(soBufferObject, false);
    }

    @Deprecated
    public SoMFBufferObject() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFBufferObject.ctorImplSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFBufferObject) {
            SoMFBufferObject soMFBufferObject = (SoMFBufferObject)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFBufferObject.equalsImpl(this.getNativeResourceHandle(), soMFBufferObject.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFBufferObject.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMFBufferObject(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFBufferObject.ctorImplSync());
        SoMFBufferObject.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFBufferObject.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SoBufferObject soBufferObject) {
        this.onSetValue();
        this.m_newValue_setValue = soBufferObject;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFBufferObject.setValueImpl(this.getNativeResourceHandle(), soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SoBufferObject soBufferObject) {
        this.onSet1Value(n);
        this.m_newValue_set1Value = soBufferObject;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFBufferObject.set1ValueImpl(this.getNativeResourceHandle(), n, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SoBufferObject[] soBufferObjectArray) {
        int n2 = soBufferObjectArray != null ? soBufferObjectArray.length : 0;
        this.onSetValues(n, n2);
        long[] lArray = null;
        if (soBufferObjectArray != null) {
            lArray = new long[soBufferObjectArray.length];
            for (int i = 0; i < soBufferObjectArray.length; ++i) {
                lArray[i] = soBufferObjectArray[i] != null ? soBufferObjectArray[i].getNativeResourceHandle() : Inventor.ZeroHandle;
            }
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFBufferObject.setValuesImpl(this.getNativeResourceHandle(), n, n2, lArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoBufferObject getValueAt(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBufferObject soBufferObject = ObjectManager.getManagedObjectFor(SoBufferObject.class, SoMFBufferObject.getValueAtImpl(this.getNativeResourceHandle(), n));
            return soBufferObject;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(SoBufferObject soBufferObject, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFBufferObject.findImpl(this.getNativeResourceHandle(), soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

