/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class SoMFColor
extends SoMField {
    public void setValues(int n, float[][] fArray) {
        this.onSetValues(n, fArray.length);
        ObjectManager.globalLock.lock();
        try {
            this.setValuesNativ2(this.getNativeResourceHandle(), n, fArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private native void setValuesNativ2(long var1, int var3, float[][] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int n2, float[] fArray) {
        this.onSetValues(n, n2);
        if (fArray.length % 3 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 3");
        }
        if (3 * n2 > fArray.length) {
            throw new IllegalArgumentException("num is greater than num of elements provided by array");
        }
        ObjectManager.globalLock.lock();
        try {
            SoMFColor.setValuesImpl1(this.getNativeResourceHandle(), n, n2, fArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void set1ValueImpl2(long var0, int var2, float var3, float var4, float var5);

    private static native void set1ValueImpl(long var0, int var2, float[] var3);

    private static native void set1ValueImpl1(long var0, int var2, float[] var3);

    private static native void setValueImpl(long var0, float[] var2);

    private static native void set1HSVValueImpl(long var0, int var2, float var3, float var4, float var5);

    private static native int findImpl(long var0, float[] var2, boolean var3);

    private static native void set1ValueImpl3(long var0, int var2, float[] var3);

    private static native void setValuesImpl(long var0, int var2, int var3, Object[] var4);

    private static native void setHSVValueImpl1(long var0, float[] var2);

    private static native void setValuesImpl1(long var0, int var2, int var3, float[] var4);

    private static native void disableDeleteValuesImpl(long var0);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native long getValueSizeImpl(long var0);

    private static native void setHSVValueImpl(long var0, float var2, float var3, float var4);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void setValueImpl2(long var0, float var2, float var3, float var4);

    private static native void setValueImpl3(long var0, float[] var2);

    private static native void set1HSVValueImpl1(long var0, int var2, float[] var3);

    private static native Object startEditingImpl(long var0);

    private static native void setValueImpl1(long var0, float[] var2);

    private static native void finishEditingImpl(long var0);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFColor.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native long getValuesImpl(long var0, int var2);

    private static native void getValueAtImpl(long var0, int var2, float[] var3);

    protected SoMFColor(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SbColor get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbColor sbColor = this.getValueAt(n);
            return sbColor;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int find(SbColor sbColor) {
        return this.find(sbColor, false);
    }

    @Deprecated
    public SoMFColor() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFColor.ctorImplSync());
    }

    public FloatBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFColor.startEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asFloatBuffer();
    }

    public void finishEditing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.finishEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbColor[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        long l = Inventor.ZeroHandle;
        this.acquireLock(ObjectManager.globalLock);
        try {
            l = SoMFColor.getValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return SbColor.toArray(l, this.getNum() - n);
    }

    public SoMFColor(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFColor.ctorImplSync());
        SoMFColor.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    public SbColor getValueAt(int n) {
        SbColor sbColor = new SbColor();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.getValueAtImpl(this.getNativeResourceHandle(), n, sbColor.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbColor;
    }

    public FloatBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFColor.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHSVValue(float f, float f2, float f3) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.setHSVValueImpl(this.getNativeResourceHandle(), f, f2, f3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(float[] fArray) {
        this.onSetValue();
        if (fArray.length != 3) {
            throw new IllegalArgumentException("Expected size is 3");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.setValueImpl3(this.getNativeResourceHandle(), fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFColor) {
            SoMFColor soMFColor = (SoMFColor)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFColor.equalsImpl(this.getNativeResourceHandle(), soMFColor.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public void setHSVValue(float[] fArray) {
        this.onSetValue();
        if (fArray.length != 3) {
            throw new IllegalArgumentException("Expected size is 3");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.setHSVValueImpl1(this.getNativeResourceHandle(), fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFColor.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, float[] fArray) {
        int n2 = fArray != null ? fArray.length / 3 : 0;
        this.onSetValues(n, n2);
        if (fArray != null && fArray.length % 3 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 3");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.setValuesImpl1(this.getNativeResourceHandle(), n, n2, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(float f, float f2, float f3) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.setValueImpl2(this.getNativeResourceHandle(), f, f2, f3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbVec3f sbVec3f) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.setValueImpl1(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SbColor[] sbColorArray) {
        int n2 = sbColorArray != null ? sbColorArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.setValuesImpl(this.getNativeResourceHandle(), n, n2, sbColorArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1HSVValue(int n, float f, float f2, float f3) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.set1HSVValueImpl(this.getNativeResourceHandle(), n, f, f2, f3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(SbColor sbColor, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFColor.findImpl(this.getNativeResourceHandle(), sbColor != null ? sbColor.array : null, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1HSVValue(int n, float[] fArray) {
        this.onSet1Value(n);
        if (fArray.length != 3) {
            throw new IllegalArgumentException("Expected size is 3");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.set1HSVValueImpl1(this.getNativeResourceHandle(), n, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SbColor sbColor) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.set1ValueImpl(this.getNativeResourceHandle(), n, sbColor != null ? sbColor.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, float f, float f2, float f3) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.set1ValueImpl2(this.getNativeResourceHandle(), n, f, f2, f3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SbVec3f sbVec3f) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.set1ValueImpl1(this.getNativeResourceHandle(), n, sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, float[] fArray) {
        this.onSet1Value(n);
        if (fArray.length != 3) {
            throw new IllegalArgumentException("Expected size is 3");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.set1ValueImpl3(this.getNativeResourceHandle(), n, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbColor sbColor) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColor.setValueImpl(this.getNativeResourceHandle(), sbColor != null ? sbColor.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

