/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColorRGBA;
import com.openinventor.inventor.SbVec4f;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class SoMFColorRGBA
extends SoMField {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int n2, float[] fArray) {
        this.onSetValues(n, n2);
        if (fArray.length % 4 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 4");
        }
        if (4 * n2 > fArray.length) {
            throw new IllegalArgumentException("num is greater than num of elements provided by array");
        }
        ObjectManager.globalLock.lock();
        try {
            SoMFColorRGBA.setValuesImpl1(this.getNativeResourceHandle(), n, n2, fArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void set1HSVAValueImpl(long var0, int var2, float var3, float var4, float var5, float var6);

    private static native void set1HSVAValueImpl1(long var0, int var2, float[] var3);

    private static native void disableDeleteValuesImpl(long var0);

    private static native void set1ValueImpl3(long var0, int var2, float[] var3);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void setValueImpl1(long var0, float[] var2);

    private static native int findImpl(long var0, float[] var2, boolean var3);

    private static native void setValueImpl(long var0, float[] var2);

    private static native void set1ValueImpl(long var0, int var2, float[] var3);

    private static native void setValueImpl3(long var0, float[] var2);

    private static native void setHSVAValueImpl(long var0, float var2, float var3, float var4, float var5);

    private static native void setValueImpl2(long var0, float var2, float var3, float var4, float var5);

    private static native void setValuesImpl1(long var0, int var2, int var3, float[] var4);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native void set1ValueImpl1(long var0, int var2, float[] var3);

    private static native void set1ValueImpl2(long var0, int var2, float var3, float var4, float var5, float var6);

    private static native void setHSVAValueImpl1(long var0, float[] var2);

    private static native long getValueSizeImpl(long var0);

    private static native Object startEditingImpl(long var0);

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native void finishEditingImpl(long var0);

    private static native void getValueAtImpl(long var0, int var2, float[] var3);

    private static native long ctorImpl();

    private static native long getValuesImpl(long var0, int var2);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static native void setValuesImpl(long var0, int var2, int var3, Object[] var4);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFColorRGBA.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected SoMFColorRGBA(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoMFColorRGBA() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFColorRGBA.ctorImplSync());
    }

    @Deprecated
    public SbColorRGBA get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbColorRGBA sbColorRGBA = this.getValueAt(n);
            return sbColorRGBA;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int find(SbColorRGBA sbColorRGBA) {
        return this.find(sbColorRGBA, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(SbColorRGBA sbColorRGBA, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFColorRGBA.findImpl(this.getNativeResourceHandle(), sbColorRGBA != null ? sbColorRGBA.array : null, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SbColorRGBA sbColorRGBA) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.set1ValueImpl(this.getNativeResourceHandle(), n, sbColorRGBA != null ? sbColorRGBA.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, float[] fArray) {
        int n2 = fArray != null ? fArray.length / 4 : 0;
        this.onSetValues(n, n2);
        if (fArray != null && fArray.length % 4 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.setValuesImpl1(this.getNativeResourceHandle(), n, n2, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SbColorRGBA[] sbColorRGBAArray) {
        int n2 = sbColorRGBAArray != null ? sbColorRGBAArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.setValuesImpl(this.getNativeResourceHandle(), n, n2, sbColorRGBAArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void finishEditing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.finishEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FloatBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFColorRGBA.startEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asFloatBuffer();
    }

    public SoMFColorRGBA(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFColorRGBA.ctorImplSync());
        SoMFColorRGBA.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbColorRGBA[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        long l = Inventor.ZeroHandle;
        this.acquireLock(ObjectManager.globalLock);
        try {
            l = SoMFColorRGBA.getValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return SbColorRGBA.toArray(l, this.getNum() - n);
    }

    public FloatBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFColorRGBA.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public SbColorRGBA getValueAt(int n) {
        SbColorRGBA sbColorRGBA = new SbColorRGBA();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.getValueAtImpl(this.getNativeResourceHandle(), n, sbColorRGBA.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbColorRGBA;
    }

    public void setValue(SbColorRGBA sbColorRGBA) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.setValueImpl(this.getNativeResourceHandle(), sbColorRGBA != null ? sbColorRGBA.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setHSVAValue(float[] fArray) {
        this.onSetValue();
        if (fArray.length != 4) {
            throw new IllegalArgumentException("Expected size is 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.setHSVAValueImpl1(this.getNativeResourceHandle(), fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SbVec4f sbVec4f) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.set1ValueImpl1(this.getNativeResourceHandle(), n, sbVec4f != null ? sbVec4f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHSVAValue(float f, float f2, float f3, float f4) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.setHSVAValueImpl(this.getNativeResourceHandle(), f, f2, f3, f4);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbVec4f sbVec4f) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.setValueImpl1(this.getNativeResourceHandle(), sbVec4f != null ? sbVec4f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(float f, float f2, float f3, float f4) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.setValueImpl2(this.getNativeResourceHandle(), f, f2, f3, f4);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(float[] fArray) {
        this.onSetValue();
        if (fArray.length != 4) {
            throw new IllegalArgumentException("Expected size is 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.setValueImpl3(this.getNativeResourceHandle(), fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1HSVAValue(int n, float f, float f2, float f3, float f4) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.set1HSVAValueImpl(this.getNativeResourceHandle(), n, f, f2, f3, f4);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1HSVAValue(int n, float[] fArray) {
        this.onSet1Value(n);
        if (fArray.length != 4) {
            throw new IllegalArgumentException("Expected size is 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.set1HSVAValueImpl1(this.getNativeResourceHandle(), n, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFColorRGBA) {
            SoMFColorRGBA soMFColorRGBA = (SoMFColorRGBA)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFColorRGBA.equalsImpl(this.getNativeResourceHandle(), soMFColorRGBA.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFColorRGBA.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, float f, float f2, float f3, float f4) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.set1ValueImpl2(this.getNativeResourceHandle(), n, f, f2, f3, f4);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, float[] fArray) {
        this.onSet1Value(n);
        if (fArray.length != 4) {
            throw new IllegalArgumentException("Expected size is 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFColorRGBA.set1ValueImpl3(this.getNativeResourceHandle(), n, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

