/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

public class SoMFDouble
extends SoMField {
    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native double[] getValuesImpl(long var0, int var2);

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native double getValueAtImpl(long var0, int var2);

    private static native long getValueSizeImpl(long var0);

    private static native void set1ValueImpl(long var0, int var2, double var3);

    private static native void setValueImpl(long var0, double var2);

    private static native void setValuesImpl(long var0, int var2, int var3, double[] var4);

    private static native int findImpl(long var0, double var2, boolean var4);

    private static native void disableDeleteValuesImpl(long var0);

    private static native long ctorImpl();

    private static native boolean equalsImpl(long var0, long var2);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFDouble.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void finishEditingImpl(long var0);

    private static native Object startEditingImpl(long var0);

    protected SoMFDouble(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public int find(double d) {
        return this.find(d, false);
    }

    @Deprecated
    public SoMFDouble() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFDouble.ctorImplSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public double get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            double d = this.getValueAt(n);
            return d;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public DoubleBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFDouble.startEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asDoubleBuffer();
    }

    public SoMFDouble(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFDouble.ctorImplSync());
        SoMFDouble.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFDouble) {
            SoMFDouble soMFDouble = (SoMFDouble)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFDouble.equalsImpl(this.getNativeResourceHandle(), soMFDouble.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, double d) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFDouble.set1ValueImpl(this.getNativeResourceHandle(), n, d);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(double d) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFDouble.setValueImpl(this.getNativeResourceHandle(), d);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void finishEditing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFDouble.finishEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(double d, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFDouble.findImpl(this.getNativeResourceHandle(), d, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFDouble.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public double[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            double[] dArray = SoMFDouble.getValuesImpl(this.getNativeResourceHandle(), n);
            return dArray;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFDouble.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getValueAt(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            double d = SoMFDouble.getValueAtImpl(this.getNativeResourceHandle(), n);
            return d;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFDouble.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, double[] dArray) {
        int n2 = dArray != null ? dArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFDouble.setValuesImpl(this.getNativeResourceHandle(), n, n2, dArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public DoubleBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFDouble.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asDoubleBuffer();
    }
}

